/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples.providers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.examples.providers.Messages;
import org.eclipse.core.resources.semantic.examples.providers.RESTUtil;
import org.eclipse.core.resources.semantic.examples.remote.SemanticResourcesPluginExamplesCore;
import org.eclipse.core.resources.semantic.spi.CachingContentProvider;
import org.eclipse.core.resources.semantic.spi.FileCacheServiceFactory;
import org.eclipse.core.resources.semantic.spi.ICacheServiceFactory;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderREST;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.ISemanticSpiResourceInfo;
import org.eclipse.core.resources.semantic.spi.SemanticSpiResourceInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SampleCompositeResourceContentProvider
extends CachingContentProvider
implements ISemanticContentProviderREST {
    private void visitCompositeParts(ISemanticFileStore store, IVisitor visitor, IProgressMonitor monitor) throws CoreException {
        String fileext;
        String filename;
        ISemanticFileStore parent = (ISemanticFileStore)store.getParent();
        if (store.getName().contains(".")) {
            filename = store.getName().substring(0, store.getName().lastIndexOf("."));
            fileext = store.getName().substring(store.getName().lastIndexOf("."), store.getName().length());
        } else {
            filename = store.getName();
            fileext = "";
        }
        if (filename.contains("_")) {
            filename = filename.substring(0, filename.indexOf("_"));
        }
        IFileStore[] iFileStoreArray = parent.childStores(0, monitor);
        int n = iFileStoreArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore child = iFileStoreArray[n2];
            if (child.getName().equals(store.getName()) || child.getName().equals(String.valueOf(filename) + fileext) || child.getName().startsWith(String.valueOf(filename) + "_") && child.getName().endsWith(fileext)) {
                visitor.visit((ISemanticFileStore)child);
            }
            ++n2;
        }
    }

    public IStatus validateRemove(ISemanticFileStore semanticFileStore, int options, IProgressMonitor monitor) throws CoreException {
        if (semanticFileStore.getType() == 1) {
            final int[] counter = new int[1];
            final int[] counterNonReadOnly = new int[1];
            counter[0] = 0;
            counterNonReadOnly[0] = 0;
            this.visitCompositeParts(semanticFileStore, new IVisitor(){

                public void visit(ISemanticFileStore store) throws CoreException {
                    counter[0] = counter[0] + 1;
                    if (!store.isLocalOnly() && !SampleCompositeResourceContentProvider.this.isReadOnlyInternal(store)) {
                        counterNonReadOnly[0] = counterNonReadOnly[0] + 1;
                    }
                }
            }, monitor);
            if ((options & 2) != 0 && counter[0] > 1) {
                return new Status(8, SemanticResourcesPluginExamplesCore.PLUGIN_ID, NLS.bind((String)Messages.SampleCompositeResourceContentProvider_CannotDeletePartOfCompositeResource_XMSG, (Object)semanticFileStore.getPath().toString()));
            }
            if ((options & 4) == 0 && counterNonReadOnly[0] > 0) {
                return new Status(8, SemanticResourcesPluginExamplesCore.PLUGIN_ID, NLS.bind((String)Messages.SampleCompositeResourceContentProvider_SomeResourcesAreCheckedOut_XMSG, (Object)semanticFileStore.getPath().toString()));
            }
            return super.validateRemove(semanticFileStore, options, monitor);
        }
        return super.validateRemove(semanticFileStore, options, monitor);
    }

    public ICacheServiceFactory getCacheServiceFactory() throws CoreException {
        return new FileCacheServiceFactory();
    }

    public InputStream openInputStreamInternal(final ISemanticFileStore store, IProgressMonitor monitor, final CachingContentProvider.ICacheTimestampSetter timeStampSetter) throws CoreException {
        String remoteURI = this.getURIStringInternal(store);
        if (remoteURI == null) {
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_URI_NOT_FOUND, store.getPath(), NLS.bind((String)Messages.SampleCompositeResourceContentProvider_RemoteURINotSet_XMSG, (Object)store.getPath().toString()));
        }
        try {
            return RESTUtil.openInputStream(remoteURI, new RESTUtil.IRESTCallback(){

                public void setTimestamp(long timestamp) {
                    timeStampSetter.setTimestamp(timestamp);
                }

                public void setContentType(String contentType) {
                    try {
                        SampleCompositeResourceContentProvider.this.setContentTypeInternal(store, contentType);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }

                public long getTimestamp() {
                    return timeStampSetter.getTimestamp();
                }

                public String getContentType() {
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_CONNECT_EXCEPTION, store.getPath(), e.getMessage(), (Throwable)e);
        }
    }

    public void addResource(ISemanticFileStore parentStore, String name, ISemanticFileStore.ResourceType resourceType, IProgressMonitor monitor) throws CoreException {
        switch (resourceType) {
            case FOLDER_TYPE: {
                parentStore.addChildFolder(name);
                break;
            }
            default: {
                throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, parentStore.getPath(), Messages.SampleCompositeResourceContentProvider_NotSupported_XMSG);
            }
        }
    }

    public void addFileFromRemoteByURI(ISemanticFileStore parentStore, String name, URI uri, IProgressMonitor monitor) throws CoreException {
        parentStore.addChildFile(name);
        ISemanticFileStore newChild = (ISemanticFileStore)parentStore.getChild(name);
        this.setURIStringInternal(newChild, uri.toString());
        this.setReadOnly(newChild, true, monitor);
    }

    public void addFolderFromRemoteByURI(ISemanticFileStore parentStore, String name, URI uri, IProgressMonitor monitor) throws CoreException {
        parentStore.addChildFolder(name);
        ISemanticFileStore newChild = (ISemanticFileStore)parentStore.getChild(name);
        this.setURIStringInternal(newChild, uri.toString());
    }

    public ISemanticSpiResourceInfo fetchResourceInfo(ISemanticFileStore semanticFileStore, int options, IProgressMonitor monitor) throws CoreException {
        return new SemanticSpiResourceInfo(options, false, false, this.isReadOnlyInternal(semanticFileStore), !semanticFileStore.isLocalOnly(), this.getURIStringInternal(semanticFileStore), this.getContentTypeInternal(semanticFileStore));
    }

    public void removeResource(ISemanticFileStore semanticFileStore, final IProgressMonitor monitor) throws CoreException {
        if (semanticFileStore.getType() == 1) {
            this.visitCompositeParts(semanticFileStore, new IVisitor(){

                public void visit(ISemanticFileStore store) throws CoreException {
                    SampleCompositeResourceContentProvider.this.dropCache(store, monitor, SampleCompositeResourceContentProvider.this.deleteAllVisitor, new MultiStatus(SemanticResourcesPluginExamplesCore.PLUGIN_ID, 0, null, null));
                    store.remove(monitor);
                }
            }, monitor);
        } else {
            this.dropCache(semanticFileStore, monitor, this.deleteAllVisitor, new MultiStatus(SemanticResourcesPluginExamplesCore.PLUGIN_ID, 0, null, null));
            semanticFileStore.remove(monitor);
        }
    }

    public void revertChanges(ISemanticFileStore semanticFileStore, final IProgressMonitor monitor) throws CoreException {
        if (semanticFileStore.getType() != 1) {
            throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, semanticFileStore.getPath(), Messages.SampleCompositeResourceContentProvider_NotSupported_XMSG);
        }
        this.visitCompositeParts(semanticFileStore, new IVisitor(){

            public void visit(ISemanticFileStore store) throws CoreException {
                if (!store.isLocalOnly()) {
                    SampleCompositeResourceContentProvider.this.dropCache(store, monitor, SampleCompositeResourceContentProvider.this.deleteAllVisitor, new MultiStatus(SemanticResourcesPluginExamplesCore.PLUGIN_ID, 0, null, null));
                    SampleCompositeResourceContentProvider.this.setReadOnlyInternal(store, true);
                }
            }
        }, monitor);
    }

    public void setReadOnly(ISemanticFileStore semanticFileStore, final boolean readonly, IProgressMonitor monitor) throws CoreException {
        this.visitCompositeParts(semanticFileStore, new IVisitor(){

            public void visit(ISemanticFileStore store) throws CoreException {
                if (!store.isLocalOnly()) {
                    SampleCompositeResourceContentProvider.this.setReadOnlyInternal(store, readonly);
                }
            }
        }, monitor);
    }

    public void synchronizeContentWithRemote(ISemanticFileStore semanticFileStore, SyncDirection direction, IProgressMonitor monitor, MultiStatus status) {
        if (semanticFileStore.getType() == 1) {
            if (semanticFileStore.isLocalOnly()) {
                return;
            }
            if (direction == SyncDirection.INCOMING || direction == SyncDirection.BOTH) {
                this.dropCache(semanticFileStore, monitor, this.deleteAllVisitor, status);
                this.fillCache(semanticFileStore, monitor, status);
            }
        } else {
            IFileStore[] childStores;
            try {
                childStores = semanticFileStore.childStores(0, monitor);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
                return;
            }
            IFileStore[] iFileStoreArray = childStores;
            int n = childStores.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore store = iFileStoreArray[n2];
                if (store instanceof ISemanticFileStore) {
                    this.synchronizeContentWithRemote((ISemanticFileStore)store, direction, monitor, status);
                }
                ++n2;
            }
        }
    }

    public IStatus validateEdit(ISemanticFileStore[] semanticFileStore, Object shell) {
        MultiStatus status = new MultiStatus(SemanticResourcesPluginExamplesCore.PLUGIN_ID, 0, null, null);
        ISemanticFileStore[] iSemanticFileStoreArray = semanticFileStore;
        int n = semanticFileStore.length;
        int n2 = 0;
        while (n2 < n) {
            ISemanticFileStore iSemanticFileStore = iSemanticFileStoreArray[n2];
            try {
                this.setReadOnly(iSemanticFileStore, false, null);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
            ++n2;
        }
        return status;
    }

    public IStatus validateSave(ISemanticFileStore semanticFileStore) {
        return this.validateEdit(new ISemanticFileStore[]{semanticFileStore}, null);
    }

    public String getURIString(ISemanticFileStore semanticFileStore) throws CoreException {
        return this.getURIStringInternal(semanticFileStore);
    }

    public void setURIString(ISemanticFileStore store, URI uri, IProgressMonitor monitor) throws CoreException {
        if (store.getType() == 1) {
            if (!store.isLocalOnly()) {
                this.setURIStringInternal(store, uri.toString());
                this.dropCache(store, monitor, this.deleteAllVisitor, new MultiStatus(SemanticResourcesPluginExamplesCore.PLUGIN_ID, 0, null, null));
                this.setReadOnlyInternal(store, true);
            }
        } else {
            throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, store.getPath(), Messages.SampleCompositeResourceContentProvider_NotSupported_XMSG);
        }
    }

    public static interface IVisitor {
        public void visit(ISemanticFileStore var1) throws CoreException;
    }
}

