/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.contacts.views;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.demo.contacts.handlers.ThemeUtil;
import org.eclipse.e4.demo.contacts.model.Contact;
import org.eclipse.e4.demo.contacts.views.DetailComposite;
import org.eclipse.e4.ui.model.application.MDirtyable;
import org.eclipse.e4.ui.model.application.MUILabel;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DetailsView {
    private final DetailComposite detailComposite;
    private final MDirtyable dirtyable;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private ECommandService commandService;
    @Inject
    private IStylingEngine engine;
    @Inject
    private MUILabel uiItem;

    @Inject
    public DetailsView(Composite parent, MDirtyable dirtyable) {
        this.detailComposite = new DetailComposite(dirtyable, parent, 0);
        this.dirtyable = dirtyable;
        GridLayoutFactory.fillDefaults().generateLayout(parent);
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void doSave(@Optional IProgressMonitor monitor) throws IOException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Saving contact details to vCard...", 16);
        Contact originalContact = this.detailComposite.getOriginalContact();
        Contact modifiedContact = this.detailComposite.getModifiedContact();
        this.saveAsVCard(modifiedContact, modifiedContact.getSourceFile());
        originalContact.setCity(modifiedContact.getCity());
        Thread.sleep(50L);
        monitor.worked(1);
        originalContact.setCompany(modifiedContact.getCompany());
        Thread.sleep(50L);
        monitor.worked(1);
        originalContact.setCountry(modifiedContact.getCountry());
        Thread.sleep(50L);
        monitor.worked(1);
        originalContact.setEmail(modifiedContact.getEmail());
        Thread.sleep(50L);
        monitor.worked(1);
        originalContact.setFirstName(modifiedContact.getFirstName());
        Thread.sleep(50L);
        monitor.worked(1);
        originalContact.setJobTitle(modifiedContact.getJobTitle());
        Thread.sleep(50L);
        monitor.worked(1);
        originalContact.setLastName(modifiedContact.getLastName());
        Thread.sleep(50L);
        monitor.worked(1);
        originalContact.setMiddleName(modifiedContact.getMiddleName());
        Thread.sleep(50L);
        monitor.worked(1);
        originalContact.setMobile(modifiedContact.getMobile());
        Thread.sleep(50L);
        monitor.worked(1);
        originalContact.setNote(modifiedContact.getNote());
        Thread.sleep(50L);
        monitor.worked(1);
        originalContact.setPhone(modifiedContact.getPhone());
        Thread.sleep(50L);
        monitor.worked(1);
        originalContact.setState(modifiedContact.getState());
        Thread.sleep(50L);
        monitor.worked(1);
        originalContact.setStreet(modifiedContact.getStreet());
        Thread.sleep(50L);
        monitor.worked(1);
        originalContact.setTitle(modifiedContact.getTitle());
        Thread.sleep(50L);
        monitor.worked(1);
        originalContact.setWebPage(modifiedContact.getWebPage());
        Thread.sleep(50L);
        monitor.worked(1);
        originalContact.setZip(modifiedContact.getZip());
        Thread.sleep(50L);
        monitor.worked(1);
        this.updatePartTitle(originalContact);
        monitor.done();
        this.dirtyable.setDirty(false);
    }

    private String getName(Contact contact, String charSet) {
        StringBuilder builder = new StringBuilder();
        builder.append("N;").append(charSet).append(':');
        builder.append(contact.getLastName()).append(';');
        builder.append(contact.getFirstName()).append(';');
        builder.append(contact.getMiddleName());
        String title = contact.getTitle();
        if (title.length() != 0) {
            builder.append(';').append(title);
        }
        builder.append('\n');
        return builder.toString();
    }

    private void saveAsVCard(Contact contact, String fileName) throws IOException {
        String charSet = "CHARSET=" + Charset.defaultCharset().name();
        String vCard = "BEGIN:VCARD\nVERSION:2.1\n" + this.getName(contact, charSet) + "FN;" + charSet + ":" + contact.getFirstName() + " " + contact.getLastName() + "\nORG;" + charSet + ":" + contact.getCompany() + "\nTITLE:" + contact.getJobTitle() + "\nNOTE:" + contact.getNote() + "\nTEL;WORK;VOICE:" + contact.getPhone() + "\nTEL;CELL;VOICE:" + contact.getMobile() + "\nADR;WORK;" + charSet + ":" + ";;" + contact.getStreet() + ";" + contact.getCity() + ";" + contact.getState() + ";" + contact.getZip() + ";" + contact.getCountry() + "\nURL;WORK:" + contact.getWebPage() + "\nEMAIL;PREF;INTERNET:" + contact.getEmail() + "\n";
        if (!contact.getJpegString().equals("")) {
            vCard = String.valueOf(vCard) + "PHOTO;TYPE=JPEG;ENCODING=BASE64:\n " + contact.getJpegString() + "\n";
        }
        vCard = String.valueOf(vCard) + "END:VCARD\n";
        PrintWriter out = new PrintWriter(fileName, "Cp1252");
        out.println(vCard);
        out.close();
    }

    private void updatePartTitle(Contact contact) {
        StringBuffer title = new StringBuffer("Details of ");
        title.append(contact.getFirstName()).append(' ').append(contact.getLastName());
        this.uiItem.setLabel(title.toString());
    }

    @Inject
    public void setSelection(@Optional @Named(value="selection") Contact contact) {
        if (contact != null) {
            if (this.dirtyable.isDirty()) {
                MessageDialog dialog = new MessageDialog(this.detailComposite.getShell(), "Save vCard", null, "The current vCard has been modified. Save changes?", 5, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                dialog.create();
                ThemeUtil.applyDialogStyles(this.engine, (Control)dialog.getShell());
                if (dialog.open() == 0) {
                    ParameterizedCommand saveCommand = this.commandService.createCommand("contacts.save", Collections.EMPTY_MAP);
                    this.handlerService.executeHandler(saveCommand);
                }
            }
            this.updatePartTitle(contact);
        } else {
            this.uiItem.setLabel("Details");
        }
        this.dirtyable.setDirty(false);
        this.detailComposite.update(contact);
    }
}

