/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import junit.framework.Assert;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.ISemanticProject;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.resources.semantic.ISemanticResourceInfo;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFile;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFolder;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStore;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStoreTransient;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.resources.semantic.test.TestsContentProviderUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.RepositoryProvider;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public abstract class TestsContentProviderBase
extends TestsContentProviderUtil {
    public TestsContentProviderBase(boolean autoRefresh, String projectName, String providerName) {
        super(autoRefresh, projectName, providerName);
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        TestsContentProviderUtil.beforeClass();
    }

    public static void afterClass() throws Exception {
        TestsContentProviderUtil.afterClass();
    }

    public abstract RemoteFile getRemoteFile();

    @Before
    public void beforeMethod() throws Exception {
        String[] roots;
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(this.projectName);
        if (project.exists()) {
            throw new IllegalStateException("Project exists");
        }
        IWorkspaceRunnable myRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProjectDescription description = workspace.newProjectDescription(TestsContentProviderBase.this.projectName);
                try {
                    description.setLocationURI(new URI("semanticfs:/" + TestsContentProviderBase.this.projectName));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                project.create(description, monitor);
                project.open(monitor);
                RepositoryProvider.map((IProject)project, (String)"org.eclipse.core.internal.resources.semantic.DelegatingRepositoryProvider");
                ISemanticProject spr = (ISemanticProject)project.getAdapter(ISemanticProject.class);
                RemoteStoreTransient store = (RemoteStoreTransient)project.getAdapter(RemoteStoreTransient.class);
                store.reset();
                RemoteFolder f1 = store.getRootFolder().addFolder("Folder1");
                f1.addFolder("Folder11");
                try {
                    f1.addFile("File1", "Hello".getBytes("UTF-8"), store.newTime());
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                HashMap<QualifiedName, String> properties = new HashMap<QualifiedName, String>();
                properties.put(TEMPLATE_PROP, "World");
                spr.addFolder("root", TestsContentProviderBase.this.providerName, properties, TestsContentProviderBase.this.options, monitor);
                project.refreshLocal(2, monitor);
            }
        };
        workspace.run(myRunnable, (ISchedulingRule)workspace.getRoot(), 1, null);
        this.testProject = project;
        String projectName1 = this.testProject.getName();
        String[] stringArray = roots = ((ISemanticFileSystem)EFS.getFileSystem((String)"semanticfs")).getRootNames();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            String root = stringArray[n2];
            if (root.equals(projectName1)) {
                return;
            }
            ++n2;
        }
        Assert.fail((String)"Project should be in the list of root names");
    }

    @After
    public void afterMethod() throws Exception {
        RemoteStoreTransient store = (RemoteStoreTransient)this.testProject.getAdapter(RemoteStoreTransient.class);
        store.reset();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(this.projectName);
        this.testProject = null;
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.delete(true, monitor);
                project.refreshLocal(2, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testTemplateProperties() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        ISemanticFileStore store = (ISemanticFileStore)EFS.getStore((URI)root.getLocationURI());
        Assert.assertTrue((boolean)store.getPersistentProperties().containsKey(TEMPLATE_PROP));
    }

    @Test
    public void testAddFileFromRemoteAndDeleteFolder() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        final IFolder parent = root.getFolder("Folder1");
        Assert.assertEquals((String)"Folder existence", (boolean)false, (boolean)parent.exists());
        final IFile file = parent.getFile("File1");
        Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
        Object runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sfr = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
                ISemanticFile sfile = sfr.addFile("File1", TestsContentProviderBase.this.options, monitor);
                Assert.assertTrue((boolean)sfile.getAdaptedFile().equals((Object)file));
                if (!TestsContentProviderBase.this.autoRefresh) {
                    Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
                    file.getParent().refreshLocal(2, monitor);
                }
                Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
                InputStream is = null;
                try {
                    is = sfile.getAdaptedFile().getContents();
                    try {
                        Assert.assertTrue((String)"Too few bytes available", (is.available() > 0 ? 1 : 0) != 0);
                    }
                    catch (IOException e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
                finally {
                    Util.safeClose((InputStream)is);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)this.testProject, 0, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
        Assert.assertEquals((String)"Folder existence", (boolean)true, (boolean)parent.exists());
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sfr = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
                try {
                    sfr.addResource("File1", TestsContentProviderBase.this.options, monitor);
                }
                catch (Exception exception) {}
                try {
                    sfr.addResource("notexisting", TestsContentProviderBase.this.options, monitor);
                    Assert.fail((String)"Exception should have been thrown for adding nonexisting resource");
                }
                catch (CoreException coreException) {}
                try {
                    IFolder test = TestsContentProviderBase.this.testProject.getFolder("FileTarget");
                    file.move(test.getFullPath(), false, monitor);
                    Assert.fail((String)"Exception should have been thrown for local move of semantic file");
                }
                catch (OperationCanceledException operationCanceledException) {
                    monitor.setCanceled(false);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((String)"File should exist", (boolean)file.exists());
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sf = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
                sf.remove(TestsContentProviderBase.this.options, monitor);
                if (!TestsContentProviderBase.this.autoRefresh) {
                    Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
                    file.getParent().refreshLocal(2, monitor);
                }
                Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((String)"File should not exist", (boolean)file.exists());
    }

    @Test
    public void testAddFileAndImplicitFolderLocalFlag() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        final IFolder parent = root.getFolder("Folder1");
        Assert.assertEquals((String)"Folder existence", (boolean)false, (boolean)parent.exists());
        final IFile file = parent.getFile("File1");
        Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sfr = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
                ISemanticFile sfile = sfr.addFile("File1", TestsContentProviderBase.this.options, monitor);
                Assert.assertTrue((boolean)sfile.getAdaptedFile().equals((Object)file));
                if (!TestsContentProviderBase.this.autoRefresh) {
                    Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
                    file.getParent().refreshLocal(2, monitor);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, ResourcesPlugin.getWorkspace().getRuleFactory().refreshRule((IResource)file), 0, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
        Assert.assertEquals((String)"Folder existence", (boolean)true, (boolean)parent.exists());
        ISemanticFolder sFolder = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
        ISemanticResourceInfo info = sFolder.fetchResourceInfo(8, null);
        Assert.assertTrue((String)"Folder should be local", (boolean)info.isLocalOnly());
    }

    @Test
    public void testAddFileAndHandleProperties() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        final IFolder parent = root.getFolder("Folder1");
        Assert.assertEquals((String)"Folder existence", (boolean)false, (boolean)parent.exists());
        final IFile file = parent.getFile("File1");
        Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
        Object runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sfr = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
                ISemanticFile sfile = sfr.addFile("File1", TestsContentProviderBase.this.options, monitor);
                Assert.assertTrue((boolean)sfile.getAdaptedFile().equals((Object)file));
                if (!TestsContentProviderBase.this.autoRefresh) {
                    Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
                    file.getParent().refreshLocal(2, monitor);
                }
                Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
                InputStream is = null;
                try {
                    is = sfile.getAdaptedFile().getContents();
                    try {
                        Assert.assertTrue((String)"Too few bytes available", (is.available() > 0 ? 1 : 0) != 0);
                    }
                    catch (IOException e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
                finally {
                    Util.safeClose((InputStream)is);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)this.testProject, 0, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
        Assert.assertEquals((String)"Folder existence", (boolean)true, (boolean)parent.exists());
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sfile = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                sfile.setPersistentProperty(DUMMY_PROP, "Some Value");
                Assert.assertNotNull((String)"Property should not be null", (Object)sfile.getPersistentProperty(DUMMY_PROP));
                Assert.assertTrue((String)"Map should contain the property", (boolean)sfile.getPersistentProperties().containsKey(DUMMY_PROP));
                Assert.assertFalse((String)"Map should not contain the property", (boolean)sfile.getPersistentProperties().containsKey(DUMMY_PROP2));
                sfile.setPersistentProperty(DUMMY_PROP2, "Some other Value");
                Assert.assertTrue((String)"Map should contain the property", (boolean)sfile.getPersistentProperties().containsKey(DUMMY_PROP2));
                sfile.setPersistentProperty(DUMMY_PROP2, null);
                Assert.assertFalse((String)"Map should not contain the property", (boolean)sfile.getPersistentProperties().containsKey(DUMMY_PROP2));
                sfile.setPersistentProperty(DUMMY_PROP, null);
                Assert.assertFalse((String)"Map should not contain the property", (boolean)sfile.getPersistentProperties().containsKey(DUMMY_PROP));
                sfile.setPersistentProperty(DUMMY_PROP, null);
                Assert.assertNull((String)"Property should be null", (Object)sfile.getPersistentProperty(DUMMY_PROP));
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sfile = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                sfile.setSessionProperty(DUMMY_PROP, (Object)"Some Value");
                Assert.assertNotNull((String)"Property should not be null", (Object)sfile.getSessionProperty(DUMMY_PROP));
                Assert.assertTrue((String)"Map should contain the property", (boolean)sfile.getSessionProperties().containsKey(DUMMY_PROP));
                Assert.assertFalse((String)"Map should not contain the property", (boolean)sfile.getSessionProperties().containsKey(DUMMY_PROP2));
                sfile.setSessionProperty(DUMMY_PROP2, (Object)"Some other Value");
                Assert.assertTrue((String)"Map should contain the property", (boolean)sfile.getSessionProperties().containsKey(DUMMY_PROP2));
                sfile.setSessionProperty(DUMMY_PROP2, null);
                Assert.assertFalse((String)"Map should not contain the property", (boolean)sfile.getSessionProperties().containsKey(DUMMY_PROP2));
                sfile.setSessionProperty(DUMMY_PROP, null);
                Assert.assertFalse((String)"Map should not contain the property", (boolean)sfile.getSessionProperties().containsKey(DUMMY_PROP));
                sfile.setSessionProperty(DUMMY_PROP, null);
                Assert.assertNull((String)"Property should be null", (Object)sfile.getSessionProperty(DUMMY_PROP));
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sf = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                sf.remove(TestsContentProviderBase.this.options, null);
                if (!TestsContentProviderBase.this.autoRefresh) {
                    Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
                    file.getParent().refreshLocal(2, monitor);
                }
                Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((String)"File should not exist", (boolean)file.exists());
    }

    @Test
    @Ignore
    public void testTimestamp() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        IFolder parent = root.getFolder("Folder1");
        final IFile file = parent.getFile("File1");
        Assert.assertFalse((boolean)file.exists());
        final ISemanticFolder sf = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
        Object runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                sf.addFile("File1", TestsContentProviderBase.this.options, null);
                if (!TestsContentProviderBase.this.autoRefresh) {
                    Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
                    sf.getAdaptedContainer().refreshLocal(2, monitor);
                }
                Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
        ISemanticFileStore store = (ISemanticFileStore)EFS.getStore((URI)file.getLocationURI());
        long stamp = store.fetchInfo().getLastModified();
        Assert.assertEquals((String)"Wrong date", (long)this.getRemoteFile().getTimestamp(), (long)stamp);
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                sf.getResource("File1").remove(TestsContentProviderBase.this.options, monitor);
                if (!TestsContentProviderBase.this.autoRefresh) {
                    Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
                    sf.getAdaptedContainer().refreshLocal(2, monitor);
                }
                Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testSetTimestamp() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        IFolder parent = root.getFolder("Folder1");
        final IFile file = parent.getFile("File1");
        Assert.assertFalse((boolean)file.exists());
        final ISemanticFolder sf = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
        Object runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile rfile = sf.addFile("File1", TestsContentProviderBase.this.options, null);
                if (!TestsContentProviderBase.this.autoRefresh) {
                    Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
                    sf.getAdaptedContainer().refreshLocal(2, monitor);
                }
                Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
                long localTime = rfile.getAdaptedFile().getLocalTimeStamp();
                RemoteStoreTransient rstore = (RemoteStoreTransient)TestsContentProviderBase.this.testProject.getAdapter(RemoteStoreTransient.class);
                long newTime = rstore.newTime();
                rfile.getAdaptedFile().setLocalTimeStamp(newTime);
                if (!TestsContentProviderBase.this.autoRefresh) {
                    sf.getAdaptedContainer().refreshLocal(2, monitor);
                }
                ISemanticFileStore store = (ISemanticFileStore)EFS.getStore((URI)file.getLocationURI());
                long stamp = store.fetchInfo().getLastModified();
                Assert.assertFalse((String)"Timestamps should differ", (localTime == newTime ? 1 : 0) != 0);
                Assert.assertEquals((String)"Timstamps should not differ", (long)stamp, (long)newTime);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                sf.getResource("File1").remove(TestsContentProviderBase.this.options, monitor);
                if (!TestsContentProviderBase.this.autoRefresh) {
                    Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
                    sf.getAdaptedContainer().refreshLocal(2, monitor);
                }
                Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testExistence() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        IFolder parent = root.getFolder("Folder1");
        final IFile file = parent.getFile("File1");
        Assert.assertFalse((boolean)file.exists());
        final IFile nofile = parent.getFile("NoFile");
        Assert.assertFalse((boolean)file.exists());
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sf = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                Assert.assertTrue((String)"Should exist remotely", (boolean)sf.fetchResourceInfo(32, monitor).existsRemotely());
                sf = (ISemanticFile)nofile.getAdapter(ISemanticFile.class);
                Assert.assertFalse((String)"Should not exist remotely", (boolean)sf.fetchResourceInfo(32, monitor).existsRemotely());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testLockAndUnlock() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        IFolder parent = root.getFolder("Folder1");
        final IFile file = parent.getFile("File1");
        final ISemanticFolder sf = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sfile = sf.addFile("File1", TestsContentProviderBase.this.options, null);
                if (!TestsContentProviderBase.this.autoRefresh) {
                    Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
                    sf.getAdaptedContainer().refreshLocal(2, monitor);
                }
                Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
                ISemanticResourceInfo info = sfile.fetchResourceInfo(4, monitor);
                if (!info.isLockingSupported()) {
                    return;
                }
                Assert.assertFalse((String)"Should not be locked", (boolean)sfile.fetchResourceInfo(2, monitor).isLocked());
                sfile.lockResource(TestsContentProviderBase.this.options, monitor);
                Assert.assertTrue((String)"Should be locked", (boolean)sfile.fetchResourceInfo(2, monitor).isLocked());
                sfile.unlockResource(TestsContentProviderBase.this.options, monitor);
                Assert.assertFalse((String)"Should not be locked", (boolean)sfile.fetchResourceInfo(2, monitor).isLocked());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testAddResourceFromRemoteAndAddMarker() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        final IFolder parent = root.getFolder("Folder1");
        final IFile file = parent.getFile("File1");
        Assert.assertFalse((String)"File should not exist", (boolean)file.exists());
        Object runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sfolder = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
                ISemanticResource filres = sfolder.addResource("File1", TestsContentProviderBase.this.options, monitor);
                Assert.assertTrue((boolean)(filres instanceof ISemanticFile));
                if (!TestsContentProviderBase.this.autoRefresh) {
                    Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
                    file.getParent().refreshLocal(2, monitor);
                }
                Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = file.createMarker("org.eclipse.core.resources.problemmarker");
                marker.setAttribute("message", (Object)"Some message");
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sf = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                sf.remove(TestsContentProviderBase.this.options, null);
                if (!TestsContentProviderBase.this.autoRefresh) {
                    Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
                    file.getParent().refreshLocal(2, monitor);
                }
                Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
    }

    @Test
    public void testAddFolderFromRemote() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        final IFolder parent = root.getFolder("Folder1");
        final IFolder folder = parent.getFolder("Folder11");
        Assert.assertEquals((String)"Folder existence", (boolean)false, (boolean)folder.exists());
        Object runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sfolder = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
                sfolder.addFolder("Folder11", TestsContentProviderBase.this.options, monitor);
                if (!TestsContentProviderBase.this.autoRefresh) {
                    Assert.assertEquals((String)"File existence", (boolean)false, (boolean)folder.exists());
                    folder.getParent().refreshLocal(2, monitor);
                }
                Assert.assertEquals((String)"File existence", (boolean)true, (boolean)folder.exists());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((String)"Folder existence", (boolean)true, (boolean)folder.exists());
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sf = (ISemanticFolder)folder.getAdapter(ISemanticFolder.class);
                sf.remove(TestsContentProviderBase.this.options, null);
                if (!TestsContentProviderBase.this.autoRefresh) {
                    Assert.assertEquals((String)"File existence", (boolean)true, (boolean)folder.exists());
                    folder.getParent().refreshLocal(2, monitor);
                }
                Assert.assertEquals((String)"File existence", (boolean)false, (boolean)folder.exists());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((String)"Folder existence", (boolean)false, (boolean)folder.exists());
    }

    @Test
    public void testChangeFileContentLocalAndRevert() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        final IFolder parent = root.getFolder("Folder1");
        final IFile file = parent.getFile("File1");
        Assert.assertFalse((String)"File should not exist", (boolean)file.exists());
        Object runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sfr = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
                sfr.addFile("File1", TestsContentProviderBase.this.options, monitor);
                if (!TestsContentProviderBase.this.autoRefresh) {
                    file.getParent().refreshLocal(2, monitor);
                }
                Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        this.assertContentsEqual(file, "Hello");
        long oldStamp = file.getModificationStamp();
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    ISemanticFile sf = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                    IStatus stat = sf.validateEdit(null);
                    Assert.assertTrue((String)"ValidateEdit should have returned OK", (boolean)stat.isOK());
                    file.setContents((InputStream)new ByteArrayInputStream("NewString".getBytes("UTF-8")), 2, monitor);
                }
                catch (UnsupportedEncodingException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        this.assertContentsEqual(file, "NewString");
        long newStamp = file.getModificationStamp();
        Assert.assertFalse((String)"Timestamp should differ", (oldStamp == newStamp ? 1 : 0) != 0);
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    ISemanticFile sf = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                    IStatus stat = sf.validateEdit(null);
                    Assert.assertTrue((String)"ValidateEdit should have returned OK", (boolean)stat.isOK());
                    file.appendContents((InputStream)new ByteArrayInputStream("Appended".getBytes("UTF-8")), 2, monitor);
                    if (!TestsContentProviderBase.this.autoRefresh) {
                        file.getParent().refreshLocal(2, monitor);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        this.assertContentsEqual(file, "NewStringAppended");
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sf = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                sf.revertChanges(TestsContentProviderBase.this.options, monitor);
                if (!TestsContentProviderBase.this.autoRefresh) {
                    file.getParent().refreshLocal(2, monitor);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        this.assertContentsEqual(file, "Hello");
        long revertedStamp = file.getModificationStamp();
        Assert.assertFalse((String)"Timestamp should have been reverted", (oldStamp == revertedStamp ? 1 : 0) != 0);
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sf = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                sf.remove(TestsContentProviderBase.this.options, null);
                if (!TestsContentProviderBase.this.autoRefresh) {
                    file.getParent().refreshLocal(2, monitor);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
    }

    @Test
    @Ignore
    public void testChangeFileContentRemote() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        final IFolder parent = root.getFolder("Folder1");
        final IFile file = parent.getFile("File1");
        Assert.assertFalse((String)"File should not exist", (boolean)file.exists());
        Object runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sfr = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
                sfr.addFile("File1", TestsContentProviderBase.this.options, monitor);
                if (!TestsContentProviderBase.this.autoRefresh) {
                    file.getParent().refreshLocal(2, monitor);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((String)"File should exist", (boolean)file.exists());
        this.assertContentsEqual(file, "Hello");
        Assert.assertEquals((String)"Wrong remote content", (String)"Hello", (String)new String(this.getRemoteFile().getContent(), "UTF-8"));
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sf = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                IStatus stat = sf.validateEdit(null);
                Assert.assertTrue((String)"ValidateEdit should have returned OK", (boolean)stat.isOK());
                try {
                    file.setContents((InputStream)new ByteArrayInputStream("NewString".getBytes("UTF-8")), 2, (IProgressMonitor)new NullProgressMonitor());
                    sf.synchronizeContentWithRemote(SyncDirection.OUTGOING, TestsContentProviderBase.this.options, monitor);
                    if (TestsContentProviderBase.this.getRemoteFile().getStore() instanceof RemoteStore) {
                        ((RemoteStore)TestsContentProviderBase.this.getRemoteFile().getStore()).serialize(monitor);
                    }
                    if (!TestsContentProviderBase.this.autoRefresh) {
                        file.getParent().refreshLocal(2, monitor);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        this.assertContentsEqual(file, "NewString");
        Assert.assertEquals((String)"Wrong remote content", (String)"NewString", (String)new String(this.getRemoteFile().getContent(), "UTF-8"));
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sf = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                sf.synchronizeContentWithRemote(SyncDirection.OUTGOING, TestsContentProviderBase.this.options, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sf = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                sf.remove(TestsContentProviderBase.this.options, null);
                if (!TestsContentProviderBase.this.autoRefresh) {
                    file.getParent().refreshLocal(2, monitor);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((String)"File should not exist", (boolean)file.exists());
    }

    @Test
    public void testChangeFileStateRemote() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        final IFolder parent = root.getFolder("Folder1");
        final IFile file = parent.getFile("File1");
        Assert.assertFalse((String)"File should not exist", (boolean)file.exists());
        Object runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sfr = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
                sfr.addFile("File1", TestsContentProviderBase.this.options, monitor);
                if (!TestsContentProviderBase.this.autoRefresh) {
                    file.getParent().refreshLocal(2, monitor);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((String)"File should exist", (boolean)file.exists());
        ISemanticFile sfile = (ISemanticFile)file.getAdapter(ISemanticFile.class);
        if (!sfile.fetchResourceInfo(4, null).isLockingSupported()) {
            return;
        }
        Assert.assertEquals((String)"Wrong lock state", (boolean)false, (boolean)sfile.fetchResourceInfo(2, null).isLocked());
        this.getRemoteFile().setLocked(true);
        Assert.assertEquals((String)"Wrong lock state", (boolean)false, (boolean)sfile.fetchResourceInfo(2, null).isLocked());
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sf = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                sf.synchronizeContentWithRemote(SyncDirection.INCOMING, 0, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((String)"Wrong lock state", (boolean)true, (boolean)sfile.fetchResourceInfo(2, null).isLocked());
        this.getRemoteFile().setLocked(false);
        Assert.assertEquals((String)"Wrong lock state", (boolean)true, (boolean)sfile.fetchResourceInfo(2, null).isLocked());
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sf = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                sf.synchronizeContentWithRemote(SyncDirection.INCOMING, 0, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((String)"Wrong lock state", (boolean)false, (boolean)sfile.fetchResourceInfo(2, null).isLocked());
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sf = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                sf.remove(TestsContentProviderBase.this.options, null);
                if (!TestsContentProviderBase.this.autoRefresh) {
                    file.getParent().refreshLocal(2, monitor);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((String)"File should not exist", (boolean)file.exists());
    }

    @Test
    public void testCreateAndDeleteRemote() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        IFolder parent = root.getFolder("Folder1");
        final ISemanticFolder sf = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
        Object runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    sf.createFileRemotely("NewFromClient", (InputStream)new ByteArrayInputStream("RemoteContent".getBytes("UTF-8")), null, TestsContentProviderBase.this.options, monitor);
                    sf.createResourceRemotely("NewFromClient2", null, TestsContentProviderBase.this.options, monitor);
                    if (!TestsContentProviderBase.this.autoRefresh) {
                        sf.getAdaptedContainer().refreshLocal(0, monitor);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((String)"Child should be available", (boolean)sf.hasResource("NewFromClient"));
        final ISemanticResource res = sf.getResource("NewFromClient");
        final ISemanticResource res2 = sf.getResource("NewFromClient2");
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                res.deleteRemotely(TestsContentProviderBase.this.options, monitor);
                res2.deleteRemotely(TestsContentProviderBase.this.options, monitor);
                if (!TestsContentProviderBase.this.autoRefresh) {
                    sf.getAdaptedContainer().refreshLocal(2, monitor);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((String)"Child should not be available", (boolean)sf.hasResource("NewFromClient"));
    }

    @Test
    public void testSetReadOnly() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        IFolder parent = root.getFolder("Folder1");
        final IFile file = parent.getFile("File1");
        final ISemanticFolder sf = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sfile = sf.addFile("File1", TestsContentProviderBase.this.options, monitor);
                Assert.assertTrue((String)"File should be read-only", (boolean)sfile.fetchResourceInfo(16, null).isReadOnly());
                ISemanticFileStore store = (ISemanticFileStore)EFS.getStore((URI)file.getLocationURI());
                FileInfo info = new FileInfo();
                info.setAttribute(2, false);
                store.putInfo((IFileInfo)info, 1024, null);
                Assert.assertFalse((String)"File should not be read-only", (boolean)sfile.fetchResourceInfo(16, null).isReadOnly());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testValidateEdit() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        IFolder parent = root.getFolder("Folder1");
        IFile file = parent.getFile("File1");
        final ISemanticFolder sf = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
        final IStatus[] result = new IStatus[1];
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sfile = sf.addFile("File1", TestsContentProviderBase.this.options, monitor);
                result[0] = sfile.validateEdit((Object)monitor);
                sfile.remove(TestsContentProviderBase.this.options, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        IStatus stat = result[0];
        Assert.assertTrue((String)"ValidateEdit should be ok", (stat.getSeverity() == 0 ? 1 : 0) != 0);
        file = parent.getFile("File2");
        ISemanticFile sfile = (ISemanticFile)file.getAdapter(ISemanticFile.class);
        stat = sfile.validateRemoteDelete(null);
        Assert.assertFalse((String)"ValidateEdit should not be ok", (stat.getSeverity() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testValidateRemoteDelete() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        IFolder parent = root.getFolder("Folder1");
        IFile file = parent.getFile("File1");
        final ISemanticFolder sf = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
        final IStatus[] result = new IStatus[1];
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sfile = sf.addFile("File1", TestsContentProviderBase.this.options, monitor);
                result[0] = sfile.validateRemoteDelete((Object)monitor);
                sfile.remove(TestsContentProviderBase.this.options, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        IStatus stat = result[0];
        Assert.assertTrue((String)"ValidateRemoteDelete should be ok", (stat.getSeverity() == 0 ? 1 : 0) != 0);
        file = parent.getFile("File2");
        ISemanticFile sfile = (ISemanticFile)file.getAdapter(ISemanticFile.class);
        stat = sfile.validateRemoteDelete(null);
        Assert.assertFalse((String)"ValidateRemoteDelete should not be ok", (stat.getSeverity() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testValidateSave() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        IFolder parent = root.getFolder("Folder1");
        IFile file = parent.getFile("File1");
        final ISemanticFolder sf = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
        final IStatus[] result = new IStatus[1];
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sfile = sf.addFile("File1", TestsContentProviderBase.this.options, monitor);
                sfile.validateEdit(null);
                result[0] = sfile.validateSave();
                sfile.remove(TestsContentProviderBase.this.options, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        IStatus stat = result[0];
        Assert.assertTrue((String)"ValidateSave should be ok", (stat.getSeverity() == 0 ? 1 : 0) != 0);
        file = parent.getFile("File2");
        ISemanticFile sfile = (ISemanticFile)file.getAdapter(ISemanticFile.class);
        stat = sfile.validateSave();
        Assert.assertFalse((String)"ValidateSave should not be ok", (stat.getSeverity() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSemanticFileStoreToUri() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        IFolder parent = root.getFolder("Folder1");
        URI uri = EFS.getStore((URI)parent.getLocationURI()).toURI();
        Assert.assertEquals((String)"URIs should be equal", (Object)uri, (Object)parent.getLocationURI());
    }
}

