/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.e4photo;

import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.demo.e4photo.Exif;
import org.eclipse.e4.demo.e4photo.ExifTable;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class Location
implements EventHandler {
    private Browser browser;
    private Composite browserParent;
    private Exif exif;

    @Inject
    public Location(Composite parent, IEventBroker eventBroker) {
        parent.setLayout((Layout)new FillLayout());
        parent.setData("org.eclipse.e4.ui.css.id", (Object)"location");
        this.browserParent = parent;
        eventBroker.subscribe(ExifTable.EVENT_NAME, (EventHandler)this);
    }

    public void handleEvent(Event event) {
        Exif input = (Exif)event.getProperty("org.eclipse.e4.data");
        if (input == null || this.exif == input) {
            return;
        }
        this.exif = input;
        if (this.exif == null || this.exif.getGpsLatitude() == null) {
            if (this.browser != null) {
                this.browser.dispose();
                this.browser = null;
            }
        } else {
            if (this.browser == null) {
                this.browser = new Browser(this.browserParent, 0);
                this.browserParent.layout();
            }
            this.browser.setUrl("http://maps.google.com/maps?q=" + this.exif.getGpsLatitude() + "+" + this.exif.getGpsLongitude());
        }
    }
}

