/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.e4photo;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.annotations.PostConstruct;
import org.eclipse.e4.ui.model.application.MDirtyable;
import org.eclipse.e4.ui.model.application.MInput;
import org.eclipse.e4.ui.model.application.MUILabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class NoteEditor {
    @Inject
    private Composite parent;
    @Inject
    private MUILabel uiItem;
    private StyledText text;
    private final String inputURI;
    private final MDirtyable dirtyable;

    @Inject
    public NoteEditor(MInput input, MDirtyable dirtyable) {
        this.inputURI = input.getInputURI();
        this.dirtyable = dirtyable;
    }

    @PostConstruct
    void init() {
        this.parent.setLayout((Layout)new FillLayout());
        this.text = new StyledText(this.parent, 66);
        Path fullPath = new Path(this.inputURI);
        String shortName = fullPath.segment(fullPath.segmentCount() - 1);
        this.uiItem.setLabel("Notes - " + shortName);
        String noteText = this.readNote();
        if (noteText != null) {
            this.text.setText(noteText);
        }
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NoteEditor.this.dirtyable.setDirty(true);
            }
        });
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void doSave(@Optional IProgressMonitor monitor) {
        this.writeNote(this.text.getText());
        this.dirtyable.setDirty(false);
    }

    private String readNote() {
        FileReader reader;
        try {
            reader = new FileReader(this.inputURI);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            try {
                int charsRead;
                while ((charsRead = reader.read(buffer)) != -1) {
                    stringBuffer.append(buffer, 0, charsRead);
                }
            }
            catch (IOException e) {
                System.err.println("Unable to read file " + this.inputURI);
                e.printStackTrace();
                try {
                    reader.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return null;
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return stringBuffer.toString();
    }

    private boolean writeNote(String noteText) {
        try {
            File file = new File(this.inputURI);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter writer = new FileWriter(file);
            writer.write(noteText);
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Unable to write file " + this.inputURI);
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

