/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.e4photo;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.work.ISchedulingExecutor;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.NoGroupRenderer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class Thumbnails {
    private Gallery gallery;
    private GalleryItem group;
    private IContainer input;
    private volatile Runnable runnable;
    private final IStylingEngine stylingEngine;
    private IEclipseContext context;

    @Inject
    public Thumbnails(Composite parent, ISchedulingExecutor backgroundRunner, IStylingEngine stylingEngine) {
        this.stylingEngine = stylingEngine;
        parent.setLayout((Layout)new FillLayout());
        this.gallery = new Gallery(parent, 514);
        this.gallery.setData("org.eclipse.e4.ui.css.id", (Object)"thumbnails");
        this.gallery.setGroupRenderer((AbstractGalleryGroupRenderer)new NoGroupRenderer());
        DefaultGalleryItemRenderer ir = new DefaultGalleryItemRenderer();
        ir.setShowLabels(false);
        ir.setDropShadowsSize(0);
        ir.setShowRoundedSelectionCorners(false);
        this.gallery.setItemRenderer((AbstractGalleryItemRenderer)ir);
        this.group = new GalleryItem(this.gallery, 0);
        this.group.setExpanded(true);
        this.gallery.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object data = e.item.getData();
                Thumbnails.this.context.modify("selection", data);
            }
        });
    }

    private Point getBestSize(int originalX, int originalY, int maxX, int maxY) {
        double widthRatio = (double)originalX / (double)maxX;
        double heightRatio = (double)originalY / (double)maxY;
        double bestRatio = widthRatio > heightRatio ? widthRatio : heightRatio;
        int newWidth = (int)((double)originalX / bestRatio);
        int newHeight = (int)((double)originalY / bestRatio);
        return new Point(newWidth, newHeight);
    }

    @Inject
    @Optional
    public void setSelection(@Named(value="selection") IResource selection) {
        if (selection == null) {
            return;
        }
        IContainer newInput = selection instanceof IContainer ? (IContainer)selection : selection.getParent();
        if (newInput != this.input) {
            this.input = newInput;
            this.runnable = null;
            try {
                IContainer container = this.input;
                IResource[] members = container.members();
                this.gallery.removeAll();
                this.group = new GalleryItem(this.gallery, 0);
                this.group.setExpanded(true);
                final ArrayList<IResource> images = new ArrayList<IResource>();
                int i = 0;
                while (i < members.length) {
                    IResource resource = members[i];
                    if (resource.getType() == 1) {
                        images.add(resource);
                    }
                    ++i;
                }
                if (images.size() == 0) {
                    return;
                }
                final int[] counter = new int[1];
                this.runnable = new Runnable(){

                    public void run() {
                        if (Thumbnails.this.runnable != this) {
                            return;
                        }
                        int n = counter[0];
                        counter[0] = n + 1;
                        Thumbnails.this.addImage((IFile)images.get(n));
                        if (Thumbnails.this.gallery != null && !Thumbnails.this.gallery.isDisposed() && counter[0] < images.size()) {
                            Thumbnails.this.gallery.getDisplay().asyncExec((Runnable)this);
                        }
                    }
                };
                this.gallery.getDisplay().asyncExec(this.runnable);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void addImage(IFile file) {
        try {
            InputStream contents = file.getContents();
            try {
                try {
                    ImageData imageData = new ImageData(contents);
                    Point size = this.getBestSize(imageData.width, imageData.height, 100, 100);
                    ImageData scaled = imageData.scaledTo(size.x, size.y);
                    GalleryItem item = new GalleryItem(this.group, 0);
                    item.setText(file.getName());
                    Image image = new Image((Device)this.gallery.getDisplay(), scaled);
                    item.setImage(image);
                    item.setData((Object)file);
                    this.stylingEngine.setId((Object)item, null);
                    this.gallery.redraw();
                }
                catch (SWTException sWTException) {
                    try {
                        contents.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    contents.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    @Inject
    public void contextSet(IEclipseContext context) {
        this.context = context;
    }
}

