/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MPSCElement;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MPartSashContainer;
import org.eclipse.e4.ui.model.application.MPartStack;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.workbench.swt.internal.E4Application;
import org.eclipse.e4.workbench.modeling.EModelService;

public class EModelServiceInsertTest
extends TestCase {
    private IEclipseContext applicationContext;
    MApplication app = null;

    protected void setUp() throws Exception {
        this.applicationContext = E4Application.createDefaultContext();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.applicationContext instanceof IDisposable) {
            ((IDisposable)this.applicationContext).dispose();
        }
    }

    private MApplication createSimpleApplication() {
        MApplication app = MApplicationFactory.eINSTANCE.createApplication();
        app.setContext(this.applicationContext);
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        window.setId("main.Window");
        app.getChildren().add((Object)window);
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        stack.setId("theStack");
        window.getChildren().add((Object)stack);
        MPart part1 = MApplicationFactory.eINSTANCE.createPart();
        part1.setId("part1");
        stack.getChildren().add((Object)part1);
        MPart part2 = MApplicationFactory.eINSTANCE.createPart();
        part2.setId("part2");
        stack.getChildren().add((Object)part2);
        return app;
    }

    private MApplication createApplication() {
        MApplication app = MApplicationFactory.eINSTANCE.createApplication();
        app.setContext(this.applicationContext);
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        window.setId("main.Window");
        app.getChildren().add((Object)window);
        MPartSashContainer psc = MApplicationFactory.eINSTANCE.createPartSashContainer();
        psc.setHorizontal(true);
        psc.setId("topSash");
        window.getChildren().add((Object)psc);
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        stack.setId("theStack");
        psc.getChildren().add((Object)stack);
        MPart part1 = MApplicationFactory.eINSTANCE.createPart();
        part1.setId("part1");
        stack.getChildren().add((Object)part1);
        MPart part2 = MApplicationFactory.eINSTANCE.createPart();
        part2.setId("part2");
        stack.getChildren().add((Object)part2);
        return app;
    }

    private void testInsert(MApplication app, String relToId, int where, int ratio) {
        EModelService modelService = (EModelService)app.getContext().get(EModelService.class.getName());
        EModelServiceInsertTest.assertNotNull((Object)modelService);
        MUIElement relTo = modelService.find(relToId, (MUIElement)app);
        MPart newPart = MApplicationFactory.eINSTANCE.createPart();
        newPart.setId("newPart");
        modelService.insert((MPSCElement)newPart, (MPSCElement)relTo, where, ratio);
        MElementContainer newPartParent = newPart.getParent();
        EModelServiceInsertTest.assertTrue((String)"parent must be a sash", (boolean)(newPartParent instanceof MPartSashContainer));
        MPartSashContainer psc = (MPartSashContainer)newPartParent;
        boolean horizontal = where == 2 || where == 3;
        EModelServiceInsertTest.assertTrue((String)"invalid sash orientation", (psc.isHorizontal() == horizontal ? 1 : 0) != 0);
        if (where == 2 || where == 0) {
            EModelServiceInsertTest.assertTrue((String)"new part should be first", (psc.getChildren().indexOf((Object)newPart) == 0 ? 1 : 0) != 0);
            EModelServiceInsertTest.assertTrue((String)"old part should be second", (psc.getChildren().indexOf((Object)relTo) == 1 ? 1 : 0) != 0);
        } else {
            EModelServiceInsertTest.assertTrue((String)"old part should be first", (psc.getChildren().indexOf((Object)relTo) == 0 ? 1 : 0) != 0);
            EModelServiceInsertTest.assertTrue((String)"new part should be second", (psc.getChildren().indexOf((Object)newPart) == 1 ? 1 : 0) != 0);
        }
    }

    public void testSimpleInsertAbove() {
        MApplication application = this.createSimpleApplication();
        this.testInsert(application, "theStack", 0, 25);
    }

    public void testSimpleInsertBelow() {
        MApplication application = this.createSimpleApplication();
        this.testInsert(application, "theStack", 1, 25);
    }

    public void testSimpleInsertLeftOf() {
        MApplication application = this.createSimpleApplication();
        this.testInsert(application, "theStack", 2, 25);
    }

    public void testSimpleInsertRightOf() {
        MApplication application = this.createSimpleApplication();
        this.testInsert(application, "theStack", 3, 25);
    }

    public void testInsertAbove() {
        MApplication application = this.createApplication();
        this.testInsert(application, "theStack", 0, 35);
    }

    public void testInsertBelow() {
        MApplication application = this.createApplication();
        this.testInsert(application, "theStack", 1, 35);
    }

    public void testInsertLeftOf() {
        MApplication application = this.createApplication();
        this.testInsert(application, "theStack", 2, 35);
    }

    public void testInsertRightOf() {
        MApplication application = this.createApplication();
        this.testInsert(application, "theStack", 3, 35);
    }
}

