/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.Category;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MApplicationPackage;
import org.eclipse.e4.ui.model.application.MCommand;
import org.eclipse.e4.ui.model.application.MContext;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.tests.application.HeadlessApplicationElementTest;
import org.eclipse.e4.workbench.ui.IPresentationEngine;
import org.eclipse.e4.workbench.ui.internal.E4Workbench;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HeadlessApplicationTest
extends HeadlessApplicationElementTest {
    protected MApplication application;
    protected IPresentationEngine renderer;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.application = (MApplication)this.applicationElement;
        for (MWindow wbw : this.application.getChildren()) {
            this.createGUI((MUIElement)wbw);
        }
        if (this.needsActiveChildEventHandling()) {
            this.addActiveChildEventHandling();
        }
    }

    @Override
    protected void tearDown() throws Exception {
        for (MWindow window : this.application.getChildren()) {
            this.renderer.removeGui((MUIElement)window);
        }
        super.tearDown();
    }

    protected boolean needsActiveChildEventHandling() {
        return true;
    }

    private void addActiveChildEventHandling() {
    }

    public void testGet_ActiveContexts() throws Exception {
        IEclipseContext context = this.application.getContext();
        HeadlessApplicationTest.assertNotNull((Object)context.get("activeContexts"));
    }

    public void testGet_Selection() throws Exception {
        IEclipseContext context = this.application.getContext();
        HeadlessApplicationTest.assertNull((Object)context.get("selection"));
    }

    public void testGet_ActiveChild() throws Exception {
        IEclipseContext context = this.application.getContext();
        HeadlessApplicationTest.assertNull((Object)context.get("activeChildContext"));
    }

    public void testGet_ActivePart() throws Exception {
        IEclipseContext context = this.application.getContext();
        HeadlessApplicationTest.assertNull((Object)context.get("e4ActivePart"));
    }

    public void testGet_Input() throws Exception {
        IEclipseContext context = this.application.getContext();
        HeadlessApplicationTest.assertNull((Object)context.get("input"));
    }

    public void testGet_PersistedState() throws Exception {
        IEclipseContext context = this.application.getContext();
        HeadlessApplicationTest.assertNull((Object)context.get("persistedState"));
    }

    public void testGet_ActivePartId() throws Exception {
        IEclipseContext context = this.application.getContext();
        HeadlessApplicationTest.assertNull((Object)context.get("activePartId"));
    }

    public void test_SwitchActivePartsInContext() throws Exception {
        IEclipseContext context = this.application.getContext();
        MPart[] parts = this.getTwoParts();
        context.set("e4ActivePart", (Object)parts[0]);
        HeadlessApplicationTest.assertEquals((Object)parts[0].getId(), (Object)context.get("activePartId"));
        HeadlessApplicationTest.assertNull((Object)this.osgiContext.get("e4ActivePart"));
        HeadlessApplicationTest.assertNull((Object)this.osgiContext.get("activePartId"));
        context.set("e4ActivePart", (Object)parts[1]);
        HeadlessApplicationTest.assertEquals((Object)parts[1].getId(), (Object)context.get("activePartId"));
        HeadlessApplicationTest.assertNull((Object)this.osgiContext.get("e4ActivePart"));
        HeadlessApplicationTest.assertNull((Object)this.osgiContext.get("activePartId"));
    }

    private void test_GetContext(MContext context) {
        HeadlessApplicationTest.assertNotNull((Object)context.getContext());
    }

    public void testGetFirstPart_GetContext() {
        this.getFirstPart().getParent().setSelectedElement((MUIElement)this.getFirstPart());
        this.test_GetContext((MContext)this.getFirstPart());
    }

    public void testGetSecondPart_GetContext() {
        this.getSecondPart().getParent().setSelectedElement((MUIElement)this.getSecondPart());
        this.test_GetContext((MContext)this.getSecondPart());
    }

    private void testModify(MContext mcontext) {
        Set<String> variables = HeadlessApplicationTest.getVariables(mcontext, new HashSet<String>());
        IEclipseContext context = mcontext.getContext();
        for (String variable : variables) {
            Object newValue = new Object();
            context.modify(variable, newValue);
            HeadlessApplicationTest.assertEquals((Object)newValue, (Object)context.get(variable));
        }
    }

    public void testModify() {
        this.testGetFirstPart_GetContext();
        this.testModify((MContext)this.getFirstPart());
    }

    public void testModify2() {
        this.testGetSecondPart_GetContext();
        this.testModify((MContext)this.getSecondPart());
    }

    private static Set<String> getVariables(MContext context, Set<String> variables) {
        variables.addAll((Collection<String>)context.getVariables());
        if (context instanceof MUIElement) {
            MElementContainer parent = ((MUIElement)context).getParent();
            while (parent != null) {
                if (parent instanceof MContext) {
                    HeadlessApplicationTest.getVariables((MContext)parent, variables);
                }
                parent = parent.getParent();
            }
        }
        return variables;
    }

    protected MPart[] getTwoParts() {
        MPart firstPart = this.getFirstPart();
        HeadlessApplicationTest.assertNotNull((Object)firstPart);
        MPart secondPart = this.getSecondPart();
        HeadlessApplicationTest.assertNotNull((Object)secondPart);
        HeadlessApplicationTest.assertFalse((boolean)firstPart.equals(secondPart));
        return new MPart[]{firstPart, secondPart};
    }

    protected abstract MPart getFirstPart();

    protected abstract MPart getSecondPart();

    protected void createGUI(MUIElement uiRoot) {
        this.renderer.createGui(uiRoot);
    }

    @Override
    protected MApplicationElement createApplicationElement(IEclipseContext appContext) throws Exception {
        return this.createApplication(appContext, this.getURI());
    }

    protected abstract String getURI();

    protected IPresentationEngine createPresentationEngine(String renderingEngineURI) throws Exception {
        IContributionFactory contributionFactory = (IContributionFactory)this.applicationContext.get(IContributionFactory.class.getName());
        Object newEngine = contributionFactory.create(renderingEngineURI, this.applicationContext);
        return (IPresentationEngine)newEngine;
    }

    private MApplication createApplication(IEclipseContext appContext, String appURI) throws Exception {
        URI initialWorkbenchDefinitionInstance = URI.createPlatformPluginURI((String)appURI, (boolean)true);
        ResourceSetImpl set = new ResourceSetImpl();
        set.getPackageRegistry().put((Object)"http://MApplicationPackage/", (Object)MApplicationPackage.eINSTANCE);
        Resource resource = set.getResource(initialWorkbenchDefinitionInstance, true);
        MApplication application = (MApplication)resource.getContents().get(0);
        application.setContext(appContext);
        appContext.set(MApplication.class.getName(), (Object)application);
        ECommandService cs = (ECommandService)appContext.get(ECommandService.class.getName());
        Category cat = cs.defineCategory(MApplication.class.getName(), "Application Category", null);
        EList commands = application.getCommands();
        for (MCommand cmd : commands) {
            String id = cmd.getId();
            String name = cmd.getCommandName();
            cs.defineCommand(id, name, null, cat, null);
        }
        EList windows = application.getChildren();
        for (MWindow window : windows) {
            E4Workbench.initializeContext((IEclipseContext)appContext, (MContext)window);
        }
        E4Workbench.processHierarchy((Object)application);
        this.processPartContributions(application.getContext(), resource);
        this.renderer = this.createPresentationEngine(this.getEngineURI());
        return application;
    }

    protected String getEngineURI() {
        return "platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.HeadlessContextPresentationEngine";
    }

    private void processPartContributions(IEclipseContext context, Resource resource) {
        IExtensionRegistry registry = (IExtensionRegistry)context.get(IExtensionRegistry.class.getName());
        String extId = "org.eclipse.e4.workbench.parts";
        IConfigurationElement[] parts = registry.getConfigurationElementsFor(extId);
        int i = 0;
        while (i < parts.length) {
            MPart part = MApplicationFactory.eINSTANCE.createPart();
            part.setLabel(parts[i].getAttribute("label"));
            part.setIconURI("platform:/plugin/" + parts[i].getContributor().getName() + "/" + parts[i].getAttribute("icon"));
            part.setURI("platform:/plugin/" + parts[i].getContributor().getName() + "/" + parts[i].getAttribute("class"));
            String parentId = parts[i].getAttribute("parentId");
            EObject parent = this.findObject((TreeIterator<EObject>)resource.getAllContents(), parentId);
            if (parent instanceof MElementContainer) {
                ((MElementContainer)parent).getChildren().add((Object)part);
            }
            ++i;
        }
    }

    private EObject findObject(TreeIterator<EObject> it, String id) {
        while (it.hasNext()) {
            EObject el = (EObject)it.next();
            if (!(el instanceof MApplicationElement) || !el.eResource().getURIFragment(el).equals(id)) continue;
            return el;
        }
        return null;
    }

    protected MApplicationElement findElement(String id) {
        return this.findElement((MElementContainer<?>)this.application, id);
    }

    private MApplicationElement findElement(MElementContainer<?> container, String id) {
        if (id.equals(container.getId())) {
            return container;
        }
        EList children = container.getChildren();
        for (Object child : children) {
            MApplicationElement element = (MApplicationElement)child;
            if (element instanceof MElementContainer) {
                MApplicationElement found = this.findElement((MElementContainer)element, id);
                if (found == null) continue;
                return found;
            }
            if (!id.equals(element.getId())) continue;
            return element;
        }
        return null;
    }
}

