/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.ArrayList;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MMenu;
import org.eclipse.e4.ui.model.application.MTestHarness;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.tests.application.HeadlessApplicationElementTest;
import org.eclipse.e4.workbench.ui.UIEvents;
import org.eclipse.e4.workbench.ui.internal.UIEventPublisher;
import org.eclipse.emf.common.notify.Notifier;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class UIEventsTest
extends HeadlessApplicationElementTest {
    protected MApplicationElement createApplicationElement(IEclipseContext appContext) throws Exception {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.getChildren().add((Object)MApplicationFactory.eINSTANCE.createWindow());
        return application;
    }

    public void testAllTopics() {
        IEventBroker eventBroker = (IEventBroker)this.applicationContext.get(IEventBroker.class.getName());
        AppElementTester appTester = new AppElementTester(eventBroker);
        CommandTester commandTester = new CommandTester(eventBroker);
        ContextTester contextTester = new ContextTester(eventBroker);
        ContributionTester contributionTester = new ContributionTester(eventBroker);
        ElementContainerTester elementContainerTester = new ElementContainerTester(eventBroker);
        DirtyableTester dirtyableTester = new DirtyableTester(eventBroker);
        InputTester inputTester = new InputTester(eventBroker);
        ParameterTester parameterTester = new ParameterTester(eventBroker);
        UIElementTester uiElementTester = new UIElementTester(eventBroker);
        UIItemTester uiItemTester = new UIItemTester(eventBroker);
        WindowTester windowTester = new WindowTester(eventBroker);
        EventTester[] allTesters = new EventTester[]{appTester, commandTester, contextTester, contributionTester, elementContainerTester, inputTester, parameterTester, uiElementTester, uiItemTester, windowTester};
        MTestHarness allData = MApplicationFactory.eINSTANCE.createTestHarness();
        ((Notifier)allData).eAdapters().add((Object)new UIEventPublisher(this.applicationContext));
        this.reset(allTesters);
        String newId = "Some New Id";
        allData.setId(newId);
        allData.getTags().add((Object)"Testing");
        this.checkForFailures(allTesters, appTester);
        appTester.reset();
        allData.setId(newId);
        UIEventsTest.assertTrue((String)"event thrown on No-Op", (appTester.getAttIds(true).length == 0 ? 1 : 0) != 0);
        this.reset(allTesters);
        IEclipseContext newContext = EclipseContextFactory.create();
        allData.setContext(newContext);
        allData.getVariables().add((Object)"foo");
        this.checkForFailures(allTesters, contextTester);
        this.reset(allTesters);
        allData.setContext(EclipseContextFactory.create());
        allData.getVariables().add((Object)"A var");
        this.checkForFailures(allTesters, contextTester);
        this.reset(allTesters);
        allData.setURI("Some URI");
        allData.setObject((Object)"Some onbject");
        allData.getPersistedState().put((Object)"testing", (Object)"Some state");
        this.checkForFailures(allTesters, contributionTester);
        this.reset(allTesters);
        MMenu menu = MApplicationFactory.eINSTANCE.createMenu();
        allData.getChildren().add((Object)menu);
        allData.setSelectedElement((MUIElement)menu);
        this.checkForFailures(allTesters, elementContainerTester);
        this.reset(allTesters);
        allData.setInputURI("New Input Uri");
        this.checkForFailures(allTesters, inputTester);
        this.reset(allTesters);
        allData.setDirty(!allData.isDirty());
        this.checkForFailures(allTesters, dirtyableTester);
        this.reset(allTesters);
        allData.setTag("New Tag");
        allData.setValue("New Value");
        this.checkForFailures(allTesters, parameterTester);
        this.reset(allTesters);
        MTestHarness newParent = MApplicationFactory.eINSTANCE.createTestHarness();
        allData.setRenderer((Object)"New Renderer");
        allData.setParent((MElementContainer)newParent);
        allData.setToBeRendered(!allData.isToBeRendered());
        allData.setVisible(!allData.isVisible());
        allData.setOnTop(!allData.isOnTop());
        allData.setWidget((Object)"New Widget");
        allData.setContainerData("new Data");
        this.checkForFailures(allTesters, uiElementTester);
        this.reset(allTesters);
        allData.setLabel("New Name");
        allData.setIconURI("New Icon URI");
        allData.setTooltip("New Tooltip");
        this.checkForFailures(allTesters, uiItemTester);
        this.reset(allTesters);
        MWindow window = (MWindow)((MApplication)this.applicationElement).getChildren().get(0);
        window.setX(1234);
        window.setY(1234);
        window.setWidth(1234);
        window.setHeight(1234);
        MMenu newMainMenu = MApplicationFactory.eINSTANCE.createMenu();
        window.setMainMenu(newMainMenu);
        this.checkForFailures(allTesters, windowTester);
    }

    private void checkForFailures(EventTester[] allTesters, EventTester tester) {
        this.ensureAllSet(tester);
        this.ensureNoCrossTalk(allTesters, tester);
    }

    private void ensureNoCrossTalk(EventTester[] allTesters, EventTester skipMe) {
        ArrayList<EventTester> badTesters = new ArrayList<EventTester>();
        EventTester[] eventTesterArray = allTesters;
        int n = allTesters.length;
        int n2 = 0;
        while (n2 < n) {
            EventTester t = eventTesterArray[n2];
            if (!t.equals(skipMe) && t.getAttIds(true).length > 0) {
                badTesters.add(t);
            }
            ++n2;
        }
        if (badTesters.size() > 0) {
            String msg = "Events were fired in the wrong topic(s): " + badTesters;
            UIEventsTest.fail((String)msg);
        }
    }

    private void ensureAllSet(EventTester tester) {
        String[] unfiredIds = tester.getAttIds(false);
        if (unfiredIds.length > 0) {
            String msg = "No event fired:" + unfiredIds;
            int i = 0;
            while (i < unfiredIds.length) {
                msg = String.valueOf(msg) + ' ' + unfiredIds[i];
                ++i;
            }
            UIEventsTest.fail((String)msg);
        }
    }

    private void reset(EventTester[] allTesters) {
        EventTester[] eventTesterArray = allTesters;
        int n = allTesters.length;
        int n2 = 0;
        while (n2 < n) {
            EventTester t = eventTesterArray[n2];
            t.reset();
            ++n2;
        }
    }

    public class AppElementTester
    extends EventTester {
        AppElementTester(IEventBroker eventBroker) {
            super("AppElement", "org/eclipse/e4/ui/model/application/ApplicationElement", new String[]{"id", "tags"}, eventBroker);
        }
    }

    public class CommandTester
    extends EventTester {
        CommandTester(IEventBroker eventBroker) {
            super("Command", "org/eclipse/e4/ui/model/application/Command", new String[]{"commandName"}, eventBroker);
        }
    }

    public class ContextTester
    extends EventTester {
        ContextTester(IEventBroker eventBroker) {
            super("Context", "org/eclipse/e4/ui/model/application/Context", new String[]{"context", "variables"}, eventBroker);
        }
    }

    public class ContributionTester
    extends EventTester {
        ContributionTester(IEventBroker eventBroker) {
            super("Contribution", "org/eclipse/e4/ui/model/application/Contribution", new String[]{"URI", "persistedState", "object"}, eventBroker);
        }
    }

    public class DirtyableTester
    extends EventTester {
        DirtyableTester(IEventBroker eventBroker) {
            super("Dirtyable", "org/eclipse/e4/ui/model/application/Dirtyable", new String[]{"dirty"}, eventBroker);
        }
    }

    public class ElementContainerTester
    extends EventTester {
        ElementContainerTester(IEventBroker eventBroker) {
            super("ElementContainer", "org/eclipse/e4/ui/model/application/ElementContainer", new String[]{"children", "selectedElement"}, eventBroker);
        }
    }

    class EventTester {
        String testerName;
        IEventBroker eventBroker;
        String topic;
        String[] attIds;
        boolean[] hasFired;
        EventHandler attListener = new EventHandler(){

            public void handleEvent(Event event) {
                EventTester.this.assertTrue(event.getTopic().equals(EventTester.this.topic), "Incorrect Topic: " + event.getTopic());
                String attId = (String)event.getProperty("AttName");
                int attIndex = EventTester.this.getAttIndex(attId);
                EventTester.this.assertTrue(attIndex >= 0, "Unknown Attribite: " + attId);
                EventTester.this.hasFired[attIndex] = true;
            }
        };

        public EventTester(String name, String topic, String[] attIds, IEventBroker eventBroker) {
            this.testerName = name;
            this.topic = UIEvents.buildTopic((String)topic);
            this.attIds = attIds;
            this.eventBroker = eventBroker;
            this.hasFired = new boolean[attIds.length];
            this.reset();
            eventBroker.subscribe(this.topic, this.attListener);
        }

        protected void assertTrue(boolean b, String string) {
        }

        protected int getAttIndex(String attId) {
            int i = 0;
            while (i < this.attIds.length) {
                if (this.attIds[i].equals(attId)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void dispose() {
            this.eventBroker.unsubscribe(this.attListener);
        }

        public void reset() {
            int i = 0;
            while (i < this.hasFired.length) {
                this.hasFired[i] = false;
                ++i;
            }
        }

        public String[] getAttIds(boolean fired) {
            ArrayList<String> atts = new ArrayList<String>();
            int i = 0;
            while (i < this.hasFired.length) {
                if (this.hasFired[i] == fired) {
                    atts.add(this.attIds[i]);
                }
                ++i;
            }
            return atts.toArray(new String[atts.size()]);
        }
    }

    public class InputTester
    extends EventTester {
        InputTester(IEventBroker eventBroker) {
            super("Input", "org/eclipse/e4/ui/model/application/Input", new String[]{"inputURI"}, eventBroker);
        }
    }

    public class ParameterTester
    extends EventTester {
        ParameterTester(IEventBroker eventBroker) {
            super("Parameter", "org/eclipse/e4/ui/model/application/Parameter", new String[]{"tag", "value"}, eventBroker);
        }
    }

    public class UIElementTester
    extends EventTester {
        UIElementTester(IEventBroker eventBroker) {
            super("UIElement", "org/eclipse/e4/ui/model/application/UIElement", new String[]{"renderer", "toBeRendered", "parent", "onTop", "visible", "containerData", "widget"}, eventBroker);
        }
    }

    public class UIItemTester
    extends EventTester {
        UIItemTester(IEventBroker eventBroker) {
            super("UIItem", "org/eclipse/e4/ui/model/application/UILabel", new String[]{"label", "iconURI", "tooltip"}, eventBroker);
        }
    }

    public class WindowTester
    extends EventTester {
        WindowTester(IEventBroker eventBroker) {
            super("Window", "org/eclipse/e4/ui/model/application/Window", new String[]{"mainMenu", "x", "y", "width", "height"}, eventBroker);
        }
    }
}

