/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MContext;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MPSCElement;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.tests.Activator;
import org.eclipse.e4.ui.tests.application.HeadlessApplicationTest;
import org.eclipse.e4.ui.workbench.swt.internal.ResourceUtility;
import org.eclipse.e4.workbench.modeling.EPartService;
import org.eclipse.e4.workbench.ui.IResourceUtiltities;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public abstract class UIStartupTest
extends HeadlessApplicationTest {
    private BundleContext bundleContext;
    private ServiceTracker bundleTracker;
    protected Display display;

    protected void setUp() throws Exception {
        this.bundleContext = Activator.getDefault().getBundle().getBundleContext();
        this.display = Display.getDefault();
        super.setUp();
        while (this.display.readAndDispatch()) {
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
    }

    protected PackageAdmin getBundleAdmin() {
        if (this.bundleTracker == null) {
            if (this.bundleContext == null) {
                return null;
            }
            this.bundleTracker = new ServiceTracker(this.bundleContext, PackageAdmin.class.getName(), null);
            this.bundleTracker.open();
        }
        return (PackageAdmin)this.bundleTracker.getService();
    }

    protected boolean needsActiveChildEventHandling() {
        return false;
    }

    protected String getEngineURI() {
        return "platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.workbench.swt.internal.PartRenderingEngine";
    }

    public void testGet_ActiveChild() throws Exception {
        IEclipseContext context = this.application.getContext();
        UIStartupTest.assertNotNull((Object)context.get("activeChildContext"));
    }

    public void testGet_ActiveShell() throws Exception {
        IEclipseContext context = this.application.getContext();
        UIStartupTest.assertNull((Object)context.get("activeShell"));
    }

    public void testGet_ActivePart() throws Exception {
        IEclipseContext context = this.application.getContext();
        UIStartupTest.assertNotNull((Object)context.get("e4ActivePart"));
    }

    public void testGet_ActivePartId() throws Exception {
        IEclipseContext context = this.application.getContext();
        UIStartupTest.assertNotNull((Object)context.get("activePartId"));
    }

    public void testGet_ActiveContexts2() throws Exception {
        IEclipseContext context = UIStartupTest.getActiveChildContext(this.application);
        UIStartupTest.assertNotNull((Object)context.get("activeContexts"));
    }

    public void testGet_Selection2() throws Exception {
        IEclipseContext context = UIStartupTest.getActiveChildContext(this.application);
        UIStartupTest.assertNull((Object)context.get("selection"));
    }

    public void testGet_ActiveChild2() throws Exception {
        IEclipseContext context = UIStartupTest.getActiveChildContext(this.application);
        UIStartupTest.assertNotNull((Object)context.get("activeChildContext"));
    }

    public void testGet_ActivePart2() throws Exception {
        IEclipseContext context = UIStartupTest.getActiveChildContext(this.application);
        UIStartupTest.assertNotNull((Object)context.get("e4ActivePart"));
    }

    public void testGet_Input2() throws Exception {
        IEclipseContext context = UIStartupTest.getActiveChildContext(this.application);
        UIStartupTest.assertNull((Object)context.get("input"));
    }

    public void testGet_ActiveShell2() throws Exception {
        IEclipseContext context = UIStartupTest.getActiveChildContext(this.application);
        UIStartupTest.assertNull((Object)context.get("activeShell"));
    }

    public void testGet_PersistedState2() throws Exception {
        IEclipseContext context = UIStartupTest.getActiveChildContext(this.application);
        UIStartupTest.assertNull((Object)context.get("persistedState"));
    }

    public void testGetFirstPart_GetContext() {
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)this.display), (Runnable)new Runnable(){

            public void run() {
                UIStartupTest.super.testGetFirstPart_GetContext();
            }
        });
    }

    public void testGetSecondPart_GetContext() {
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)this.display), (Runnable)new Runnable(){

            public void run() {
                UIStartupTest.super.testGetSecondPart_GetContext();
            }
        });
    }

    public void test_SwitchActivePartsInContext() throws Exception {
        final IEclipseContext context = this.application.getContext();
        final MPart[] parts = this.getTwoParts();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)this.display), (Runnable)new Runnable(){

            public void run() {
                context.set("e4ActivePart", (Object)parts[0]);
                while (UIStartupTest.this.display.readAndDispatch()) {
                }
                UIStartupTest.assertEquals((Object)parts[0].getId(), (Object)context.get("activePartId"));
                context.set("e4ActivePart", (Object)parts[1]);
                while (UIStartupTest.this.display.readAndDispatch()) {
                }
                UIStartupTest.assertEquals((Object)parts[1].getId(), (Object)context.get("activePartId"));
            }
        });
    }

    public void test_SwitchActivePartsInContext2() throws Exception {
        final IEclipseContext context = UIStartupTest.getActiveChildContext(this.application);
        final MPart[] parts = this.getTwoParts();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)this.display), (Runnable)new Runnable(){

            public void run() {
                EPartService service = (EPartService)context.get(EPartService.class.getName());
                service.activate(parts[0]);
                while (UIStartupTest.this.display.readAndDispatch()) {
                }
                UIStartupTest.assertEquals((Object)parts[0].getId(), (Object)context.get("activePartId"));
                service.activate(parts[1]);
                while (UIStartupTest.this.display.readAndDispatch()) {
                }
                UIStartupTest.assertEquals((Object)parts[1].getId(), (Object)context.get("activePartId"));
            }
        });
    }

    private static MPSCElement getNonContainer(MPSCElement activeChild) {
        if (activeChild instanceof MElementContainer) {
            activeChild = (MPSCElement)((MElementContainer)activeChild).getSelectedElement();
            UIStartupTest.assertNotNull((Object)activeChild);
            activeChild = UIStartupTest.getNonContainer(activeChild);
        }
        return activeChild;
    }

    private static IEclipseContext getActiveChildContext(MApplication application) {
        MPSCElement nonContainer = UIStartupTest.getNonContainer((MPSCElement)((MWindow)application.getSelectedElement()).getSelectedElement());
        return ((MContext)nonContainer).getContext();
    }

    protected IEclipseContext createApplicationContext(final IEclipseContext osgiContext) {
        final IEclipseContext[] contexts = new IEclipseContext[1];
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)this.display), (Runnable)new Runnable(){

            public void run() {
                contexts[0] = UIStartupTest.super.createApplicationContext(osgiContext);
                contexts[0].set(IResourceUtiltities.class.getName(), (Object)new ResourceUtility(UIStartupTest.this.getBundleAdmin()));
                contexts[0].set(IStylingEngine.class.getName(), (Object)new IStylingEngine(){

                    public void style(Object widget) {
                    }

                    public void setId(Object widget, String id) {
                    }

                    public void setClassname(Object widget, String classname) {
                    }
                });
            }
        });
        return contexts[0];
    }

    protected void createGUI(final MUIElement uiRoot) {
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)this.display), (Runnable)new Runnable(){

            public void run() {
                UIStartupTest.super.createGUI(uiRoot);
            }
        });
    }
}

