/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.workbench.modeling.ModelDelta;
import org.eclipse.e4.workbench.modeling.ModelReconciler;

public abstract class IModelReconcilingServiceTest
extends ModelReconcilerTest {
    public void testCreateModelReconciler() {
        IModelReconcilingServiceTest.assertNotNull((Object)this.service.createModelReconciler());
    }

    public void testApplyDeltasUnfiltered() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setLabel("windowName");
        this.saveModel();
        ModelReconciler reconciler = this.service.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setLabel("newName");
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        IModelReconcilingServiceTest.assertEquals((String)"windowName", (String)window.getLabel());
        this.service.applyDeltas(deltas);
        IModelReconcilingServiceTest.assertEquals((String)"newName", (String)window.getLabel());
    }

    public void testApplyDeltasUnfiltered2() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setLabel("windowName");
        this.saveModel();
        ModelReconciler reconciler = this.service.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setLabel("newName");
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        IModelReconcilingServiceTest.assertEquals((String)"windowName", (String)window.getLabel());
        this.service.applyDeltas(deltas, null);
        IModelReconcilingServiceTest.assertEquals((String)"newName", (String)window.getLabel());
    }

    public void testApplyDeltasUnfiltered3() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setLabel("windowName");
        this.saveModel();
        ModelReconciler reconciler = this.service.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setLabel("newName");
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        IModelReconcilingServiceTest.assertEquals((String)"windowName", (String)window.getLabel());
        this.service.applyDeltas(deltas, new String[0]);
        IModelReconcilingServiceTest.assertEquals((String)"newName", (String)window.getLabel());
    }

    public void testApplyDeltasFiltered() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setLabel("windowName");
        this.saveModel();
        ModelReconciler reconciler = this.service.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setLabel("newName");
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        IModelReconcilingServiceTest.assertEquals((String)"windowName", (String)window.getLabel());
        this.service.applyDeltas(deltas, new String[]{ModelReconciler.UILABEL_LABEL_ATTNAME});
        IModelReconcilingServiceTest.assertEquals((String)"windowName", (String)window.getLabel());
    }
}

