/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MCommand;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.workbench.modeling.ModelDelta;
import org.eclipse.e4.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerApplicationElementTest
extends ModelReconcilerTest {
    private void testApplicationElement_Style(String[] originalTags, String[] userTags, String[] newTags, String[] mergedTags) {
        MApplication application = this.createApplication();
        application.getTags().addAll(Arrays.asList(originalTags));
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        application.getTags().clear();
        application.getTags().addAll(Arrays.asList(userTags));
        Object state = reconciler.serialize();
        application = this.createApplication();
        application.getTags().clear();
        List<String> newTagsList = Arrays.asList(newTags);
        application.getTags().addAll(newTagsList);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerApplicationElementTest.assertEquals(newTagsList, (Object)application.getTags());
        this.applyAll(deltas);
        List<String> mergedTagsList = Arrays.asList(mergedTags);
        ModelReconcilerApplicationElementTest.assertEquals((int)mergedTagsList.size(), (int)application.getTags().size());
        ModelReconcilerApplicationElementTest.assertTrue((boolean)mergedTagsList.containsAll((Collection<?>)application.getTags()));
        ModelReconcilerApplicationElementTest.assertTrue((boolean)application.getTags().containsAll(mergedTagsList));
    }

    public void testApplicationElement_Style() {
        this.testApplicationElement_Style(new String[0], new String[0], new String[0], new String[0]);
    }

    public void testApplicationElement_Style2() {
        this.testApplicationElement_Style(new String[]{"cvs"}, new String[0], new String[]{"cvs"}, new String[0]);
    }

    public void testApplicationElement_Style3() {
        this.testApplicationElement_Style(new String[]{"cvs"}, new String[]{"cvs"}, new String[]{"cvs"}, new String[]{"cvs"});
    }

    public void testApplicationElement_Style4() {
        this.testApplicationElement_Style(new String[]{"cvs"}, new String[]{"cvs", "scm"}, new String[]{"cvs"}, new String[]{"cvs", "scm"});
    }

    public void testApplicationElement_Style5() {
        this.testApplicationElement_Style(new String[0], new String[]{"cvs"}, new String[]{"scm"}, new String[]{"scm", "cvs"});
    }

    public void testApplicationElement_Tags_New() {
        MApplication application = this.createApplication();
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MCommand command = MApplicationFactory.eINSTANCE.createCommand();
        command.getTags().add((Object)"tag");
        application.getCommands().add((Object)command);
        Object state = reconciler.serialize();
        application = this.createApplication();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerApplicationElementTest.assertEquals((int)0, (int)application.getCommands().size());
        this.applyAll(deltas);
        ModelReconcilerApplicationElementTest.assertEquals((int)1, (int)application.getCommands().size());
        command = (MCommand)application.getCommands().get(0);
        ModelReconcilerApplicationElementTest.assertEquals((int)1, (int)command.getTags().size());
        ModelReconcilerApplicationElementTest.assertEquals((String)"tag", (String)((String)command.getTags().get(0)));
    }

    private void testApplicationElement_Id_New(boolean createIdFirst) {
        MApplication application = this.createApplication();
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MCommand command = MApplicationFactory.eINSTANCE.createCommand();
        if (createIdFirst) {
            command.setId("commandId");
            application.getCommands().add((Object)command);
        } else {
            application.getCommands().add((Object)command);
            command.setId("commandId");
        }
        Object state = reconciler.serialize();
        application = this.createApplication();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerApplicationElementTest.assertEquals((int)0, (int)application.getCommands().size());
        this.applyAll(deltas);
        ModelReconcilerApplicationElementTest.assertEquals((int)1, (int)application.getCommands().size());
        command = (MCommand)application.getCommands().get(0);
        ModelReconcilerApplicationElementTest.assertEquals((String)"commandId", (String)command.getId());
    }

    public void testApplicationElement_Id_New_True() {
        this.testApplicationElement_Id_New(true);
    }

    public void testApplicationElement_Id_New_False() {
        this.testApplicationElement_Id_New(false);
    }

    private void testApplicationElement_Id(String before, String after) {
        MApplication application = this.createApplication();
        application.setId(before);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        application.setId(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerApplicationElementTest.assertEquals((String)before, (String)application.getId());
        this.applyAll(deltas);
        ModelReconcilerApplicationElementTest.assertEquals((String)after, (String)application.getId());
    }

    public void testApplicationElement_Id_NullNull() {
        this.testApplicationElement_Id(null, null);
    }

    public void testApplicationElement_Id_NullEmpty() {
        this.testApplicationElement_Id(null, "");
    }

    public void testApplicationElement_Id_NullString() {
        this.testApplicationElement_Id(null, "id");
    }

    public void testApplicationElement_Id_EmptyNull() {
        this.testApplicationElement_Id("", null);
    }

    public void testApplicationElement_Id_EmptyEmpty() {
        this.testApplicationElement_Id("", "");
    }

    public void testApplicationElement_Id_EmptyString() {
        this.testApplicationElement_Id("", "id");
    }

    public void testApplicationElement_Id_StringNull() {
        this.testApplicationElement_Id("id", null);
    }

    public void testApplicationElement_Id_StringEmpty() {
        this.testApplicationElement_Id("id", "");
    }

    public void testApplicationElement_Id_StringStringUnchanged() {
        this.testApplicationElement_Id("id", "id");
    }

    public void testApplicationElement_Id_StringStringChanged() {
        this.testApplicationElement_Id("id", "id3");
    }
}

