/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MCommand;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.workbench.modeling.ModelDelta;
import org.eclipse.e4.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerApplicationTest
extends ModelReconcilerTest {
    public void testApplication_Commands_Add() {
        MApplication application = this.createApplication();
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MCommand command = MApplicationFactory.eINSTANCE.createCommand();
        command.setCommandName("newCommand");
        application.getCommands().add((Object)command);
        Object state = reconciler.serialize();
        application = this.createApplication();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerApplicationTest.assertEquals((int)0, (int)application.getCommands().size());
        this.applyAll(deltas);
        ModelReconcilerApplicationTest.assertEquals((int)1, (int)application.getCommands().size());
        command = (MCommand)application.getCommands().get(0);
        ModelReconcilerApplicationTest.assertEquals((String)"newCommand", (String)command.getCommandName());
    }

    public void testApplication_Commands_Remove() {
        MApplication application = this.createApplication();
        MCommand command = MApplicationFactory.eINSTANCE.createCommand();
        application.getCommands().add((Object)command);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        application.getCommands().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerApplicationTest.assertEquals((int)1, (int)application.getCommands().size());
        command = (MCommand)application.getCommands().get(0);
        this.applyAll(deltas);
        ModelReconcilerApplicationTest.assertEquals((int)0, (int)application.getCommands().size());
    }
}

