/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MCommand;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.workbench.modeling.ModelDelta;
import org.eclipse.e4.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerCommandTest
extends ModelReconcilerTest {
    private void testCommand_CommandName(String before, String after) {
        MApplication application = this.createApplication();
        MCommand command = MApplicationFactory.eINSTANCE.createCommand();
        command.setCommandName(before);
        application.getCommands().add((Object)command);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        command.setCommandName(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        command = (MCommand)application.getCommands().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerCommandTest.assertEquals((String)before, (String)command.getCommandName());
        this.applyAll(deltas);
        ModelReconcilerCommandTest.assertEquals((String)after, (String)command.getCommandName());
    }

    public void testCommand_CommandName_NullNull() {
        this.testCommand_CommandName(null, null);
    }

    public void testCommand_CommandName_NullEmpty() {
        this.testCommand_CommandName(null, "");
    }

    public void testCommand_CommandName_NullString() {
        this.testCommand_CommandName(null, "name");
    }

    public void testCommand_CommandName_EmptyNull() {
        this.testCommand_CommandName("", null);
    }

    public void testCommand_CommandName_EmptyEmpty() {
        this.testCommand_CommandName("", "");
    }

    public void testCommand_CommandName_EmptyString() {
        this.testCommand_CommandName("", "name");
    }

    public void testCommand_CommandName_StringNull() {
        this.testCommand_CommandName("name", null);
    }

    public void testCommand_CommandName_StringEmpty() {
        this.testCommand_CommandName("name", "");
    }

    public void testCommand_CommandName_StringStringUnchanged() {
        this.testCommand_CommandName("name", "name");
    }

    public void testCommand_CommandName_StringStringChanged() {
        this.testCommand_CommandName("name", "name2");
    }

    private void testCommand_Description(String before, String after) {
        MApplication application = this.createApplication();
        MCommand command = MApplicationFactory.eINSTANCE.createCommand();
        command.setDescription(before);
        application.getCommands().add((Object)command);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        command.setDescription(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        command = (MCommand)application.getCommands().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerCommandTest.assertEquals((String)before, (String)command.getDescription());
        this.applyAll(deltas);
        ModelReconcilerCommandTest.assertEquals((String)after, (String)command.getDescription());
    }

    public void testCommand_Description_NullNull() {
        this.testCommand_Description(null, null);
    }

    public void testCommand_Description_NullEmpty() {
        this.testCommand_Description(null, "");
    }

    public void testCommand_Description_NullString() {
        this.testCommand_Description(null, "description");
    }

    public void testCommand_Description_EmptyNull() {
        this.testCommand_Description("", null);
    }

    public void testCommand_Description_EmptyEmpty() {
        this.testCommand_Description("", "");
    }

    public void testCommand_Description_EmptyString() {
        this.testCommand_Description("", "description");
    }

    public void testCommand_Description_StringNull() {
        this.testCommand_Description("description", null);
    }

    public void testCommand_Description_StringEmpty() {
        this.testCommand_Description("description", "");
    }

    public void testCommand_Description_StringStringUnchanged() {
        this.testCommand_Description("description", "description");
    }

    public void testCommand_Description_StringStringChanged() {
        this.testCommand_Description("description", "description2");
    }
}

