/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import javax.inject.Inject;
import javax.inject.Named;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MPartStack;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.workbench.swt.internal.E4Application;

public class Bug308317Test
extends TestCase {
    protected IEclipseContext appContext;

    protected void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
    }

    protected void tearDown() throws Exception {
        if (this.appContext instanceof IDisposable) {
            ((IDisposable)this.appContext).dispose();
        }
    }

    public void testBug308317() throws Exception {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        application.setSelectedElement((MUIElement)window);
        MPartStack stackA = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stackA);
        window.setSelectedElement((MUIElement)stackA);
        MPartStack stackB = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stackB);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        stackA.getChildren().add((Object)partA);
        stackA.setSelectedElement((MUIElement)partA);
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        stackB.getChildren().add((Object)partB);
        stackB.setSelectedElement((MUIElement)partB);
        IEclipseContext windowContext = EclipseContextFactory.create((IEclipseContext)this.appContext, null);
        windowContext.set(MWindow.class.getName(), (Object)window);
        window.setContext(windowContext);
        IEclipseContext partContextA = EclipseContextFactory.create((IEclipseContext)windowContext, null);
        partContextA.set(MPart.class.getName(), (Object)partA);
        partA.setContext(partContextA);
        IEclipseContext partContextB = EclipseContextFactory.create((IEclipseContext)windowContext, null);
        partContextB.set(MPart.class.getName(), (Object)partB);
        partB.setContext(partContextB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        PartConsumer getter = (PartConsumer)ContextInjectionFactory.make(PartConsumer.class, (IEclipseContext)window.getContext());
        window.getContext().set("activeChildContext", (Object)partA.getContext());
        Bug308317Test.assertEquals((Object)partA, (Object)getter.part);
        window.getContext().set("activeChildContext", (Object)partB.getContext());
        Bug308317Test.assertEquals((Object)partB, (Object)getter.part);
        window.getContext().set("activeChildContext", (Object)partA.getContext());
        Bug308317Test.assertEquals((Object)partA, (Object)getter.part);
        window.getContext().set("activeChildContext", null);
        Bug308317Test.assertEquals(null, (Object)getter.part);
        ((IDisposable)partB.getContext()).dispose();
        window.getContext().set("activeChildContext", (Object)partA.getContext());
        Bug308317Test.assertEquals((Object)partA, (Object)getter.part);
    }

    static class PartConsumer {
        private MPart part;

        PartConsumer() {
        }

        @Inject
        void setPart(@Optional @Named(value="e4ActivePart") MPart part) {
            this.part = part;
            if (part != null) {
                part.getContext().get("abc");
            }
        }
    }
}

