/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.commands.tests;

import javax.inject.Named;
import junit.framework.TestCase;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.commands.tests.TestActivator;
import org.eclipse.e4.core.commands.tests.TestUtil;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;

public class HandlerTest
extends TestCase {
    private static final String ACTIVE_INFO_ID = "activeInfo";
    private static final String TEST_ID2 = "test.id2";
    private static final String TEST_ID1 = "test.id1";
    private static final String TEST_CAT1 = "test.cat1";
    private IEclipseContext workbenchContext;

    public void testCallHandler() throws Exception {
        EHandlerService hs = (EHandlerService)this.workbenchContext.get(EHandlerService.class.getName());
        CallHandler handler = new CallHandler();
        hs.activateHandler(TEST_ID1, (Object)handler);
        HandlerTest.assertFalse((boolean)handler.q1);
        HandlerTest.assertFalse((boolean)handler.q2);
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        HandlerTest.assertTrue((boolean)hs.canExecute(cmd));
        HandlerTest.assertFalse((boolean)handler.q2);
        HandlerTest.assertEquals((Object)Boolean.TRUE, (Object)hs.executeHandler(cmd));
        HandlerTest.assertTrue((boolean)handler.q1);
        HandlerTest.assertTrue((boolean)handler.q2);
    }

    public void testDeactivateHandler() throws Exception {
        EHandlerService hs = (EHandlerService)this.workbenchContext.get(EHandlerService.class.getName());
        CallHandler handler = new CallHandler();
        hs.activateHandler(TEST_ID1, (Object)handler);
        HandlerTest.assertFalse((boolean)handler.q1);
        HandlerTest.assertFalse((boolean)handler.q2);
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        HandlerTest.assertTrue((boolean)hs.canExecute(cmd));
        HandlerTest.assertFalse((boolean)handler.q2);
        hs.deactivateHandler(TEST_ID1, (Object)handler);
        HandlerTest.assertNull((Object)hs.executeHandler(cmd));
        HandlerTest.assertTrue((boolean)handler.q1);
        HandlerTest.assertFalse((boolean)handler.q2);
    }

    public void testActiveHandlerExecuteWorkbench() throws Exception {
        IEclipseContext c1 = TestUtil.createContext(this.workbenchContext, "c1");
        this.workbenchContext.set("activeChildContext", (Object)c1);
        EHandlerService h1 = (EHandlerService)c1.get(EHandlerService.class.getName());
        CallHandler handler1 = new CallHandler();
        h1.activateHandler(TEST_ID1, (Object)handler1);
        ECommandService cs = (ECommandService)c1.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        HandlerTest.assertTrue((boolean)h1.canExecute(cmd));
        EHandlerService wHS = (EHandlerService)this.workbenchContext.get(EHandlerService.class.getName());
        HandlerTest.assertTrue((boolean)wHS.canExecute(cmd));
    }

    public void testQueryTwoHandlers() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EHandlerService wHS = (EHandlerService)this.workbenchContext.get(EHandlerService.class.getName());
        IEclipseContext c1 = TestUtil.createContext(this.workbenchContext, "c1");
        this.workbenchContext.set("activeChildContext", (Object)c1);
        EHandlerService h1 = (EHandlerService)c1.get(EHandlerService.class.getName());
        CallHandler handler1 = new CallHandler();
        h1.activateHandler(TEST_ID1, (Object)handler1);
        IEclipseContext c2 = TestUtil.createContext(this.workbenchContext, "c2");
        EHandlerService h2 = (EHandlerService)c2.get(EHandlerService.class.getName());
        CallHandler handler2 = new CallHandler();
        h2.activateHandler(TEST_ID1, (Object)handler2);
        HandlerTest.assertFalse((boolean)handler1.q1);
        HandlerTest.assertFalse((boolean)handler2.q1);
        HandlerTest.assertEquals((Object)Boolean.TRUE, (Object)wHS.executeHandler(cmd));
        HandlerTest.assertTrue((boolean)handler1.q1);
        HandlerTest.assertTrue((boolean)handler1.q2);
        HandlerTest.assertFalse((boolean)handler2.q1);
        HandlerTest.assertFalse((boolean)handler2.q2);
    }

    public void testExecuteTwoActiveHandlers() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EHandlerService wHS = (EHandlerService)this.workbenchContext.get(EHandlerService.class.getName());
        IEclipseContext c1 = TestUtil.createContext(this.workbenchContext, "c1");
        this.workbenchContext.set("activeChildContext", (Object)c1);
        EHandlerService h1 = (EHandlerService)c1.get(EHandlerService.class.getName());
        CallHandler handler1 = new CallHandler();
        h1.activateHandler(TEST_ID1, (Object)handler1);
        IEclipseContext c2 = TestUtil.createContext(this.workbenchContext, "c2");
        EHandlerService h2 = (EHandlerService)c2.get(EHandlerService.class.getName());
        CallHandler handler2 = new CallHandler();
        h2.activateHandler(TEST_ID1, (Object)handler2);
        HandlerTest.assertTrue((boolean)h1.canExecute(cmd));
        HandlerTest.assertTrue((boolean)handler1.q1);
        HandlerTest.assertFalse((boolean)handler2.q1);
        HandlerTest.assertTrue((boolean)h2.canExecute(cmd));
        HandlerTest.assertTrue((boolean)handler2.q1);
        HandlerTest.assertFalse((boolean)handler1.q2);
        HandlerTest.assertFalse((boolean)handler2.q2);
        HandlerTest.assertEquals((Object)Boolean.TRUE, (Object)wHS.executeHandler(cmd));
        HandlerTest.assertTrue((boolean)handler1.q2);
        HandlerTest.assertFalse((boolean)handler2.q2);
    }

    public void testSwitchActivationTwoHandlers() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EHandlerService wHS = (EHandlerService)this.workbenchContext.get(EHandlerService.class.getName());
        IEclipseContext c1 = TestUtil.createContext(this.workbenchContext, "c1");
        this.workbenchContext.set("activeChildContext", (Object)c1);
        EHandlerService h1 = (EHandlerService)c1.get(EHandlerService.class.getName());
        CallHandler handler1 = new CallHandler();
        h1.activateHandler(TEST_ID1, (Object)handler1);
        IEclipseContext c2 = TestUtil.createContext(this.workbenchContext, "c2");
        EHandlerService h2 = (EHandlerService)c2.get(EHandlerService.class.getName());
        CallHandler handler2 = new CallHandler();
        h2.activateHandler(TEST_ID1, (Object)handler2);
        HandlerTest.assertFalse((boolean)handler1.q1);
        HandlerTest.assertFalse((boolean)handler2.q1);
        HandlerTest.assertEquals((Object)Boolean.TRUE, (Object)wHS.executeHandler(cmd));
        HandlerTest.assertTrue((boolean)handler1.q1);
        HandlerTest.assertTrue((boolean)handler1.q2);
        HandlerTest.assertFalse((boolean)handler2.q1);
        HandlerTest.assertFalse((boolean)handler2.q2);
        handler1.q1 = false;
        handler1.q2 = false;
        this.workbenchContext.set("activeChildContext", (Object)c2);
        HandlerTest.assertEquals((Object)Boolean.TRUE, (Object)wHS.executeHandler(cmd));
        HandlerTest.assertTrue((boolean)handler2.q1);
        HandlerTest.assertTrue((boolean)handler2.q2);
        HandlerTest.assertFalse((boolean)handler1.q1);
        HandlerTest.assertFalse((boolean)handler1.q2);
    }

    public void testMethodInfo() throws Exception {
        Info helloInfo = new Info("Hello");
        this.workbenchContext.set(Info.class.getName(), (Object)helloInfo);
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EHandlerService wHS = (EHandlerService)this.workbenchContext.get(EHandlerService.class.getName());
        HandlerWithInfo handler = new HandlerWithInfo();
        wHS.activateHandler(TEST_ID1, (Object)handler);
        HandlerTest.assertEquals((Object)helloInfo, (Object)wHS.executeHandler(cmd));
    }

    public void testMethodWithAnnocation() throws Exception {
        Info helloInfo = new Info("Hello");
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EHandlerService wHS = (EHandlerService)this.workbenchContext.get(EHandlerService.class.getName());
        HandlerWithAnnotations handler = new HandlerWithAnnotations();
        wHS.activateHandler(TEST_ID1, (Object)handler);
        this.workbenchContext.set(Info.class.getName(), (Object)helloInfo);
        HandlerTest.assertNull((Object)wHS.executeHandler(cmd));
        this.workbenchContext.remove(Info.class.getName());
        HandlerTest.assertNull((Object)wHS.executeHandler(cmd));
        this.workbenchContext.set(ACTIVE_INFO_ID, (Object)helloInfo);
        HandlerTest.assertEquals((Object)helloInfo, (Object)wHS.executeHandler(cmd));
        this.workbenchContext.remove(ACTIVE_INFO_ID);
        HandlerTest.assertNull((Object)wHS.executeHandler(cmd));
    }

    protected void setUp() throws Exception {
        this.workbenchContext = this.createWorkbenchContext(TestActivator.getDefault().getGlobalContext());
        this.defineCommands(this.workbenchContext);
    }

    protected void tearDown() throws Exception {
        if (this.workbenchContext instanceof IDisposable) {
            ((IDisposable)this.workbenchContext).dispose();
        }
        this.workbenchContext = null;
    }

    private void defineCommands(IEclipseContext context) {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        Category category = cs.defineCategory(TEST_CAT1, "CAT1", null);
        cs.defineCommand(TEST_ID1, "ID1", null, category, null);
        cs.defineCommand(TEST_ID2, "ID2", null, category, null);
    }

    private IEclipseContext createWorkbenchContext(IEclipseContext globalContext) {
        IEclipseContext wb = TestUtil.createContext(globalContext, "workbenchContext");
        return wb;
    }

    static class CallHandler {
        public boolean q1;
        public boolean q2;

        CallHandler() {
        }

        public boolean canExecute() {
            this.q1 = true;
            return true;
        }

        public Object execute() {
            this.q2 = true;
            if (this.q1) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    static class HandlerWithAnnotations {
        HandlerWithAnnotations() {
        }

        public boolean canExecute(@Named(value="activeInfo") Info h) {
            return h.name.equals("Hello");
        }

        public Object execute(@Named(value="activeInfo") Info h) {
            return h.name.equals("Hello") ? h : null;
        }
    }

    static class HandlerWithInfo {
        HandlerWithInfo() {
        }

        public boolean canExecute(Info h) {
            return h.name.equals("Hello");
        }

        public Object execute(Info h) {
            return h.name.equals("Hello") ? h : null;
        }
    }

    static class Info {
        public String name;

        public Info(String name) {
            this.name = name;
        }
    }
}

