/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.SWTElement;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

public class CTabFolderTest
extends CSSSWTTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);
    static final RGB WHITE = new RGB(255, 255, 255);
    public static CSSEngine engine;

    protected CTabFolder createTestCTabFolder(String styleSheet) {
        Display display = Display.getDefault();
        engine = this.createEngine(styleSheet, display);
        Shell shell = new Shell(display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        CTabFolder folderToTest = new CTabFolder(panel, 0);
        CTabItem tab1 = new CTabItem(folderToTest, 0);
        tab1.setText("A TAB ITEM");
        engine.applyStyles((Object)shell, true);
        shell.pack();
        return folderToTest;
    }

    protected ToolBar[] createTestToolBars(String styleSheet) {
        Display display = Display.getDefault();
        engine = this.createEngine(styleSheet, display);
        Shell shell = new Shell(display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        CTabFolder folderA = new CTabFolder(panel, 0);
        CTabItem tabA = new CTabItem(folderA, 0);
        tabA.setText("FolderA TAB ITEM");
        ToolBar toolbarA = new ToolBar((Composite)folderA, 0x800100);
        folderA.setTopRight((Control)toolbarA);
        CTabFolder folderB = new CTabFolder(panel, 0);
        CTabItem tabB = new CTabItem(folderB, 0);
        tabB.setText("FolderB TAB ITEM");
        ToolBar toolbarB = new ToolBar((Composite)folderB, 0x800100);
        folderB.setTopRight((Control)toolbarB);
        ToolBar toolbarC = new ToolBar(panel, 0x800100);
        engine.applyStyles((Object)shell, true);
        return new ToolBar[]{toolbarA, toolbarB, toolbarC};
    }

    protected Shell createShell(String styleSheet) {
        Display display = Display.getDefault();
        engine = this.createEngine(styleSheet, display);
        Shell shell = new Shell(display, 0);
        engine.applyStyles((Object)shell, true);
        shell.pack();
        return shell;
    }

    public void testBackgroundColor() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { background-color: #0000FF }");
        CTabFolderTest.assertEquals((Object)BLUE, (Object)folderToTest.getBackground().getRGB());
    }

    public void testTextColor() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { color: #0000FF }");
        CTabFolderTest.assertEquals((Object)BLUE, (Object)folderToTest.getForeground().getRGB());
    }

    public void testFontRegular() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { font: Verdana 16px }");
        CTabFolderTest.assertEquals((int)1, (int)folderToTest.getFont().getFontData().length);
        FontData fontData = folderToTest.getFont().getFontData()[0];
        CTabFolderTest.assertEquals((String)"Verdana", (String)fontData.getName());
        CTabFolderTest.assertEquals((int)16, (int)fontData.getHeight());
        CTabFolderTest.assertEquals((int)0, (int)fontData.getStyle());
    }

    public void testFontBold() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { font: Arial 12px; font-weight: bold }");
        CTabFolderTest.assertEquals((int)1, (int)folderToTest.getFont().getFontData().length);
        FontData fontData = folderToTest.getFont().getFontData()[0];
        CTabFolderTest.assertEquals((String)"Arial", (String)fontData.getName());
        CTabFolderTest.assertEquals((int)12, (int)fontData.getHeight());
        CTabFolderTest.assertEquals((int)1, (int)fontData.getStyle());
    }

    public void testFontItalic() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { font: Arial 12px; font-style: italic }");
        CTabFolderTest.assertEquals((int)1, (int)folderToTest.getFont().getFontData().length);
        FontData fontData = folderToTest.getFont().getFontData()[0];
        CTabFolderTest.assertEquals((String)"Arial", (String)fontData.getName());
        CTabFolderTest.assertEquals((int)12, (int)fontData.getHeight());
        CTabFolderTest.assertEquals((int)2, (int)fontData.getStyle());
    }

    public void testBorderVisible() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { border-visible: true}");
        CTabFolderTest.assertEquals((boolean)true, (boolean)folderToTest.getBorderVisible());
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)folderToTest, "border-visible", null));
        folderToTest.getShell().close();
        folderToTest = this.createTestCTabFolder("CTabFolder { border-visible: false}");
        CTabFolderTest.assertEquals((boolean)false, (boolean)folderToTest.getBorderVisible());
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)folderToTest, "border-visible", null));
    }

    public void testSimple() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { simple: true}");
        CTabFolderTest.assertEquals((boolean)true, (boolean)folderToTest.getSimple());
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)folderToTest, "simple", null));
        folderToTest.getShell().close();
        folderToTest = this.createTestCTabFolder("CTabFolder { simple: false}");
        CTabFolderTest.assertEquals((boolean)false, (boolean)folderToTest.getSimple());
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)folderToTest, "simple", null));
    }

    public void testMaximizeVisible() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { maximize-visible: true}");
        CTabFolderTest.assertEquals((boolean)true, (boolean)folderToTest.getMaximizeVisible());
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)folderToTest, "maximize-visible", null));
        folderToTest.getShell().close();
        folderToTest = this.createTestCTabFolder("CTabFolder { maximize-visible: false}");
        CTabFolderTest.assertEquals((boolean)false, (boolean)folderToTest.getMaximizeVisible());
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)folderToTest, "maximize-visible", null));
    }

    public void testMinimizeVisible() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { minimize-visible: true}");
        CTabFolderTest.assertEquals((boolean)true, (boolean)folderToTest.getMinimizeVisible());
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)folderToTest, "minimize-visible", null));
        folderToTest.getShell().close();
        folderToTest = this.createTestCTabFolder("CTabFolder { minimize-visible: false}");
        CTabFolderTest.assertEquals((boolean)false, (boolean)folderToTest.getMinimizeVisible());
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)folderToTest, "minimize-visible", null));
    }

    public void testMRUVisible() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { mru-visible: true}");
        CTabFolderTest.assertEquals((boolean)true, (boolean)folderToTest.getMRUVisible());
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)folderToTest, "mru-visible", null));
        folderToTest.getShell().close();
        folderToTest = this.createTestCTabFolder("CTabFolder { mru-visible: false}");
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)folderToTest, "mru-visible", null));
        CTabFolderTest.assertEquals((boolean)false, (boolean)folderToTest.getMRUVisible());
    }

    public void testMaximized() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { maximized: true}");
        CTabFolderTest.assertEquals((boolean)true, (boolean)folderToTest.getMaximized());
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)folderToTest, "maximized", null));
        folderToTest = this.createTestCTabFolder("CTabFolder { maximized: false}");
        CTabFolderTest.assertEquals((boolean)false, (boolean)folderToTest.getMaximized());
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)folderToTest, "maximized", null));
    }

    public void testMinimized() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { minimized: true}");
        CTabFolderTest.assertEquals((boolean)true, (boolean)folderToTest.getMinimized());
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)folderToTest, "minimized", null));
        folderToTest = this.createTestCTabFolder("CTabFolder { minimized: false}");
        CTabFolderTest.assertEquals((boolean)false, (boolean)folderToTest.getMinimized());
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)folderToTest, "minimized", null));
    }

    public void testTabHeight() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { tab-height: 30px }");
        CTabFolderTest.assertEquals((int)30, (int)folderToTest.getTabHeight());
        folderToTest = this.createTestCTabFolder("CTabFolder { tab-height: 40px }");
        CTabFolderTest.assertEquals((int)40, (int)folderToTest.getTabHeight());
        folderToTest = this.createTestCTabFolder("CTabFolder { tab-height: 40px 50px }");
        CTabFolderTest.assertNotSame((Object)40, (Object)folderToTest.getTabHeight());
        CTabFolderTest.assertNotSame((Object)50, (Object)folderToTest.getTabHeight());
        folderToTest = this.createTestCTabFolder("CTabFolder { tab-height: 40 }");
        CTabFolderTest.assertNotSame((Object)40, (Object)folderToTest.getTabHeight());
    }

    public void testSingle() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { single: true}");
        CTabFolderTest.assertEquals((boolean)true, (boolean)folderToTest.getSingle());
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)folderToTest, "single", null));
        folderToTest = this.createTestCTabFolder("CTabFolder { single: false}");
        CTabFolderTest.assertEquals((boolean)false, (boolean)folderToTest.getSingle());
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)folderToTest, "single", null));
    }

    public void testUnselectedCloseVisible() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { unselected-close-visible: true}");
        CTabFolderTest.assertEquals((boolean)true, (boolean)folderToTest.getUnselectedCloseVisible());
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)folderToTest, "unselected-close-visible", null));
        folderToTest = this.createTestCTabFolder("CTabFolder { unselected-close-visible: false}");
        CTabFolderTest.assertEquals((boolean)false, (boolean)folderToTest.getUnselectedCloseVisible());
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)folderToTest, "unselected-close-visible", null));
    }

    public void testUnselectedImageVisible() throws Exception {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { unselected-image-visible: true}");
        CTabFolderTest.assertEquals((boolean)true, (boolean)folderToTest.getUnselectedImageVisible());
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)folderToTest, "unselected-image-visible", null));
        folderToTest = this.createTestCTabFolder("CTabFolder { unselected-image-visible: false}");
        CTabFolderTest.assertEquals((boolean)false, (boolean)folderToTest.getUnselectedImageVisible());
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)folderToTest, "unselected-image-visible", null));
    }

    public void testRetrievePropertyNull() {
        Shell shell = this.createShell("Shell {color:red}");
        CTabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "border-visible", null));
        CTabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "maximized", null));
        CTabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "maximize-visible", null));
        CTabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "minimize-visible", null));
        CTabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "mru-visible", null));
        CTabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "show-close", null));
        CTabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "simple", null));
        CTabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "single", null));
        CTabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "unselected-close-visible", null));
        CTabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "unselected-image-visible", null));
    }

    public void testTopRightAsDescendentChild() throws Exception {
        ToolBar[] toolBars = this.createTestToolBars("CTabFolder.special ToolBar { background: #FF0000}\nCTabFolder ToolBar { background: #00FF00}\nCTabFolder.extraordinary ToolBar { background: #FFFFFF}\nToolBar { background: #0000FF}");
        ToolBar barA = toolBars[0];
        ToolBar barB = toolBars[1];
        ToolBar barC = toolBars[2];
        SWTElement.setCSSClass((Widget)barA.getParent(), (String)"special");
        engine.applyStyles((Object)barA.getShell(), true);
        CTabFolderTest.assertEquals((Object)RED, (Object)barA.getBackground().getRGB());
        CTabFolderTest.assertEquals((Object)GREEN, (Object)barB.getBackground().getRGB());
        CTabFolderTest.assertEquals((Object)BLUE, (Object)barC.getBackground().getRGB());
        SWTElement.setCSSClass((Widget)barA.getParent(), (String)"extraordinary");
        engine.applyStyles((Object)barA.getShell(), true);
        CTabFolderTest.assertEquals((Object)WHITE, (Object)barA.getBackground().getRGB());
    }
}

