/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.workbench.editors;

import java.io.IOException;
import java.net.URL;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MDirtyable;
import org.eclipse.e4.ui.model.application.MUILabel;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.ui.workbench.views.XWTStaticPart;
import org.eclipse.jface.databinding.swt.ISWTObservable;
import org.eclipse.swt.widgets.Control;

public abstract class XWTSaveablePart
extends XWTStaticPart {
    @Inject
    private MDirtyable dirtyable;
    @Inject
    private MUILabel uiItem;
    private DirtyManager dirtyManager = new DirtyManager();

    public abstract void doSave(@Optional IProgressMonitor var1) throws IOException, InterruptedException;

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    protected void refresh(URL url, Object dataContext, ClassLoader loader) {
        Control loadedRoot = null;
        Control[] children = this.getParent().getChildren();
        if (children.length > 0) {
            loadedRoot = children[0];
        }
        if (loadedRoot != null) {
            XWT.removeObservableChangeListener((Object)loadedRoot, (IChangeListener)this.dirtyManager);
        }
        super.refresh(url, dataContext, loader);
        this.dirtyable.setDirty(false);
        children = this.getParent().getChildren();
        if (children.length > 0) {
            loadedRoot = children[0];
        }
        if (loadedRoot != null) {
            XWT.addObservableChangeListener((Object)loadedRoot, (IChangeListener)this.dirtyManager);
        }
    }

    protected void updatePartTitle(String title) {
        this.uiItem.setLabel(title.toString());
    }

    public boolean isDirty() {
        return this.dirtyable.isDirty();
    }

    public void setDirty(Boolean dirty) {
        this.dirtyable.setDirty(dirty.booleanValue());
    }

    class DirtyManager
    implements IChangeListener {
        DirtyManager() {
        }

        public void handleChange(ChangeEvent event) {
            if (XWTSaveablePart.this.dirtyable.isDirty()) {
                return;
            }
            Object source = event.getSource();
            if (!(source instanceof ISWTObservable)) {
                XWTSaveablePart.this.setDirty(true);
            }
        }
    }
}

