/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextChangeEvent;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.IRunAndTrack;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.TestHelper;
import org.eclipse.e4.core.services.internal.context.AddContextFunction;

public class EclipseContextTest
extends TestCase {
    private IEclipseContext context;
    private IEclipseContext parentContext;
    private int runCounter;

    protected void setUp() throws Exception {
        super.setUp();
        this.parentContext = EclipseContextFactory.create();
        this.parentContext.set("debugString", (Object)(String.valueOf(this.getName()) + "-parent"));
        this.context = EclipseContextFactory.create((IEclipseContext)this.parentContext, null);
        this.context.set("debugString", (Object)this.getName());
        this.runCounter = 0;
    }

    public void testContainsKey() {
        EclipseContextTest.assertFalse((String)"1.0", (boolean)this.context.containsKey("function"));
        EclipseContextTest.assertFalse((String)"1.1", (boolean)this.context.containsKey("separator"));
        this.context.set("function", (Object)new ConcatFunction());
        this.context.set("separator", (Object)",");
        EclipseContextTest.assertTrue((String)"2.0", (boolean)this.context.containsKey("function"));
        EclipseContextTest.assertTrue((String)"2.1", (boolean)this.context.containsKey("separator"));
        this.context.set("separator", null);
        EclipseContextTest.assertTrue((String)"3.0", (boolean)this.context.containsKey("separator"));
        this.context.remove("separator");
        EclipseContextTest.assertFalse((String)"4.0", (boolean)this.context.containsKey("separator"));
    }

    public void testContainsKeyLocal() {
        IEclipseContext contextGlobal = EclipseContextFactory.create();
        contextGlobal.set("global", new Object());
        IEclipseContext contextLocal = EclipseContextFactory.create((IEclipseContext)contextGlobal, null);
        contextLocal.set("local", new Object());
        EclipseContextTest.assertTrue((String)"1.0", (boolean)contextLocal.containsKey("local", true));
        EclipseContextTest.assertTrue((String)"1.1", (boolean)contextLocal.containsKey("local", false));
        EclipseContextTest.assertFalse((String)"1.2", (boolean)contextLocal.containsKey("global", true));
        EclipseContextTest.assertTrue((String)"1.3", (boolean)contextLocal.containsKey("global", false));
        EclipseContextTest.assertFalse((String)"2.0", (boolean)contextGlobal.containsKey("local", true));
        EclipseContextTest.assertFalse((String)"2.1", (boolean)contextGlobal.containsKey("local", false));
        EclipseContextTest.assertTrue((String)"2.2", (boolean)contextGlobal.containsKey("global", true));
        EclipseContextTest.assertTrue((String)"2.3", (boolean)contextGlobal.containsKey("global", false));
    }

    public void testFunctions() {
        this.context.set("function", (Object)new ConcatFunction());
        this.context.set("separator", (Object)",");
        EclipseContextTest.assertEquals((Object)"x", (Object)this.context.get("function", (Object[])new String[]{"x"}));
        EclipseContextTest.assertEquals((Object)"x,y", (Object)this.context.get("function", (Object[])new String[]{"x", "y"}));
    }

    public void testGet() {
        EclipseContextTest.assertNull((Object)this.context.get("foo"));
        this.context.set("foo", (Object)"bar");
        EclipseContextTest.assertEquals((Object)"bar", (Object)this.context.get("foo"));
        EclipseContextTest.assertNull((Object)this.parentContext.get("foo"));
        this.context.remove("foo");
        EclipseContextTest.assertNull((Object)this.context.get("foo"));
        this.parentContext.set("foo", (Object)"bar");
        EclipseContextTest.assertEquals((Object)"bar", (Object)this.context.get("foo"));
        this.context.set("foo", (Object)new ComputedValueBar());
        EclipseContextTest.assertNull((Object)this.context.get("foo"));
        this.context.set("bar", (Object)"baz");
        EclipseContextTest.assertEquals((Object)"baz", (Object)this.context.get("foo"));
    }

    public void testGetLocal() {
        EclipseContextTest.assertNull((Object)this.context.getLocal("foo"));
        this.context.set("foo", (Object)"bar");
        EclipseContextTest.assertEquals((Object)"bar", (Object)this.context.getLocal("foo"));
        EclipseContextTest.assertNull((Object)this.parentContext.getLocal("foo"));
        this.context.remove("foo");
        EclipseContextTest.assertNull((Object)this.context.getLocal("foo"));
        this.parentContext.set("foo", (Object)"bar");
        EclipseContextTest.assertNull((Object)this.context.getLocal("foo"));
        this.context.set("foo", (Object)new ComputedValueBar());
        EclipseContextTest.assertNull((Object)this.context.getLocal("foo"));
        this.context.set("bar", (Object)"baz");
        EclipseContextTest.assertEquals((Object)"baz", (Object)this.context.getLocal("foo"));
    }

    public void testDisposeRemovesParentReference() {
        EclipseContextTest.assertNull((Object)this.context.get("foo"));
        this.parentContext.set("foo", (Object)"bar");
        EclipseContextTest.assertEquals((Object)"bar", (Object)this.context.get("foo"));
        ((IDisposable)this.context).dispose();
        EclipseContextTest.assertNull((Object)this.context.get("foo"));
    }

    public void testContextFunctionInParent() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext child = EclipseContextFactory.create((IEclipseContext)parent, null);
        parent.set("sum", (Object)new AddContextFunction());
        parent.set("x", (Object)new Integer(3));
        parent.set("y", (Object)new Integer(3));
        child.set("x", (Object)new Integer(1));
        child.set("y", (Object)new Integer(1));
        EclipseContextTest.assertEquals((int)6, (int)((Integer)parent.get("sum")));
        EclipseContextTest.assertEquals((int)2, (int)((Integer)child.get("sum")));
        child.set("x", (Object)new Integer(5));
        EclipseContextTest.assertEquals((int)6, (int)((Integer)parent.get("sum")));
        EclipseContextTest.assertEquals((int)6, (int)((Integer)child.get("sum")));
        child.remove("x");
        EclipseContextTest.assertEquals((int)6, (int)((Integer)parent.get("sum")));
        EclipseContextTest.assertEquals((int)4, (int)((Integer)child.get("sum")));
        parent.set("x", (Object)new Integer(10));
        EclipseContextTest.assertEquals((int)13, (int)((Integer)parent.get("sum")));
        EclipseContextTest.assertEquals((int)11, (int)((Integer)child.get("sum")));
    }

    public void testContextEvents() {
        final Object[] value = new Object[1];
        final int[] eventType = new int[1];
        IRunAndTrack runnable = new IRunAndTrack(){

            public boolean notify(ContextChangeEvent event) {
                EclipseContextTest eclipseContextTest = EclipseContextTest.this;
                eclipseContextTest.runCounter = eclipseContextTest.runCounter + 1;
                eventType[0] = event.getEventType();
                value[0] = EclipseContextTest.this.context.get("foo");
                return true;
            }
        };
        this.context.runAndTrack(runnable, null);
        EclipseContextTest.assertEquals((int)1, (int)this.runCounter);
        EclipseContextTest.assertEquals((int)0, (int)eventType[0]);
        this.context.set("foo", (Object)"bar");
        EclipseContextTest.assertEquals((int)2, (int)this.runCounter);
        EclipseContextTest.assertEquals((int)1, (int)eventType[0]);
        EclipseContextTest.assertEquals((Object)"bar", (Object)value[0]);
        this.context.remove("foo");
        EclipseContextTest.assertEquals((int)2, (int)eventType[0]);
        EclipseContextTest.assertEquals((int)3, (int)this.runCounter);
        ((IDisposable)this.context).dispose();
        EclipseContextTest.assertEquals((int)4, (int)this.runCounter);
        EclipseContextTest.assertEquals((int)3, (int)eventType[0]);
    }

    public void testRunAndTrack() {
        final Object[] value = new Object[1];
        this.context.runAndTrack(new IRunAndTrack(){

            public boolean notify(ContextChangeEvent event) {
                EclipseContextTest eclipseContextTest = EclipseContextTest.this;
                eclipseContextTest.runCounter = eclipseContextTest.runCounter + 1;
                value[0] = EclipseContextTest.this.context.get("foo");
                return true;
            }
        }, null);
        EclipseContextTest.assertEquals((int)1, (int)this.runCounter);
        EclipseContextTest.assertEquals(null, (Object)value[0]);
        this.context.set("foo", (Object)"bar");
        EclipseContextTest.assertEquals((int)2, (int)this.runCounter);
        EclipseContextTest.assertEquals((Object)"bar", (Object)value[0]);
        this.context.remove("foo");
        EclipseContextTest.assertEquals((int)3, (int)this.runCounter);
        EclipseContextTest.assertEquals(null, (Object)value[0]);
        this.context.set("foo", (Object)new IContextFunction(){

            public Object compute(IEclipseContext context, Object[] arguments) {
                return context.get("bar");
            }
        });
        EclipseContextTest.assertEquals((int)4, (int)this.runCounter);
        EclipseContextTest.assertEquals(null, (Object)value[0]);
        this.context.set("bar", (Object)"baz");
        EclipseContextTest.assertEquals((int)5, (int)this.runCounter);
        EclipseContextTest.assertEquals((Object)"baz", (Object)value[0]);
        this.context.set("bar", (Object)"baf");
        EclipseContextTest.assertEquals((int)6, (int)this.runCounter);
        EclipseContextTest.assertEquals((Object)"baf", (Object)value[0]);
        this.context.remove("bar");
        EclipseContextTest.assertEquals((int)7, (int)this.runCounter);
        EclipseContextTest.assertEquals(null, (Object)value[0]);
        this.parentContext.set("bar", (Object)"bam");
        EclipseContextTest.assertEquals((int)8, (int)this.runCounter);
        EclipseContextTest.assertEquals((Object)"bam", (Object)value[0]);
    }

    public void testRegisterRunAndTrackTwice() {
        final Object[] value = new Object[1];
        IRunAndTrack runnable = new IRunAndTrack(){

            public boolean notify(ContextChangeEvent event) {
                EclipseContextTest eclipseContextTest = EclipseContextTest.this;
                eclipseContextTest.runCounter = eclipseContextTest.runCounter + 1;
                value[0] = EclipseContextTest.this.context.get("foo");
                return true;
            }
        };
        this.context.runAndTrack(runnable, null);
        EclipseContextTest.assertEquals((int)1, (int)this.runCounter);
        this.context.runAndTrack(runnable, null);
        EclipseContextTest.assertEquals((int)2, (int)this.runCounter);
        EclipseContextTest.assertEquals(null, (Object)value[0]);
        this.context.set("foo", (Object)"bar");
        EclipseContextTest.assertEquals((int)3, (int)this.runCounter);
        EclipseContextTest.assertEquals((Object)"bar", (Object)value[0]);
        this.context.remove("foo");
        EclipseContextTest.assertEquals((int)4, (int)this.runCounter);
    }

    public void testRunAndTrackMultipleValues() {
        IEclipseContext parent = EclipseContextFactory.create();
        final IEclipseContext child = EclipseContextFactory.create((IEclipseContext)parent, null);
        parent.set("parentValue", (Object)"x");
        parent.set("debugString", (Object)"ParentContext");
        child.set("childValue", (Object)"x");
        child.set("debugString", (Object)"ChildContext");
        IRunAndTrack runnable = new IRunAndTrack(){

            public boolean notify(ContextChangeEvent event) {
                EclipseContextTest eclipseContextTest = EclipseContextTest.this;
                eclipseContextTest.runCounter = eclipseContextTest.runCounter + 1;
                if (EclipseContextTest.this.runCounter < 2) {
                    child.get("childValue");
                    return true;
                }
                if (EclipseContextTest.this.runCounter < 3) {
                    child.get("parentValue");
                    return true;
                }
                return false;
            }
        };
        child.runAndTrack(runnable, null);
        EclipseContextTest.assertEquals((int)1, (int)this.runCounter);
        child.set("childValue", (Object)"z");
        EclipseContextTest.assertEquals((int)2, (int)this.runCounter);
        parent.set("parentValue", (Object)"z");
        EclipseContextTest.assertEquals((int)3, (int)this.runCounter);
        child.set("childValue", (Object)"y");
        EclipseContextTest.assertEquals((int)3, (int)this.runCounter);
        parent.set("parentValue", (Object)"y");
        EclipseContextTest.assertEquals((int)3, (int)this.runCounter);
        EclipseContextTest.assertTrue((boolean)TestHelper.getListeners((IEclipseContext)child).isEmpty());
        EclipseContextTest.assertTrue((boolean)TestHelper.getListeners((IEclipseContext)parent).isEmpty());
    }

    public void testModify() {
        IEclipseContext grandParent = EclipseContextFactory.create();
        IEclipseContext parent = EclipseContextFactory.create((IEclipseContext)grandParent, null);
        IEclipseContext child = EclipseContextFactory.create((IEclipseContext)parent, null);
        child.set("a", (Object)"a1");
        parent.set("b", (Object)"b2");
        grandParent.set("c", (Object)"c3");
        child.declareModifiable("a");
        parent.declareModifiable("b");
        grandParent.declareModifiable("c");
        EclipseContextTest.assertNull((Object)grandParent.get("b"));
        EclipseContextTest.assertEquals((Object)"b2", (Object)parent.get("b"));
        EclipseContextTest.assertEquals((Object)"b2", (Object)child.get("b"));
        EclipseContextTest.assertFalse((boolean)child.containsKey("b", true));
        child.modify("b", (Object)"abc");
        EclipseContextTest.assertFalse((boolean)grandParent.containsKey("b"));
        EclipseContextTest.assertEquals((Object)"abc", (Object)parent.get("b"));
        EclipseContextTest.assertEquals((Object)"abc", (Object)child.get("b"));
        EclipseContextTest.assertFalse((boolean)child.containsKey("b", true));
        child.modify("d", (Object)"123");
        EclipseContextTest.assertFalse((boolean)grandParent.containsKey("d"));
        EclipseContextTest.assertFalse((boolean)parent.containsKey("d"));
        EclipseContextTest.assertNull((Object)parent.get("d"));
        EclipseContextTest.assertEquals((Object)"123", (Object)child.get("d"));
        grandParent.modify("c", (Object)"cNew");
        EclipseContextTest.assertTrue((boolean)grandParent.containsKey("c"));
        EclipseContextTest.assertEquals((Object)"cNew", (Object)grandParent.get("c"));
        EclipseContextTest.assertFalse((boolean)parent.containsKey("c", true));
        EclipseContextTest.assertFalse((boolean)child.containsKey("c", true));
        EclipseContextTest.assertTrue((boolean)child.containsKey("c", false));
        child.modify("a", (Object)"aNew");
        EclipseContextTest.assertTrue((boolean)child.containsKey("a"));
        EclipseContextTest.assertFalse((boolean)parent.containsKey("a"));
        EclipseContextTest.assertFalse((boolean)grandParent.containsKey("a"));
        EclipseContextTest.assertEquals((Object)"aNew", (Object)child.get("a"));
        EclipseContextTest.assertNull((Object)parent.get("a"));
        child.set("aNo", (Object)"a1");
        parent.set("bNo", (Object)"b2");
        grandParent.set("cNo", (Object)"c3");
        boolean exception = false;
        try {
            child.modify("bNo", (Object)"new");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = true;
        }
        EclipseContextTest.assertTrue((boolean)exception);
        exception = false;
        try {
            grandParent.modify("cNo", (Object)"new");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = true;
        }
        EclipseContextTest.assertTrue((boolean)exception);
        exception = false;
        try {
            child.modify("aNo", (Object)"new");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = true;
        }
        EclipseContextTest.assertTrue((boolean)exception);
    }

    public void testRemoveValueComputationOnDispose() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext child = EclipseContextFactory.create((IEclipseContext)parent, null);
        parent.set("x", (Object)new Integer(1));
        parent.set("y", (Object)new Integer(1));
        parent.set("sum", (Object)new AddContextFunction());
        parent.set("debugString", (Object)"ParentContext");
        child.set("debugString", (Object)"ChildContext");
        child.get("sum");
        EclipseContextTest.assertEquals((int)1, (int)TestHelper.getListeners((IEclipseContext)parent).size());
        ((EclipseContext)child).dispose();
        EclipseContextTest.assertEquals((int)0, (int)TestHelper.getListeners((IEclipseContext)parent).size());
    }

    private static class ComputedValueBar
    extends ContextFunction {
        private ComputedValueBar() {
        }

        public Object compute(IEclipseContext context, Object[] arguments) {
            return context.get("bar");
        }
    }

    private static class ConcatFunction
    implements IContextFunction {
        private ConcatFunction() {
        }

        public Object compute(IEclipseContext context, Object[] arguments) {
            String separator = (String)context.get("separator");
            StringBuffer result = new StringBuffer();
            int i = 0;
            while (i < arguments.length) {
                if (i > 0) {
                    result.append(separator);
                }
                result.append(arguments[i]);
                ++i;
            }
            return result.toString();
        }
    }
}

