/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.e4.core.contexts.ContextChangeEvent;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.IRunAndTrack;
import org.eclipse.e4.core.services.internal.context.AddContextFunction;
import org.eclipse.e4.core.services.internal.context.ObjectSuperClass;

public class ReparentingTest
extends TestCase {
    public static Test suite() {
        return new TestSuite(ReparentingTest.class);
    }

    public ReparentingTest() {
    }

    public ReparentingTest(String name) {
        super(name);
    }

    public void testContextFunctionInParentRemove() {
        IEclipseContext parent = EclipseContextFactory.create();
        parent.set("debugString", (Object)"parent");
        IEclipseContext child = EclipseContextFactory.create((IEclipseContext)parent, null);
        child.set("debugString", (Object)"child");
        parent.set("sum", (Object)new AddContextFunction());
        parent.set("x", (Object)new Integer(3));
        parent.set("y", (Object)new Integer(3));
        child.set("x", (Object)new Integer(1));
        child.set("y", (Object)new Integer(1));
        ReparentingTest.assertEquals((int)6, (int)((Integer)parent.get("sum")));
        ReparentingTest.assertEquals((int)2, (int)((Integer)child.get("sum")));
        child.set("parentContext", (Object)EclipseContextFactory.create());
        ReparentingTest.assertEquals((int)6, (int)((Integer)parent.get("sum")));
        ReparentingTest.assertNull((String)("Expected null but was: " + child.get("sum")), (Object)child.get("sum"));
    }

    public void testContextFunctionInParentAdd() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext child = EclipseContextFactory.create((IEclipseContext)parent, null);
        child.set("x", (Object)new Integer(1));
        child.set("y", (Object)new Integer(1));
        ReparentingTest.assertEquals(null, (Object)parent.get("sum"));
        ReparentingTest.assertEquals(null, (Object)child.get("sum"));
        IEclipseContext newParent = EclipseContextFactory.create();
        child.set("parentContext", (Object)newParent);
        newParent.set("sum", (Object)new AddContextFunction());
        ReparentingTest.assertEquals((int)0, (int)((Integer)newParent.get("sum")));
        ReparentingTest.assertEquals((int)2, (int)((Integer)child.get("sum")));
        newParent.set("x", (Object)new Integer(3));
        newParent.set("y", (Object)new Integer(3));
        ReparentingTest.assertEquals((int)6, (int)((Integer)newParent.get("sum")));
        ReparentingTest.assertEquals((int)2, (int)((Integer)child.get("sum")));
    }

    public void testContextFunctionNullBecomeParent() {
        IEclipseContext child = EclipseContextFactory.create();
        child.set("sum", (Object)new AddContextFunction());
        ReparentingTest.assertEquals((int)0, (int)((Integer)child.get("sum")));
        IEclipseContext parent = EclipseContextFactory.create();
        parent.set("x", (Object)new Integer(3));
        parent.set("y", (Object)new Integer(3));
        child.set("parentContext", (Object)parent);
        ReparentingTest.assertEquals((int)6, (int)((Integer)child.get("sum")));
    }

    public void testContextFunctionParentBecomeNull() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext child = EclipseContextFactory.create((IEclipseContext)parent, null);
        parent.set("x", (Object)new Integer(3));
        parent.set("y", (Object)new Integer(3));
        child.set("sum", (Object)new AddContextFunction());
        ReparentingTest.assertEquals((int)6, (int)((Integer)child.get("sum")));
        child.set("parentContext", null);
        ReparentingTest.assertEquals((int)0, (int)((Integer)child.get("sum")));
    }

    public void testContextFunctionSwitchParent() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext child = EclipseContextFactory.create((IEclipseContext)parent, null);
        parent.set("x", (Object)new Integer(3));
        parent.set("y", (Object)new Integer(3));
        child.set("sum", (Object)new AddContextFunction());
        ReparentingTest.assertEquals((int)6, (int)((Integer)child.get("sum")));
        IEclipseContext newParent = EclipseContextFactory.create();
        newParent.set("x", (Object)new Integer(1));
        newParent.set("y", (Object)new Integer(1));
        child.set("parentContext", (Object)newParent);
        ReparentingTest.assertEquals((int)2, (int)((Integer)child.get("sum")));
    }

    public void testRunAndTrackNullBecomesParent() {
        final String[] value = new String[1];
        final IEclipseContext child = EclipseContextFactory.create();
        child.runAndTrack(new IRunAndTrack(){

            public boolean notify(ContextChangeEvent event) {
                value[0] = (String)child.get("x");
                return true;
            }
        }, null);
        ReparentingTest.assertEquals(null, (String)value[0]);
        IEclipseContext parent = EclipseContextFactory.create();
        parent.set("x", (Object)"newParent");
        child.set("parentContext", (Object)parent);
        ReparentingTest.assertEquals((String)"newParent", (String)value[0]);
    }

    public void testRunAndTrackParentBecomeNull() {
        final String[] value = new String[1];
        IEclipseContext parent = EclipseContextFactory.create();
        final IEclipseContext child = EclipseContextFactory.create((IEclipseContext)parent, null);
        parent.set("x", (Object)"oldParent");
        child.runAndTrack(new IRunAndTrack(){

            public boolean notify(ContextChangeEvent event) {
                value[0] = (String)child.get("x");
                return true;
            }
        }, null);
        ReparentingTest.assertEquals((String)"oldParent", (String)value[0]);
        child.set("parentContext", null);
        ReparentingTest.assertNull((Object)value[0]);
    }

    public void testRunAndTrackSwitchParent() {
        final String[] value = new String[1];
        IEclipseContext parent = EclipseContextFactory.create();
        final IEclipseContext child = EclipseContextFactory.create((IEclipseContext)parent, null);
        parent.set("x", (Object)"oldParent");
        child.runAndTrack(new IRunAndTrack(){

            public boolean notify(ContextChangeEvent event) {
                value[0] = (String)child.get("x");
                return true;
            }
        }, null);
        ReparentingTest.assertEquals((String)"oldParent", (String)value[0]);
        IEclipseContext newParent = EclipseContextFactory.create();
        newParent.set("x", (Object)"newParent");
        child.set("parentContext", (Object)newParent);
        ReparentingTest.assertEquals((String)"newParent", (String)value[0]);
    }

    public void testInjectSwitchParent() {
        IEclipseContext oldParent = EclipseContextFactory.create();
        oldParent.set("String", (Object)"oldField");
        oldParent.set(String.class.getName(), (Object)"old");
        oldParent.set(Float.class.getName(), (Object)new Float(12.3));
        IEclipseContext newParent = EclipseContextFactory.create();
        newParent.set("String", (Object)"newField");
        newParent.set(String.class.getName(), (Object)"new");
        newParent.set(Float.class.getName(), (Object)new Float(34.5));
        IEclipseContext child = EclipseContextFactory.create((IEclipseContext)oldParent, null);
        ObjectSuperClass object = new ObjectSuperClass();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)child);
        ReparentingTest.assertEquals((int)1, (int)object.setStringCalled);
        ReparentingTest.assertEquals((String)"old", (String)object.getStringViaMethod());
        child.set("parentContext", (Object)newParent);
        ReparentingTest.assertEquals((String)"new", (String)object.getStringViaMethod());
        ReparentingTest.assertEquals((int)2, (int)object.setStringCalled);
    }

    public void testInjectSwitchParentSameGrandparent() {
        IEclipseContext grandpa = EclipseContextFactory.create();
        grandpa.set("String", (Object)"field");
        grandpa.set(String.class.getName(), (Object)"s");
        grandpa.set(Float.class.getName(), (Object)new Float(12.3));
        IEclipseContext oldParent = EclipseContextFactory.create((IEclipseContext)grandpa, null);
        IEclipseContext newParent = EclipseContextFactory.create((IEclipseContext)grandpa, null);
        IEclipseContext child = EclipseContextFactory.create((IEclipseContext)oldParent, null);
        ObjectSuperClass object = new ObjectSuperClass();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)child);
        ReparentingTest.assertEquals((int)1, (int)object.setStringCalled);
        child.set("parentContext", (Object)newParent);
        ReparentingTest.assertEquals((int)1, (int)object.setStringCalled);
    }
}

