/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.tests.services.internal.annotations;

import javax.inject.Inject;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.core.internal.contexts.IEclipseContextStrategy;
import org.eclipse.e4.core.internal.contexts.ILookupStrategy;
import org.eclipse.e4.core.tests.services.internal.annotations.PrintService;
import org.eclipse.e4.core.tests.services.internal.annotations.StringPrintService;

public class Bug304585Test
extends TestCase {
    public void testFieldInjection() throws Exception {
        IEclipseContext parent = EclipseContextFactory.create();
        parent.set("debugString", (Object)"ParentContext");
        Strategy strategy = new Strategy();
        IEclipseContext child = EclipseContextFactory.create((IEclipseContext)parent, (IEclipseContextStrategy)strategy);
        child.set("debugString", (Object)"ChildContext");
        ContextInjectionFactory.make(InjectFieldTarget.class, (IEclipseContext)child);
        ((IDisposable)child).dispose();
        ((IDisposable)parent).dispose();
        Bug304585Test.assertFalse((String)"Strategy used after context disposed", (boolean)strategy.lookupAfterDisposed);
    }

    public void testMethodInjection() throws Exception {
        IEclipseContext parent = EclipseContextFactory.create();
        parent.set("debugString", (Object)"ParentContext");
        Strategy strategy = new Strategy();
        IEclipseContext child = EclipseContextFactory.create((IEclipseContext)parent, (IEclipseContextStrategy)strategy);
        child.set("debugString", (Object)"ChildContext");
        ContextInjectionFactory.make(InjectMethodTarget.class, (IEclipseContext)child);
        ((IDisposable)child).dispose();
        ((IDisposable)parent).dispose();
        Bug304585Test.assertFalse((String)"Strategy used after context disposed", (boolean)strategy.lookupAfterDisposed);
    }

    public static class InjectFieldTarget {
        @Inject
        PrintService printer;
    }

    public static class InjectMethodTarget {
        @Inject
        public void setPrinter(PrintService printer) {
        }
    }

    public static class Strategy
    implements IDisposable,
    ILookupStrategy {
        private boolean disposed = false;
        boolean lookupAfterDisposed = false;
        private PrintService printer = new StringPrintService();

        public void dispose() {
            this.disposed = true;
        }

        public Object lookup(String name, IEclipseContext context) {
            if (this.disposed) {
                this.lookupAfterDisposed = true;
            }
            if (name != null && name.equals(PrintService.SERVICE_NAME)) {
                return this.printer;
            }
            return null;
        }

        public boolean containsKey(String name, IEclipseContext context) {
            if (this.disposed) {
                this.lookupAfterDisposed = true;
            }
            return name != null && name.equals(PrintService.SERVICE_NAME);
        }
    }
}

