/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.tests.services.internal.annotations;

import javax.inject.Inject;
import javax.inject.Named;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.core.di.annotations.Optional;

public class DisposingReferencedContextTest
extends TestCase {
    public void testContextDisposeCausesCompleteUninjection_Mandatory_True() {
        this.testContextDisposeCausesCompleteUninjection_Mandatory(true);
    }

    public void testContextDisposeCausesCompleteUninjection_Mandatory_False() {
        this.testContextDisposeCausesCompleteUninjection_Mandatory(false);
    }

    public void testContextDisposeCausesCompleteUninjection_Optional_True() {
        this.testContextDisposeCausesCompleteUninjection_Optional(true);
    }

    public void testContextDisposeCausesCompleteUninjection_Optional_False() {
        this.testContextDisposeCausesCompleteUninjection_Optional(false);
    }

    private void testContextDisposeCausesCompleteUninjection_Mandatory(boolean disposeFirst) {
        IEclipseContext windowContext = EclipseContextFactory.create();
        windowContext.set("debugString", (Object)"windowContext");
        IEclipseContext partContext = EclipseContextFactory.create((IEclipseContext)windowContext, null);
        partContext.set("debugString", (Object)"partContext");
        windowContext.set("activeChildContext", (Object)partContext);
        Object o = new Object();
        windowContext.set("object", o);
        MandatoryTarget target = new MandatoryTarget();
        ContextInjectionFactory.inject((Object)target, (IEclipseContext)windowContext);
        DisposingReferencedContextTest.assertEquals((String)"The object should have been injected", (Object)o, (Object)target.object);
        if (disposeFirst) {
            ((IDisposable)partContext).dispose();
            windowContext.set("activeChildContext", null);
        } else {
            windowContext.set("activeChildContext", null);
            ((IDisposable)partContext).dispose();
        }
        DisposingReferencedContextTest.assertEquals((String)"The object should not have been uninjected", (Object)o, (Object)target.object);
    }

    private void testContextDisposeCausesCompleteUninjection_Optional(boolean disposeFirst) {
        IEclipseContext windowContext = EclipseContextFactory.create();
        IEclipseContext partContext = EclipseContextFactory.create((IEclipseContext)windowContext, null);
        windowContext.set("activeChildContext", (Object)partContext);
        Object o = new Object();
        windowContext.set("object", o);
        OptionalTarget target = new OptionalTarget();
        ContextInjectionFactory.inject((Object)target, (IEclipseContext)windowContext);
        DisposingReferencedContextTest.assertEquals((String)"The object should have been injected", (Object)o, (Object)target.object);
        if (disposeFirst) {
            ((IDisposable)partContext).dispose();
            windowContext.set("activeChildContext", null);
        } else {
            windowContext.set("activeChildContext", null);
            ((IDisposable)partContext).dispose();
        }
        DisposingReferencedContextTest.assertEquals((String)"The object should not have been uninjected", (Object)o, (Object)target.object);
    }

    static class MandatoryTarget {
        @Inject
        @Named(value="object")
        Object object;

        MandatoryTarget() {
        }

        @Inject
        void setActiveContext(@Named(value="activeChildContext") IEclipseContext partContext) {
            if (partContext != null) {
                partContext.get("someVar");
            }
        }
    }

    static class OptionalTarget {
        @Inject
        @Named(value="object")
        Object object;

        OptionalTarget() {
        }

        @Inject
        void setActiveContext(@Optional @Named(value="activeChildContext") IEclipseContext partContext) {
            if (partContext != null) {
                partContext.get("someVar");
            }
        }
    }
}

