/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.tests.services.internal.annotations;

import javax.inject.Inject;
import javax.inject.Named;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.GroupUpdates;

public class GroupedUpdatesTest
extends TestCase {
    public void testNoGrouping() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("string1", (Object)"x");
        context.set("string2", (Object)"y");
        InjectTargetImmediate target = new InjectTargetImmediate();
        ContextInjectionFactory.inject((Object)target, (IEclipseContext)context);
        GroupedUpdatesTest.assertEquals((int)1, (int)target.countMain);
        target.resetCounters();
        context.set("string1", (Object)"a");
        context.set("string2", (Object)"b");
        GroupedUpdatesTest.assertEquals((int)2, (int)target.countMain);
        GroupedUpdatesTest.assertEquals((int)1, (int)target.countSecondary);
        context.processWaiting();
        GroupedUpdatesTest.assertEquals((int)2, (int)target.countMain);
        GroupedUpdatesTest.assertEquals((int)1, (int)target.countSecondary);
    }

    public void testGrouping() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("string1", (Object)"x");
        context.set("string2", (Object)"y");
        InjectTargetWait target = new InjectTargetWait();
        ContextInjectionFactory.inject((Object)target, (IEclipseContext)context);
        GroupedUpdatesTest.assertEquals((int)1, (int)target.countMain);
        target.resetCounters();
        context.set("string1", (Object)"a");
        context.set("string2", (Object)"b");
        GroupedUpdatesTest.assertEquals((int)0, (int)target.countMain);
        GroupedUpdatesTest.assertEquals((int)0, (int)target.countSecondary);
        context.processWaiting();
        GroupedUpdatesTest.assertEquals((int)1, (int)target.countMain);
        GroupedUpdatesTest.assertEquals((int)1, (int)target.countSecondary);
        context.processWaiting();
        GroupedUpdatesTest.assertEquals((int)1, (int)target.countMain);
        GroupedUpdatesTest.assertEquals((int)1, (int)target.countSecondary);
        target.resetCounters();
        context.set("string1", (Object)"x");
        context.set("string2", (Object)"y");
        context.set("string2", (Object)"z");
        context.set("string1", (Object)"delta");
        GroupedUpdatesTest.assertEquals((int)0, (int)target.countMain);
        GroupedUpdatesTest.assertEquals((int)0, (int)target.countSecondary);
        context.processWaiting();
        GroupedUpdatesTest.assertEquals((int)1, (int)target.countMain);
        GroupedUpdatesTest.assertEquals((int)1, (int)target.countSecondary);
        GroupedUpdatesTest.assertEquals((String)target.s1, (String)"delta");
        GroupedUpdatesTest.assertEquals((String)target.s2, (String)"z");
    }

    static class InjectTarget {
        public int countMain = 0;
        public int countSecondary = 0;
        public String s1;
        public String s2;

        InjectTarget() {
        }

        public void resetCounters() {
            this.countMain = 0;
            this.countSecondary = 0;
        }
    }

    static class InjectTargetImmediate
    extends InjectTarget {
        InjectTargetImmediate() {
        }

        @Inject
        void setInfo(@Named(value="string1") String s, @Named(value="string2") String s2) {
            ++this.countMain;
            this.s1 = s;
            this.s2 = s2;
        }

        @Inject
        void setInfoSecondary(@Named(value="string2") String s2) {
            ++this.countSecondary;
            this.s2 = s2;
        }
    }

    static class InjectTargetWait
    extends InjectTarget {
        InjectTargetWait() {
        }

        @Inject
        @GroupUpdates
        void setInfo(@Named(value="string1") String s, @Named(value="string2") String s2) {
            ++this.countMain;
            this.s1 = s;
            this.s2 = s2;
        }

        @Inject
        @GroupUpdates
        void setInfoSecondary(@Named(value="string2") String s2) {
            ++this.countSecondary;
            this.s2 = s2;
        }
    }
}

