/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.tests.services.internal.annotations;

import javax.inject.Inject;
import javax.inject.Named;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.core.di.annotations.PreDestroy;

public class InjectionOrderTest
extends TestCase {
    public void testDisposeMethod() throws Exception {
        IEclipseContext appContext = EclipseContextFactory.create();
        appContext.set("inject", (Object)"a");
        InjectTargetMethod injectTargetMethod = (InjectTargetMethod)ContextInjectionFactory.make(InjectTargetMethod.class, (IEclipseContext)appContext);
        appContext.set("inject", (Object)"b");
        ((IDisposable)appContext).dispose();
        InjectionOrderTest.assertTrue((String)"@PreDestroy was incorrectly called after the method was uninjected", (boolean)injectTargetMethod.nonNull);
    }

    public void testDisposeField() throws Exception {
        IEclipseContext appContext = EclipseContextFactory.create();
        appContext.set("inject", (Object)"a");
        InjectTargetField injectTargetField = (InjectTargetField)ContextInjectionFactory.make(InjectTargetField.class, (IEclipseContext)appContext);
        appContext.set("inject", (Object)"b");
        ((IDisposable)appContext).dispose();
        InjectionOrderTest.assertTrue((String)"@PreDestroy was incorrectly called after the field was uninjected", (boolean)injectTargetField.nonNull);
    }

    public static class InjectTargetField {
        boolean nonNull = false;
        @Inject
        @Named(value="inject")
        Object o;

        @PreDestroy
        void pd() {
            this.nonNull = this.o != null;
        }
    }

    public static class InjectTargetMethod {
        boolean nonNull = false;
        Object o;

        @Inject
        void set(@Named(value="inject") Object o) {
            this.o = o;
        }

        @PreDestroy
        void pd() {
            this.nonNull = this.o != null;
        }
    }
}

