/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.databinding;

import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.xwt.databinding.BindingMode;
import org.eclipse.e4.xwt.internal.core.ScopeKeeper;
import org.eclipse.e4.xwt.internal.core.UpdateSourceTrigger;
import org.eclipse.e4.xwt.internal.utils.UserData;
import org.eclipse.e4.xwt.tools.ui.designer.commands.AddNewChildCommand;
import org.eclipse.e4.xwt.tools.ui.designer.commands.DeleteCommand;
import org.eclipse.e4.xwt.tools.ui.designer.commands.NamedCommand;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.BindingConstants;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.BindingContext;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.CodeStyles;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.DataContext;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.IBindingHandler;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.IBindingInfo;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.IObservable;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.Property;
import org.eclipse.e4.xwt.tools.ui.designer.loader.XWTProxy;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlDocument;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.widgets.Widget;

public class BindingInfo
implements IBindingInfo,
IBindingHandler,
BindingConstants {
    private BindingContext context;
    private String elementName;
    private BindingMode bindingMode;
    private UpdateSourceTrigger triggerMode;
    private String converter;
    private CodeStyles codeStyles;
    private XamlElement bindingNode;

    public BindingInfo(BindingContext bindingContext) {
        Assert.isNotNull((Object)bindingContext);
        this.context = bindingContext;
    }

    public BindingContext getBindingContext() {
        return this.context;
    }

    public void setBindingNode(XamlElement bindingNode) {
        this.bindingNode = bindingNode;
    }

    public XamlElement getBindingNode() {
        return this.bindingNode;
    }

    public void setConverter(String converter) {
        this.converter = converter;
        if (this.bindingNode != null) {
            this.addAttr((XamlNode)this.bindingNode, "Converter", "http://www.eclipse.org/xwt/presentation", converter);
        }
    }

    public String getConverter() {
        return this.converter;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
        if (this.bindingNode != null) {
            this.addAttr((XamlNode)this.bindingNode, "ElementName", "http://www.eclipse.org/xwt/presentation", elementName);
        }
    }

    public String getElementName() {
        IObservable model = this.context.getModel();
        if (this.elementName == null && model != null && model.getType() == 1) {
            Object source = model.getSource();
            this.elementName = this.getWidgetName(source);
        }
        return this.elementName;
    }

    private String getWidgetName(Object widget) {
        ScopeKeeper nameContext = UserData.findScopeKeeper((Object)widget);
        if (nameContext != null) {
            for (String name : nameContext.names()) {
                if (widget != nameContext.getNamedObject(name)) continue;
                return name;
            }
        }
        return null;
    }

    public void setBindingMode(BindingMode bindingMode) {
        this.bindingMode = bindingMode;
        if (this.bindingNode != null) {
            this.addAttr((XamlNode)this.bindingNode, "BindingMode", "http://www.eclipse.org/xwt/presentation", bindingMode.name());
        }
    }

    public BindingMode getBindingMode() {
        return this.bindingMode;
    }

    public void setCodeStyles(CodeStyles codeStyles) {
        if (codeStyles != null) {
            this.codeStyles = codeStyles;
        }
    }

    public CodeStyles getCodeStyles() {
        if (this.codeStyles == null) {
            this.codeStyles = new CodeStyles();
        }
        return this.codeStyles;
    }

    private XamlAttribute getAttribute(XamlNode parent, String attrName, String namespace) {
        XamlAttribute attribute = parent.getAttribute(attrName, namespace);
        if (attribute == null) {
            attribute = XamlFactory.eINSTANCE.createAttribute(attrName, namespace);
        }
        return attribute;
    }

    private XamlElement getElement(XamlNode parent, String name, String namespace) {
        XamlElement child = parent.getChild(name, namespace);
        if (child == null) {
            child = XamlFactory.eINSTANCE.createElement(name, namespace);
        }
        return child;
    }

    private XamlAttribute addAttr(XamlNode parent, String attrName, String namespace, String value) {
        if (parent == null || attrName == null || namespace == null) {
            return null;
        }
        XamlAttribute attribute = parent.getAttribute(attrName, namespace);
        if (attribute == null) {
            attribute = XamlFactory.eINSTANCE.createAttribute(attrName, namespace);
        }
        attribute.setValue(value);
        if (!parent.getAttributes().contains((Object)attribute)) {
            parent.getAttributes().add((Object)attribute);
        }
        return attribute;
    }

    private String getCreateName(Object model, CompoundCommand commands) {
        if (!(model instanceof Widget)) {
            return null;
        }
        Widget widget = (Widget)model;
        String original = this.getWidgetName(widget);
        if (original != null) {
            return original;
        }
        String elementName = this.getElementName();
        if (elementName == null) {
            elementName = NamedCommand.generateName(widget);
        }
        commands.add((Command)new NamedCommand(widget, elementName));
        UserData.setObjectName((Object)widget, (String)elementName);
        return elementName;
    }

    public boolean canBinding() {
        return this.context.isValid();
    }

    public Command bindWithCommand() {
        int type;
        if (!this.canBinding()) {
            return null;
        }
        CompoundCommand commandList = new CompoundCommand();
        Property targetProperty = this.context.getTargetProperty();
        Property modelProperty = this.context.getModelProperty();
        IObservable target = this.context.getTarget();
        IObservable model = this.context.getModel();
        Object targetSource = target.getSource();
        Object modelSource = model.getSource();
        XamlNode node = null;
        if (targetSource instanceof Widget) {
            node = XWTProxy.getModel((Widget)targetSource);
        } else if (targetSource instanceof XamlElement) {
            node = (XamlElement)targetSource;
        }
        XamlAttribute attribute = node.getAttribute(targetProperty.getName(), "http://www.eclipse.org/xwt/presentation");
        if (attribute != null) {
            commandList.add((Command)new DeleteCommand((XamlNode)attribute));
            attribute = null;
        }
        if (attribute == null) {
            attribute = XamlFactory.eINSTANCE.createAttribute(targetProperty.getName(), "http://www.eclipse.org/xwt/presentation");
        }
        if (this.bindingNode == null) {
            this.bindingNode = attribute.getChild("Binding", "http://www.eclipse.org/xwt/presentation");
        }
        if (this.bindingNode == null) {
            this.bindingNode = XamlFactory.eINSTANCE.createElement("Binding", "http://www.eclipse.org/xwt/presentation");
        }
        if ((type = model.getType()) == 1) {
            this.addAttr((XamlNode)this.bindingNode, "ElementName", "http://www.eclipse.org/xwt/presentation", this.getCreateName(modelSource, commandList));
        } else if (3 == type) {
            XamlDocument ownerDocument = node.getOwnerDocument();
            XamlElement rootElement = ownerDocument.getRootElement();
            DataContext dataContext = (DataContext)modelSource;
            String key = dataContext.getKey();
            if (key != null) {
                XamlElement resourceNode;
                boolean canUseDC = this.getCodeStyles().useDataContext;
                if (canUseDC) {
                    XamlAttribute contextNode = this.getAttribute((XamlNode)rootElement, "DataContext", "http://www.eclipse.org/xwt/presentation");
                    contextNode.setUseFlatValue(true);
                    resourceNode = this.getElement((XamlNode)contextNode, "StaticResource", "http://www.eclipse.org/xwt/presentation");
                    if (!key.equals(resourceNode.getValue())) {
                        if (resourceNode.getValue() != null) {
                            canUseDC = false;
                        } else {
                            resourceNode.setValue(key);
                            commandList.add((Command)new AddNewChildCommand((XamlNode)contextNode, (XamlNode)resourceNode));
                            commandList.add((Command)new AddNewChildCommand((XamlNode)rootElement, (XamlNode)contextNode));
                        }
                    }
                }
                if (!canUseDC || !this.getCodeStyles().useDataContext) {
                    XamlAttribute sourceAttr = this.getAttribute((XamlNode)this.bindingNode, "Source", "http://www.eclipse.org/xwt/presentation");
                    sourceAttr.setUseFlatValue(true);
                    resourceNode = this.getElement((XamlNode)sourceAttr, "StaticResource", "http://www.eclipse.org/xwt/presentation");
                    resourceNode.setValue(key);
                    commandList.add((Command)new AddNewChildCommand((XamlNode)sourceAttr, (XamlNode)resourceNode));
                    commandList.add((Command)new AddNewChildCommand((XamlNode)this.bindingNode, (XamlNode)sourceAttr));
                }
            }
        }
        this.addAttr((XamlNode)this.bindingNode, "Path", "http://www.eclipse.org/xwt/presentation", modelProperty.toString());
        if (this.bindingMode != null && BindingMode.TwoWay.equals((Object)this.bindingMode)) {
            this.addAttr((XamlNode)this.bindingNode, "BindingMode", "http://www.eclipse.org/xwt/presentation", this.bindingMode.name());
        }
        if (this.converter != null) {
            this.addAttr((XamlNode)this.bindingNode, "Converter", "http://www.eclipse.org/xwt/presentation", this.converter);
        }
        if (this.triggerMode != null) {
            this.addAttr((XamlNode)this.bindingNode, "UpdateSourceTrigger", "http://www.eclipse.org/xwt/presentation", this.triggerMode.name());
        }
        attribute.setUseFlatValue(this.getCodeStyles().useFlatVlaue);
        if (!attribute.getChildNodes().contains((Object)this.bindingNode)) {
            attribute.getChildNodes().add((Object)this.bindingNode);
        }
        if (!node.getAttributes().contains((Object)attribute)) {
            commandList.add((Command)new AddNewChildCommand(node, (XamlNode)attribute));
        }
        return commandList.unwrap();
    }

    public boolean canDelete() {
        return this.bindingNode != null && this.bindingNode.eContainer() != null;
    }

    public Command deleteWithCommand() {
        if (this.canDelete()) {
            XamlAttribute bindAttr = (XamlAttribute)this.bindingNode.eContainer();
            return new DeleteCommand((XamlNode)bindAttr);
        }
        return null;
    }

    public IObservable getModel() {
        return this.context.getModel();
    }

    public Property getModelProperty() {
        return this.context.getModelProperty();
    }

    public IObservable getTarget() {
        return this.context.getTarget();
    }

    public Property getTargetProperty() {
        return this.context.getTargetProperty();
    }

    public UpdateSourceTrigger getTriggerMode() {
        return this.triggerMode;
    }

    public void setTriggerMode(UpdateSourceTrigger triggerMode) {
        this.triggerMode = triggerMode;
    }
}

