/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.Assert;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFolder;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStoreTransient;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.resources.semantic.test.TestsContentProviderUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.RepositoryProvider;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestsDefaultContentProvider
extends TestsContentProviderUtil {
    private static final String UTF_8_CHARSET = "utf-8";
    private static final String TEST = "test";
    private static final String TEST2 = "test2";

    public TestsDefaultContentProvider() {
        this(true);
    }

    TestsDefaultContentProvider(boolean withAutoRefresh) {
        super(withAutoRefresh, "TestDefaultContentProvider", null);
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        TestsContentProviderUtil.initTrace();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TestsContentProviderUtil.resetTrace();
    }

    @Before
    public void beforeMethod() throws Exception {
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(this.projectName);
        if (project.exists()) {
            throw new IllegalStateException("Project exists");
        }
        IWorkspaceRunnable myRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProjectDescription description = workspace.newProjectDescription(TestsDefaultContentProvider.this.projectName);
                try {
                    description.setLocationURI(new URI("semanticfs:/" + TestsDefaultContentProvider.this.projectName));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                project.create(description, monitor);
                project.open(monitor);
                RemoteStoreTransient store = (RemoteStoreTransient)project.getAdapter(RemoteStoreTransient.class);
                RemoteFolder f1 = store.getRootFolder().addFolder("Folder1");
                f1.addFolder("Folder11");
                RepositoryProvider.map((IProject)project, (String)"org.eclipse.core.internal.resources.semantic.DelegatingRepositoryProvider");
                if (!TestsDefaultContentProvider.this.autoRefresh) {
                    project.refreshLocal(2, monitor);
                }
            }
        };
        workspace.run(myRunnable, (ISchedulingRule)workspace.getRoot(), 1, null);
        this.testProject = project;
    }

    @After
    public void afterMethod() throws Exception {
        RemoteStoreTransient store = (RemoteStoreTransient)this.testProject.getAdapter(RemoteStoreTransient.class);
        store.reset();
        this.testProject = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(this.projectName);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.delete(true, monitor);
                if (!TestsDefaultContentProvider.this.autoRefresh) {
                    project.refreshLocal(2, monitor);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testAddFileAndDelete() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ByteArrayInputStream is;
                IFile file = TestsDefaultContentProvider.this.testProject.getFile("SomeFile");
                Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
                try {
                    is = new ByteArrayInputStream("Hello World".getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                file.create((InputStream)is, false, monitor);
                Util.safeClose((InputStream)file.getContents());
                Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
                InputStream stream = null;
                try {
                    try {
                        stream = file.getContents();
                        byte[] result = new byte[stream.available()];
                        stream.read(result);
                        String content = new String(result, "UTF-8");
                        Assert.assertEquals((String)"Hello World", (String)content);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    Util.safeClose((InputStream)stream);
                }
                file.delete(false, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)this.testProject, 1, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testAddFileAndCopy() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ByteArrayInputStream is;
                IFile file = TestsDefaultContentProvider.this.testProject.getFile("SomeFile");
                Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
                try {
                    is = new ByteArrayInputStream("Hello World".getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                file.create((InputStream)is, false, monitor);
                Util.safeClose((InputStream)file.getContents());
                Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
                file.copy(TestsDefaultContentProvider.this.testProject.getFullPath().append("CopyTarget"), false, monitor);
                InputStream stream = null;
                try {
                    try {
                        stream = file.getContents();
                        byte[] result = new byte[stream.available()];
                        stream.read(result);
                        String content = new String(result, "UTF-8");
                        Assert.assertEquals((String)"Hello World", (String)content);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    Util.safeClose((InputStream)stream);
                }
                file.delete(false, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)this.testProject, 1, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testAddFileAndChangeCharset() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ByteArrayInputStream is;
                IFile file = TestsDefaultContentProvider.this.testProject.getFile("SomeFile");
                Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
                try {
                    is = new ByteArrayInputStream("Hello World".getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                file.create((InputStream)is, false, monitor);
                Util.safeClose((InputStream)file.getContents());
                Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
                file.setCharset("UTF-8", monitor);
                Assert.assertEquals((String)"Wrong charset", (String)file.getCharset(), (String)"UTF-8");
                file.setCharset("UTF-16", monitor);
                Assert.assertEquals((String)"Wrong charset", (String)file.getCharset(), (String)"UTF-16");
                InputStream stream = null;
                try {
                    try {
                        stream = file.getContents();
                        byte[] result = new byte[stream.available()];
                        stream.read(result);
                        String content = new String(result, "UTF-8");
                        Assert.assertEquals((String)"Hello World", (String)content);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    Util.safeClose((InputStream)stream);
                }
                file.delete(false, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)this.testProject, 1, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testAddFileAndMove() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ByteArrayInputStream is;
                IFile file = TestsDefaultContentProvider.this.testProject.getFile("SomeFile");
                IFolder targetFolder = TestsDefaultContentProvider.this.testProject.getFolder("target");
                targetFolder.create(false, false, monitor);
                Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
                try {
                    is = new ByteArrayInputStream("Hello World".getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                file.create((InputStream)is, false, monitor);
                Util.safeClose((InputStream)file.getContents());
                Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
                InputStream stream = null;
                try {
                    try {
                        stream = file.getContents();
                        byte[] result = new byte[stream.available()];
                        stream.read(result);
                        String content = new String(result, "UTF-8");
                        Assert.assertEquals((String)"Hello World", (String)content);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    Util.safeClose((InputStream)stream);
                }
                file.move(targetFolder.getFile(file.getName()).getFullPath(), false, monitor);
                file.delete(false, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)this.testProject, 1, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testAddFileAndDeleteFolder() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ByteArrayInputStream is;
                IFile file = TestsDefaultContentProvider.this.testProject.getFile("someFolder/SomeFile");
                Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
                try {
                    is = new ByteArrayInputStream("Hello World".getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                IFolder folder = (IFolder)file.getParent();
                folder.create(false, false, monitor);
                file.create((InputStream)is, false, monitor);
                Util.safeClose((InputStream)file.getContents());
                Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
                InputStream stream = null;
                try {
                    try {
                        stream = file.getContents();
                        byte[] result = new byte[stream.available()];
                        stream.read(result);
                        String content = new String(result, "UTF-8");
                        Assert.assertEquals((String)"Hello World", (String)content);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    Util.safeClose((InputStream)stream);
                }
                file.getParent().delete(false, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)this.testProject, 1, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    @Ignore
    public void testAddFileAndMoveFolder() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ByteArrayInputStream is;
                IFile file = TestsDefaultContentProvider.this.testProject.getFile("someFolder/SomeFile");
                IFolder targetFolder = TestsDefaultContentProvider.this.testProject.getFolder("newTarget");
                targetFolder.create(false, false, monitor);
                Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
                try {
                    is = new ByteArrayInputStream("Hello World".getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                IFolder folder = (IFolder)file.getParent();
                folder.create(false, false, monitor);
                file.create((InputStream)is, false, monitor);
                Util.safeClose((InputStream)file.getContents());
                Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
                InputStream stream = null;
                try {
                    try {
                        stream = file.getContents();
                        byte[] result = new byte[stream.available()];
                        stream.read(result);
                        String content = new String(result, "UTF-8");
                        Assert.assertEquals((String)"Hello World", (String)content);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    Util.safeClose((InputStream)stream);
                }
                if (!TestsDefaultContentProvider.this.autoRefresh) {
                    TestsDefaultContentProvider.this.testProject.refreshLocal(2, monitor);
                }
                IFolder parent = (IFolder)file.getParent();
                parent.move(targetFolder.getFolder(parent.getName()).getFullPath(), false, monitor);
                targetFolder.delete(false, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)this.testProject, 1, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testFailRemoteMethods() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ByteArrayInputStream is;
                IFile file = TestsDefaultContentProvider.this.testProject.getFile("SomeOtherFile");
                Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
                try {
                    is = new ByteArrayInputStream("Hello World".getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                file.create((InputStream)is, false, null);
                Util.safeClose((InputStream)file.getContents());
                Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
                ISemanticFolder sf = (ISemanticFolder)TestsDefaultContentProvider.this.testProject.getFolder("testFolder").getAdapter(ISemanticFolder.class);
                try {
                    sf.addFile("testFile", TestsDefaultContentProvider.this.options, monitor);
                    Assert.fail((String)"Should have failed");
                }
                catch (CoreException coreException) {}
                try {
                    sf.addFolder("testFolder", TestsDefaultContentProvider.this.options, monitor);
                    Assert.fail((String)"Should have failed");
                }
                catch (CoreException coreException) {}
                try {
                    sf.addResource("testResource", TestsDefaultContentProvider.this.options, monitor);
                    Assert.fail((String)"Should have failed");
                }
                catch (CoreException coreException) {}
                try {
                    sf.createFileRemotely("newRemoteFile", (InputStream)new ByteArrayInputStream(new byte[0]), null, TestsDefaultContentProvider.this.options, monitor);
                    Assert.fail((String)"Should have failed");
                }
                catch (CoreException coreException) {}
                try {
                    sf.createResourceRemotely("newRemoteResource", null, TestsDefaultContentProvider.this.options, monitor);
                    Assert.fail((String)"Should have failed");
                }
                catch (CoreException coreException) {}
                ISemanticFile sFile = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                try {
                    sFile.deleteRemotely(TestsDefaultContentProvider.this.options, monitor);
                    Assert.fail((String)"Should have failed");
                }
                catch (CoreException coreException) {}
                try {
                    sFile.revertChanges(TestsDefaultContentProvider.this.options, monitor);
                    Assert.fail((String)"Should have failed");
                }
                catch (CoreException coreException) {}
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testMoveProject() throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    TestsDefaultContentProvider.this.testProject.move((IPath)new Path("SomeTarget"), false, monitor);
                    Assert.fail((String)"Should have failed");
                }
                catch (OperationCanceledException operationCanceledException) {}
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testTemplateMapping() throws Exception {
        final IFolder pcpfolder = this.testProject.getFolder("PlainTestContentProvider");
        pcpfolder.create(false, true, null);
        final IFolder dcpfolder = this.testProject.getFolder("SomeFolder");
        dcpfolder.create(false, true, null);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    pcpfolder.getFile("TestChild").create((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), false, monitor);
                    Assert.fail((String)"Should have failed");
                }
                catch (Exception exception) {}
                try {
                    dcpfolder.getFile("TestChild").create((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), false, monitor);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testFileStoreBehaviorAfterRemove() throws Exception {
        IFile file = this.testProject.getFile("someFolder/SomeFile");
        ISemanticFileStore store = (ISemanticFileStore)EFS.getStore((URI)file.getLocationURI());
        ISemanticFileStore store2 = (ISemanticFileStore)EFS.getStore((URI)file.getLocationURI());
        IPath beforePath = store.getPath();
        store.remove(null);
        IPath afterPath = store.getPath();
        IPath afterPath2 = store2.getPath();
        Assert.assertEquals((String)"Path should be the same after removal of semantic file store", (Object)beforePath, (Object)afterPath);
        Assert.assertEquals((String)"Path should be the same after removal of semantic file store", (Object)beforePath, (Object)afterPath2);
        try {
            store.getPersistentProperties();
            Assert.assertTrue((String)"GetPersistentProperties should have failed.", (boolean)false);
        }
        catch (CoreException coreException) {}
    }

    @Test
    public void testAddFileWithURL() throws Exception {
        final IFolder folder = this.testProject.getFolder("someFolder");
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sFolder = (ISemanticFolder)folder.getAdapter(ISemanticFolder.class);
                try {
                    File testfile = TestsDefaultContentProvider.this.createTestFile("test.txt");
                    boolean created = testfile.createNewFile();
                    if (!created) {
                        new FileOutputStream(testfile).close();
                    }
                    ISemanticFile sfile = sFolder.addFile("SomeFile", TestsDefaultContentProvider.this.createURI4File(testfile), TestsDefaultContentProvider.this.options, monitor);
                    if (TestsDefaultContentProvider.this.options == 2) {
                        TestsDefaultContentProvider.this.testProject.refreshLocal(2, monitor);
                    }
                    Util.safeClose((InputStream)sfile.getAdaptedFile().getContents());
                    Assert.assertTrue((String)("Resource should exist " + sfile.getAdaptedResource().getLocationURI()), (boolean)sfile.getAdaptedResource().exists());
                }
                catch (URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testAddFileWithWrongURL() throws Exception {
        final IFolder folder = this.testProject.getFolder("someFolder");
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sFolder = (ISemanticFolder)folder.getAdapter(ISemanticFolder.class);
                if (sFolder.getAdaptedContainer().getFile((IPath)new Path("SomeFile")).exists()) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", "resource already exists"));
                }
                try {
                    sFolder.addFile("SomeFile", new URI("x:y"), TestsDefaultContentProvider.this.options, monitor);
                    Assert.assertTrue((String)"addFile() should have failed", (boolean)false);
                }
                catch (CoreException e) {
                    e.getMessage();
                }
                catch (URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testAddFileWithNonExistingURL() throws Exception {
        final IFolder folder = this.testProject.getFolder("someFolder");
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sFolder = (ISemanticFolder)folder.getAdapter(ISemanticFolder.class);
                if (sFolder.getAdaptedContainer().getFile((IPath)new Path("SomeFile")).exists()) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", "resource already exists"));
                }
                try {
                    File testfile = TestsDefaultContentProvider.this.createTestFile("test.txt");
                    if (!testfile.delete()) {
                        throw new IOException("Cann't delete file " + testfile);
                    }
                    sFolder.addFile("SomeFile", TestsDefaultContentProvider.this.createURI4File(testfile), TestsDefaultContentProvider.this.options, monitor);
                    Assert.assertTrue((String)"addFile() should have failed", (boolean)false);
                }
                catch (CoreException e) {
                    e.getMessage();
                }
                catch (URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testSynchronize() throws Exception {
        final IFolder folder = this.testProject.getFolder("someFolder");
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sFolder = (ISemanticFolder)folder.getAdapter(ISemanticFolder.class);
                try {
                    File testfile = TestsDefaultContentProvider.this.createTestFile("test.txt");
                    TestsDefaultContentProvider.this.writeContentsToFile(testfile, TestsDefaultContentProvider.TEST, TestsDefaultContentProvider.UTF_8_CHARSET);
                    ISemanticFile sfile = sFolder.addFile("SomeFile", TestsDefaultContentProvider.this.createURI4File(testfile), TestsDefaultContentProvider.this.options, monitor);
                    if (TestsDefaultContentProvider.this.options == 2) {
                        TestsDefaultContentProvider.this.testProject.refreshLocal(2, monitor);
                    }
                    TestsDefaultContentProvider.this.assertContentsEqual(sfile.getAdaptedFile(), TestsDefaultContentProvider.TEST);
                    Assert.assertTrue((String)("Resource should exist " + sfile.getAdaptedResource().getLocationURI()), (boolean)sfile.getAdaptedResource().exists());
                    TestsDefaultContentProvider.this.writeContentsToFile(testfile, TestsDefaultContentProvider.TEST2, TestsDefaultContentProvider.UTF_8_CHARSET);
                    sfile.synchronizeContentWithRemote(SyncDirection.INCOMING, TestsDefaultContentProvider.this.options, monitor);
                    TestsDefaultContentProvider.this.assertContentsEqual(sfile.getAdaptedFile(), TestsDefaultContentProvider.TEST2);
                    if (!testfile.delete()) {
                        throw new IOException("Cann't delete file " + testfile);
                    }
                    try {
                        sfile.synchronizeContentWithRemote(SyncDirection.INCOMING, TestsDefaultContentProvider.this.options, monitor);
                    }
                    catch (CoreException e) {
                        e.getMessage();
                    }
                    try {
                        Util.safeClose((InputStream)sfile.getAdaptedFile().getContents());
                    }
                    catch (CoreException e) {
                        e.getMessage();
                    }
                    TestsDefaultContentProvider.this.writeContentsToFile(testfile, TestsDefaultContentProvider.TEST, TestsDefaultContentProvider.UTF_8_CHARSET);
                    sfile.synchronizeContentWithRemote(SyncDirection.INCOMING, TestsDefaultContentProvider.this.options, monitor);
                    TestsDefaultContentProvider.this.assertContentsEqual(sfile.getAdaptedFile(), TestsDefaultContentProvider.TEST);
                }
                catch (URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }
}

