/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFile;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFolder;
import org.eclipse.core.resources.semantic.examples.remote.RemoteItem;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStoreTransient;
import org.eclipse.core.resources.semantic.spi.CachingContentProvider;
import org.eclipse.core.resources.semantic.spi.ICacheService;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderLocking;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderRemote;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.ISemanticSpiResourceInfo;
import org.eclipse.core.resources.semantic.spi.SemanticSpiResourceInfo;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public abstract class CachingTestContentProviderBase
extends CachingContentProvider
implements ISemanticContentProviderRemote,
ISemanticContentProviderLocking {
    public static final QualifiedName WRITE_THROUGH = new QualifiedName("org.eclipse.core.resources.semantic.test", "WriteThrough");
    private static final QualifiedName LOCKHANDLE = new QualifiedName("org.eclipse.core.resources.semantic.test", "LockHandle");
    private static final QualifiedName READONLY = new QualifiedName("org.eclipse.core.resources.semantic.test", "ReadOnly");

    public void onCacheUpdate(ISemanticFileStore semanticFileStore, InputStream newContent, long cacheTimestamp, boolean append, IProgressMonitor monitor) {
        boolean writeThrough;
        try {
            writeThrough = semanticFileStore.getSessionProperty(WRITE_THROUGH) != null;
        }
        catch (CoreException coreException) {
            writeThrough = false;
        }
        if (writeThrough) {
            RemoteItem parentItem = this.getStore().getItemByPath(semanticFileStore.getPath().removeFirstSegments(2));
            if (parentItem.getType() == RemoteItem.Type.FILE) {
                ByteArrayOutputStream os = ((RemoteFile)parentItem).getOutputStream(append);
                try {
                    Util.transferStreams((InputStream)newContent, (OutputStream)os, (IProgressMonitor)monitor);
                }
                catch (CoreException coreException) {}
            }
        } else {
            super.onCacheUpdate(semanticFileStore, newContent, cacheTimestamp, append, monitor);
        }
    }

    public void addResource(ISemanticFileStore parentStore, String name, ISemanticFileStore.ResourceType resourceType, IProgressMonitor monitor) throws CoreException {
        switch (resourceType) {
            case FILE_TYPE: {
                this.addFileFromRemote(parentStore, name, monitor);
                break;
            }
            case FOLDER_TYPE: {
                this.addFolderFromRemote(parentStore, name, monitor);
                break;
            }
            case UNKNOWN_TYPE: {
                this.addResourceFromRemote(parentStore, name, monitor);
                break;
            }
            default: {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic", "Can not create resource of type " + resourceType.name()));
            }
        }
    }

    protected void addFileFromRemote(ISemanticFileStore childStore, String name, IProgressMonitor monitor) throws CoreException {
        RemoteItem parentItem = this.getStore().getItemByPath(childStore.getPath().removeFirstSegments(2));
        if (parentItem.getType() != RemoteItem.Type.FOLDER) {
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, parentItem.getPath(), "");
        }
        RemoteItem item = ((RemoteFolder)parentItem).getChild(name);
        if (item == null) {
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_RESOURCE_NOT_FOUND, childStore.getPath(), "No such resource");
        }
        if (item.getType() != RemoteItem.Type.FILE) {
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, item.getPath(), "");
        }
        childStore.addChildFile(name);
        ISemanticFileStore newChild = (ISemanticFileStore)childStore.getChild(name);
        this.setReadOnly(newChild, true, monitor);
    }

    protected void addFolderFromRemote(ISemanticFileStore childStore, String name, IProgressMonitor monitor) throws CoreException {
        RemoteItem parentItem = this.getStore().getItemByPath(childStore.getPath().removeFirstSegments(2));
        if (parentItem.getType() != RemoteItem.Type.FOLDER) {
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, parentItem.getPath(), "");
        }
        RemoteItem item = ((RemoteFolder)parentItem).getChild(name);
        if (item == null) {
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_RESOURCE_NOT_FOUND, childStore.getPath(), "No such resource");
        }
        if (item.getType() != RemoteItem.Type.FOLDER) {
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, item.getPath(), "");
        }
        childStore.addChildFolder(name);
        ISemanticFileStore newChild = (ISemanticFileStore)childStore.getChild(name);
        this.setReadOnly(newChild, true, monitor);
    }

    protected void addResourceFromRemote(ISemanticFileStore childStore, String name, IProgressMonitor monitor) throws CoreException {
        RemoteItem parentItem = this.getStore().getItemByPath(childStore.getPath().removeFirstSegments(2));
        if (parentItem.getType() != RemoteItem.Type.FOLDER) {
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, parentItem.getPath(), "");
        }
        RemoteItem item = ((RemoteFolder)parentItem).getChild(name);
        if (item == null) {
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_RESOURCE_NOT_FOUND, childStore.getPath(), "No such resource");
        }
        if (item.getType() == RemoteItem.Type.FILE) {
            this.addFileFromRemote(childStore, name, monitor);
        } else if (item.getType() == RemoteItem.Type.FOLDER) {
            this.addFolderFromRemote(childStore, name, monitor);
        } else {
            Status result = new Status(4, "org.eclipse.core.resources.semantic.test", "Unknown resource type");
            throw new CoreException((IStatus)result);
        }
    }

    public void createFileRemotely(ISemanticFileStore childStore, String name, InputStream source, Object context, IProgressMonitor monitor) throws CoreException {
        byte[] buffer;
        if (source != null) {
            try {
                int size = source.available();
                buffer = new byte[size];
                source.read(buffer);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
            }
        } else {
            buffer = new byte[]{};
        }
        RemoteItem parentItem = this.getStore().getItemByPath(childStore.getPath().removeFirstSegments(2));
        if (parentItem.getType() != RemoteItem.Type.FOLDER) {
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, parentItem.getPath(), "");
        }
        ((RemoteFolder)parentItem).addFile(name, buffer, System.currentTimeMillis());
        childStore.addChildFile(name);
        ISemanticFileStore newStore = (ISemanticFileStore)childStore.getChild(name);
        this.setReadOnly(newStore, false, monitor);
        this.lockResource(newStore, monitor);
    }

    public void createResourceRemotely(ISemanticFileStore childStore, String name, Object context, IProgressMonitor monitor) throws CoreException {
        this.createFileRemotely(childStore, name, null, context, monitor);
    }

    public void deleteRemotely(ISemanticFileStore childStore, IProgressMonitor monitor) throws CoreException {
        RemoteItem parentItem = this.getStore().getItemByPath(childStore.getPath().removeFirstSegments(2).removeLastSegments(1));
        if (parentItem.getType() != RemoteItem.Type.FOLDER) {
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, parentItem.getPath(), "");
        }
        ((RemoteFolder)parentItem).deleteChild(childStore.getName());
        childStore.remove(monitor);
    }

    public IStatus lockResource(ISemanticFileStore childStore, IProgressMonitor monitor) throws CoreException {
        RemoteItem item = this.getStore().getItemByPath(childStore.getPath().removeFirstSegments(2));
        item.setLocked(true);
        childStore.setSessionProperty(LOCKHANDLE, (Object)"");
        return new Status(0, "org.eclipse.core.resources.semantic.test", "");
    }

    public IStatus unlockResource(ISemanticFileStore childStore, IProgressMonitor monitor) throws CoreException {
        RemoteItem item = this.getStore().getItemByPath(childStore.getPath().removeFirstSegments(2));
        item.setLocked(false);
        childStore.setSessionProperty(LOCKHANDLE, null);
        return new Status(0, "org.eclipse.core.resources.semantic.test", "");
    }

    public ISemanticSpiResourceInfo fetchResourceInfo(ISemanticFileStore semanticFileStore, int options, IProgressMonitor monitor) throws CoreException {
        return new SemanticSpiResourceInfo(options, semanticFileStore.getSessionProperty(LOCKHANDLE) != null, true, semanticFileStore.getPersistentProperty(READONLY) != null, this.getStore().getItemByPath(semanticFileStore.getPath().removeFirstSegments(2)) != null, null, null);
    }

    public InputStream openInputStreamInternal(ISemanticFileStore store, IProgressMonitor monitor, CachingContentProvider.ICacheTimestampSetter timeStampSetter) throws CoreException {
        RemoteItem item = this.getStore().getItemByPath(store.getPath().removeFirstSegments(2));
        if (item.getType() != RemoteItem.Type.FILE) {
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, item.getPath(), "");
        }
        timeStampSetter.setTimestamp(((RemoteFile)item).getTimestamp());
        return new ByteArrayInputStream(((RemoteFile)item).getContent());
    }

    public void removeResource(ISemanticFileStore childStore, IProgressMonitor monitor) throws CoreException {
        this.deleteCache(childStore, monitor);
        childStore.remove(monitor);
    }

    public void revertChanges(ISemanticFileStore store, IProgressMonitor monitor) throws CoreException {
        RemoteItem item = this.getStore().getItemByPath(store.getPath().removeFirstSegments(2));
        if (item.getType() != RemoteItem.Type.FILE) {
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, item.getPath(), "");
        }
        ((RemoteFile)item).getOutputStream(false).reset();
        MultiStatus status = new MultiStatus("org.eclipse.core.resources.semantic.test", 0, NLS.bind((String)"Revert Change Result for {0}", (Object)store.getPath().toString()), null);
        this.deleteCache(store, monitor);
        this.setReadOnly(store, true, null);
        Util.safeClose((InputStream)this.openInputStream(store, monitor));
        if (!status.isOK()) {
            throw new CoreException((IStatus)status);
        }
    }

    public void setReadOnly(ISemanticFileStore childStore, boolean readonly, IProgressMonitor monitor) throws CoreException {
        if (readonly) {
            childStore.setPersistentProperty(READONLY, "");
        } else {
            childStore.setPersistentProperty(READONLY, null);
        }
    }

    public void synchronizeContentWithRemote(ISemanticFileStore store, SyncDirection direction, IProgressMonitor monitor, MultiStatus status) {
        RemoteItem item = this.getStore().getItemByPath(store.getPath().removeFirstSegments(2));
        if (item.getType() != RemoteItem.Type.FILE) {
            status.add(new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, item.getPath(), "").getStatus());
            return;
        }
        try {
            if (item.isLocked()) {
                store.setSessionProperty(LOCKHANDLE, (Object)"");
            } else {
                store.setSessionProperty(LOCKHANDLE, null);
            }
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
        RemoteFile file = (RemoteFile)item;
        try {
            boolean syncIn;
            ICacheService srv = this.getCacheService();
            IPath storePath = store.getPath();
            long localStamp = this.getResourceTimestamp(store, monitor);
            long remoteStamp = file.getTimestamp();
            boolean syncOut = direction != SyncDirection.INCOMING && localStamp > remoteStamp;
            boolean bl = syncIn = direction != SyncDirection.OUTGOING && remoteStamp > localStamp;
            if (syncOut) {
                InputStream is = srv.getContent(storePath);
                ByteArrayOutputStream os = null;
                try {
                    os = file.getOutputStream(false);
                    Util.transferStreams((InputStream)is, (OutputStream)os, (IProgressMonitor)monitor);
                }
                finally {
                    Util.safeClose((InputStream)is);
                    Util.safeClose((OutputStream)os);
                }
                this.setResourceTimestamp(store, file.getTimestamp(), monitor);
            }
            if (syncIn) {
                srv.addContent(storePath, (InputStream)new ByteArrayInputStream(file.getContent()), 0, monitor);
                this.setResourceTimestamp(store, file.getTimestamp(), monitor);
            }
        }
        catch (CoreException ce) {
            status.add(ce.getStatus());
        }
        try {
            IFileStore[] children;
            IFileStore[] iFileStoreArray = children = store.childStores(0, monitor);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore childStore = iFileStoreArray[n2];
                this.synchronizeContentWithRemote((ISemanticFileStore)childStore, direction, monitor, status);
                ++n2;
            }
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    public IStatus validateEdit(ISemanticFileStore[] stores, Object shell) {
        MultiStatus multi = new MultiStatus("org.eclipse.core.resources.semantic.test", 0, "Validate Edit Result", null);
        ISemanticFileStore[] iSemanticFileStoreArray = stores;
        int n = stores.length;
        int n2 = 0;
        while (n2 < n) {
            ISemanticFileStore store = iSemanticFileStoreArray[n2];
            RemoteItem item = this.getStore().getItemByPath(store.getPath().removeFirstSegments(2));
            if (item == null) {
                multi.add((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", "Resource not found"));
            } else if (item.getType() != RemoteItem.Type.FILE) {
                multi.add((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", "Can only edit files"));
            } else {
                try {
                    this.lockResource(store, null);
                    this.setReadOnly(store, false, null);
                }
                catch (CoreException coreException) {
                    multi.add((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", "Exception while locking resource"));
                }
            }
            ++n2;
        }
        return multi;
    }

    public IStatus validateRemoteCreate(ISemanticFileStore childStore, String childName, Object shell) {
        RemoteItem item = this.getStore().getItemByPath(childStore.getPath().removeFirstSegments(2));
        if (item != null) {
            return new Status(4, "org.eclipse.core.resources.semantic.test", "Resource already exists");
        }
        return null;
    }

    public IStatus validateRemoteDelete(ISemanticFileStore childStore, Object shell) {
        RemoteItem item = this.getStore().getItemByPath(childStore.getPath().removeFirstSegments(2));
        if (item == null) {
            return new Status(4, "org.eclipse.core.resources.semantic.test", "Resource not found");
        }
        return new Status(0, "org.eclipse.core.resources.semantic.test", "");
    }

    public IStatus validateSave(ISemanticFileStore childStore) {
        RemoteItem item = this.getStore().getItemByPath(childStore.getPath().removeFirstSegments(2));
        if (item == null) {
            return new Status(4, "org.eclipse.core.resources.semantic.test", "Resource not found");
        }
        return new Status(0, "org.eclipse.core.resources.semantic.test", "");
    }

    protected RemoteStoreTransient getStore() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().findMember(this.getRootStore().getPath()).getProject();
        RemoteStoreTransient store = (RemoteStoreTransient)project.getAdapter(RemoteStoreTransient.class);
        return store;
    }
}

