/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.internal.resources.semantic.Messages;
import org.eclipse.core.internal.resources.semantic.SemanticFileSystem;
import org.eclipse.core.internal.resources.semantic.SfsTraceLocation;
import org.eclipse.core.internal.resources.semantic.Util;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.ResourceTreeNode;
import org.eclipse.core.resources.semantic.ISemanticProperties;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SemanticProperties
extends FileStore
implements ISemanticProperties {
    protected final ResourceTreeNode node;
    protected final SemanticFileSystem fs;

    SemanticProperties(SemanticFileSystem fs, ResourceTreeNode node) {
        this.fs = fs;
        this.node = node;
    }

    private IPath getPathForTrace() {
        try {
            this.fs.lockForRead();
            StringBuilder sb = new StringBuilder(50);
            sb.append('/');
            sb.append(this.node.getName());
            ResourceTreeNode parent = this.node.getParent();
            while (parent != null) {
                sb.insert(0, parent.getName());
                sb.insert(0, '/');
                parent = parent.getParent();
            }
            Path path = new Path(sb.toString());
            return path;
        }
        catch (RuntimeException runtimeException) {
            Path path = new Path(this.node.getName());
            return path;
        }
        finally {
            this.fs.unlockForRead();
        }
    }

    @Override
    public Map<QualifiedName, String> getPersistentProperties() throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.CORE_VERBOSE.getLocation(), (Object)this.getPathForTrace().toString());
        }
        this.checkAccessible();
        HashMap<QualifiedName, String> result = new HashMap<QualifiedName, String>();
        try {
            this.fs.lockForRead();
            HashMap<String, String> atts = this.node.getPersistentProperties();
            if (atts == null) {
                HashMap<QualifiedName, String> hashMap = result;
                return hashMap;
            }
            for (Map.Entry<String, String> entry : atts.entrySet()) {
                String localName;
                String qualifier;
                int index = entry.getKey().indexOf(94);
                if (index > 0) {
                    qualifier = entry.getKey().substring(0, index);
                    localName = entry.getKey().substring(index + 1);
                } else {
                    qualifier = null;
                    localName = entry.getKey();
                }
                result.put(new QualifiedName(qualifier, localName), entry.getValue());
            }
            HashMap<QualifiedName, String> hashMap = result;
            return hashMap;
        }
        finally {
            this.fs.unlockForRead();
            if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.CORE_VERBOSE.getLocation(), result);
            }
        }
    }

    @Override
    public String getPersistentProperty(QualifiedName key) throws CoreException {
        String string;
        block7: {
            HashMap<String, String> nodeProps;
            String result;
            block5: {
                String string2;
                block6: {
                    if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
                        SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.CORE_VERBOSE.getLocation(), new Object[]{this.getPathForTrace().toString(), key});
                    }
                    result = null;
                    try {
                        this.fs.lockForRead();
                        nodeProps = this.node.getPersistentProperties();
                        if (nodeProps != null) break block5;
                        string2 = result;
                        this.fs.unlockForRead();
                        if (!SfsTraceLocation.CORE_VERBOSE.isActive()) break block6;
                    }
                    catch (Throwable throwable) {
                        this.fs.unlockForRead();
                        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
                            SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.CORE_VERBOSE.getLocation(), result);
                        }
                        throw throwable;
                    }
                    SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.CORE_VERBOSE.getLocation(), (Object)result);
                }
                return string2;
            }
            String keyString = Util.qualifiedNameToString(key);
            string = result = nodeProps.get(keyString);
            this.fs.unlockForRead();
            if (!SfsTraceLocation.CORE_VERBOSE.isActive()) break block7;
            SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.CORE_VERBOSE.getLocation(), (Object)result);
        }
        return string;
    }

    @Override
    public void setPersistentProperty(QualifiedName key, String value) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.CORE_VERBOSE.getLocation(), (Object)this.getPathForTrace().toString());
        }
        this.checkAccessible();
        Util.assertQualifiedNameValid(key);
        String keyString = Util.qualifiedNameToString(key);
        try {
            this.fs.lockForWrite();
            String oldValue = null;
            HashMap<String, String> map = this.node.getPersistentProperties();
            if (map == null) {
                map = new HashMap();
            } else {
                oldValue = map.get(keyString);
            }
            if (value != null) {
                map.put(keyString, value);
            } else {
                map.remove(keyString);
            }
            this.node.setPersistentProperties(map);
            this.notifyPersistentPropertySet(keyString, oldValue, value);
            this.fs.requestFlush(false);
        }
        finally {
            this.fs.unlockForWrite();
        }
    }

    protected abstract void notifyPersistentPropertySet(String var1, String var2, String var3) throws CoreException;

    @Override
    public void setSessionProperty(QualifiedName key, Object value) throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.CORE_VERBOSE.getLocation(), (Object)this.getPathForTrace().toString());
        }
        this.checkAccessible();
        Util.assertQualifiedNameValid(key);
        try {
            this.fs.lockForWrite();
            HashMap<Object, Object> map = this.node.getSessionProperties();
            if (map == null) {
                map = new HashMap();
                this.node.setSessionProperties(map);
            }
            if (value != null) {
                map.put(key, value);
            } else {
                map.remove(key);
            }
        }
        finally {
            this.fs.unlockForWrite();
        }
    }

    @Override
    public Map<QualifiedName, Object> getSessionProperties() throws CoreException {
        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.CORE_VERBOSE.getLocation(), (Object)this.getPathForTrace().toString());
        }
        this.checkAccessible();
        HashMap<QualifiedName, Object> result = new HashMap<QualifiedName, Object>();
        try {
            this.fs.lockForRead();
            HashMap<QualifiedName, Object> atts = this.node.getSessionProperties();
            if (atts == null) {
                HashMap<QualifiedName, Object> hashMap = result;
                return hashMap;
            }
            for (Map.Entry<QualifiedName, Object> entry : atts.entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
            HashMap<QualifiedName, Object> hashMap = result;
            return hashMap;
        }
        finally {
            this.fs.unlockForRead();
            if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.CORE_VERBOSE.getLocation(), result);
            }
        }
    }

    @Override
    public Object getSessionProperty(QualifiedName key) throws CoreException {
        Object object;
        block7: {
            HashMap<QualifiedName, Object> nodeProps;
            Object result;
            block5: {
                Object object2;
                block6: {
                    if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
                        SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.CORE_VERBOSE.getLocation(), new Object[]{this.getPathForTrace().toString(), key});
                    }
                    result = null;
                    try {
                        this.fs.lockForRead();
                        nodeProps = this.node.getSessionProperties();
                        if (nodeProps != null) break block5;
                        object2 = result;
                        this.fs.unlockForRead();
                        if (!SfsTraceLocation.CORE_VERBOSE.isActive()) break block6;
                    }
                    catch (Throwable throwable) {
                        this.fs.unlockForRead();
                        if (SfsTraceLocation.CORE_VERBOSE.isActive()) {
                            SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.CORE_VERBOSE.getLocation(), result);
                        }
                        throw throwable;
                    }
                    SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.CORE_VERBOSE.getLocation(), result);
                }
                return object2;
            }
            object = result = nodeProps.get(key);
            this.fs.unlockForRead();
            if (!SfsTraceLocation.CORE_VERBOSE.isActive()) break block7;
            SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.CORE_VERBOSE.getLocation(), result);
        }
        return object;
    }

    protected void checkAccessible() throws CoreException {
        if (!this.node.isExists()) {
            throw new SemanticResourceException(SemanticResourceStatusCode.PROJECT_NOT_ACCESSIBLE, this.getPathForTrace(), Messages.SemanticProperties_StoreNotAccessible_XMSG);
        }
    }
}

