/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.team;

import java.net.URI;
import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.semantic.SfsTraceLocation;
import org.eclipse.core.internal.resources.semantic.team.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProvider;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

public class DelegatingResourceRuleFactory
implements IResourceRuleFactory {
    final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();

    public DelegatingResourceRuleFactory(ISemanticFileSystem actSfs) {
    }

    public ISchedulingRule buildRule() {
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)this.root.getFullPath().toString());
        }
        return this.root;
    }

    public ISchedulingRule charsetRule(IResource resource) {
        IWorkspaceRoot result;
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)resource.getFullPath().toString());
        }
        try {
            ISemanticResource sres = (ISemanticResource)resource.getAdapter(ISemanticResource.class);
            if (sres != null) {
                ISemanticFileStore sfs = (ISemanticFileStore)EFS.getStore((URI)resource.getLocationURI());
                result = this.toRule(sfs.getEffectiveContentProvider().getRuleFactory().charsetRule(sfs));
            } else {
                if (SfsTraceLocation.RULEFACTORY.isActive()) {
                    SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), Messages.DelegatingResourceRuleFactory_ResourceNotAdapter_XMSG);
                }
                result = this.root;
            }
        }
        catch (CoreException e) {
            if (SfsTraceLocation.RULEFACTORY.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), e.getMessage(), (Throwable)e);
            }
            result = this.root;
        }
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            if (result instanceof IResource) {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)((IResource)result).getFullPath().toString());
            } else {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)result);
            }
        }
        return result;
    }

    public ISchedulingRule copyRule(IResource source, IResource destination) {
        IWorkspaceRoot result;
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)destination.getFullPath().toString());
        }
        try {
            ISemanticResource sourceres = (ISemanticResource)source.getAdapter(ISemanticResource.class);
            ISemanticResource desinationres = (ISemanticResource)destination.getAdapter(ISemanticResource.class);
            if (sourceres != null && desinationres != null) {
                ISemanticFileStore sourceStore = (ISemanticFileStore)EFS.getStore((URI)source.getLocationURI());
                ISemanticFileStore destinationStore = (ISemanticFileStore)EFS.getStore((URI)destination.getLocationURI());
                if (sourceStore.getEffectiveContentProvider().getClass().getName().equals(destinationStore.getEffectiveContentProvider().getClass().getName())) {
                    ISchedulingRule iSchedulingRule = this.toRule(sourceStore.getEffectiveContentProvider().getRuleFactory().copyRule(sourceStore, destinationStore));
                }
                result = this.toRule(sourceStore.getEffectiveContentProvider().getRuleFactory().copyRule(sourceStore, destinationStore), destinationStore.getEffectiveContentProvider().getRuleFactory().copyRule(sourceStore, destinationStore));
            } else {
                if (SfsTraceLocation.RULEFACTORY.isActive()) {
                    SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), Messages.DelegatingResourceRuleFactory_ResourceNotAdapter_XMSG);
                }
                result = this.root;
            }
        }
        catch (CoreException e) {
            if (SfsTraceLocation.RULEFACTORY.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), e.getMessage(), (Throwable)e);
            }
            result = this.root;
        }
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            if (result instanceof IResource) {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)((IResource)result).getFullPath().toString());
            } else {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)result);
            }
        }
        return result;
    }

    public ISchedulingRule createRule(IResource resource) {
        IWorkspaceRoot result;
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)resource.getFullPath().toString());
        }
        try {
            ISemanticResource sres = (ISemanticResource)resource.getAdapter(ISemanticResource.class);
            if (sres != null) {
                ISemanticFileStore parentStore;
                ISemanticFileStore sfs = (ISemanticFileStore)EFS.getStore((URI)resource.getLocationURI());
                ISemanticContentProvider effectiveProvider = sfs.getEffectiveContentProvider();
                if (effectiveProvider.getRootStore().getPath().equals((Object)sfs.getPath()) && (parentStore = (ISemanticFileStore)sfs.getParent()) != null) {
                    ISchedulingRule iSchedulingRule = this.toRule(parentStore.getEffectiveContentProvider().getRuleFactory().createRule(sfs));
                }
                result = this.toRule(effectiveProvider.getRuleFactory().createRule(sfs));
            } else {
                if (SfsTraceLocation.RULEFACTORY.isActive()) {
                    SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), Messages.DelegatingResourceRuleFactory_ResourceNotAdapter_XMSG);
                }
                result = this.root;
            }
        }
        catch (CoreException e) {
            if (SfsTraceLocation.RULEFACTORY.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), e.getMessage(), (Throwable)e);
            }
            result = this.root;
        }
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            if (result instanceof IResource) {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)((IResource)result).getFullPath().toString());
            } else {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)result);
            }
        }
        return result;
    }

    public ISchedulingRule deleteRule(IResource resource) {
        IWorkspaceRoot result;
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)resource.getFullPath().toString());
        }
        try {
            ISemanticResource sres = (ISemanticResource)resource.getAdapter(ISemanticResource.class);
            if (sres != null) {
                ISemanticFileStore parentStore;
                ISemanticFileStore sfs = (ISemanticFileStore)EFS.getStore((URI)resource.getLocationURI());
                ISemanticContentProvider effectiveProvider = sfs.getEffectiveContentProvider();
                result = effectiveProvider.getRootStore().getPath().equals((Object)sfs.getPath()) ? ((parentStore = (ISemanticFileStore)sfs.getParent()) != null ? this.toRule(parentStore.getEffectiveContentProvider().getRuleFactory().deleteRule(sfs)) : this.toRule(effectiveProvider.getRuleFactory().deleteRule(sfs))) : this.toRule(effectiveProvider.getRuleFactory().deleteRule(sfs));
            } else {
                if (SfsTraceLocation.RULEFACTORY.isActive()) {
                    SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), Messages.DelegatingResourceRuleFactory_ResourceNotAdapter_XMSG);
                }
                result = this.root;
            }
        }
        catch (CoreException e) {
            if (SfsTraceLocation.RULEFACTORY.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), e.getMessage(), (Throwable)e);
            }
            result = this.root;
        }
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            if (result instanceof IResource) {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)((IResource)result).getFullPath().toString());
            } else {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)result);
            }
        }
        return result;
    }

    public ISchedulingRule markerRule(IResource resource) {
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)resource.getFullPath().toString());
        }
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), null);
        }
        return null;
    }

    public ISchedulingRule modifyRule(IResource resource) {
        IWorkspaceRoot result;
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)resource.getFullPath().toString());
        }
        try {
            ISemanticResource sres = (ISemanticResource)resource.getAdapter(ISemanticResource.class);
            if (sres != null) {
                ISemanticFileStore sfs = (ISemanticFileStore)EFS.getStore((URI)resource.getLocationURI());
                result = this.toRule(sfs.getEffectiveContentProvider().getRuleFactory().modifyRule(sfs));
            } else {
                if (SfsTraceLocation.RULEFACTORY.isActive()) {
                    SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), Messages.DelegatingResourceRuleFactory_ResourceNotAdapter_XMSG);
                }
                result = this.root;
            }
        }
        catch (CoreException e) {
            if (SfsTraceLocation.RULEFACTORY.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), e.getMessage(), (Throwable)e);
            }
            result = this.root;
        }
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            if (result instanceof IResource) {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)((IResource)result).getFullPath().toString());
            } else {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)result);
            }
        }
        return result;
    }

    public ISchedulingRule moveRule(IResource source, IResource destination) {
        IWorkspaceRoot result;
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.RULEFACTORY.getLocation(), new Object[]{source.getFullPath().toString(), destination.getFullPath().toString()});
        }
        try {
            ISemanticResource sourceres = (ISemanticResource)source.getAdapter(ISemanticResource.class);
            ISemanticResource desinationres = (ISemanticResource)destination.getAdapter(ISemanticResource.class);
            if (sourceres != null && desinationres != null) {
                ISemanticFileStore sourceStore = (ISemanticFileStore)EFS.getStore((URI)source.getLocationURI());
                ISemanticFileStore destinationStore = (ISemanticFileStore)EFS.getStore((URI)destination.getLocationURI());
                result = sourceStore.getEffectiveContentProvider().getClass().getName().equals(destinationStore.getEffectiveContentProvider().getClass().getName()) ? this.toRule(sourceStore.getEffectiveContentProvider().getRuleFactory().moveRule(sourceStore, destinationStore)) : this.toRule(sourceStore.getEffectiveContentProvider().getRuleFactory().moveRule(sourceStore, destinationStore), destinationStore.getEffectiveContentProvider().getRuleFactory().moveRule(sourceStore, destinationStore));
            } else {
                if (SfsTraceLocation.RULEFACTORY.isActive()) {
                    SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), Messages.DelegatingResourceRuleFactory_ResourceNotAdapter_XMSG);
                }
                result = this.root;
            }
        }
        catch (CoreException e) {
            if (SfsTraceLocation.RULEFACTORY.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), e.getMessage(), (Throwable)e);
            }
            result = this.root;
        }
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            if (result instanceof IResource) {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)((IResource)result).getFullPath().toString());
            } else {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)result);
            }
        }
        return result;
    }

    public ISchedulingRule refreshRule(IResource resource) {
        IWorkspaceRoot result;
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)resource.getFullPath().toString());
        }
        try {
            ISemanticResource sres = (ISemanticResource)resource.getAdapter(ISemanticResource.class);
            if (sres != null) {
                ISemanticFileStore sfs = (ISemanticFileStore)EFS.getStore((URI)resource.getLocationURI());
                ISemanticContentProvider effectiveProvider = sfs.getEffectiveContentProvider();
                result = this.toRule(effectiveProvider.getRuleFactory().refreshRule(sfs));
            } else {
                if (SfsTraceLocation.RULEFACTORY.isActive()) {
                    SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), Messages.DelegatingResourceRuleFactory_ResourceNotAdapter_XMSG);
                }
                result = this.root;
            }
        }
        catch (CoreException e) {
            if (SfsTraceLocation.RULEFACTORY.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), e.getMessage(), (Throwable)e);
            }
            result = this.root;
        }
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            if (result instanceof IResource) {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)((IResource)result).getFullPath().toString());
            } else {
                SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)result);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ISchedulingRule validateEditRule(IResource[] resources) {
        IWorkspaceRoot result;
        block22: {
            ISemanticFileStore[] stores;
            if (SfsTraceLocation.RULEFACTORY.isActive()) {
                Object[] input = new Object[resources.length];
                int i = 0;
                while (i < resources.length) {
                    input[i] = resources[i].getFullPath().toString();
                    ++i;
                }
                SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.RULEFACTORY.getLocation(), input);
            }
            if ((stores = this.allStoresFromSameProvider(resources)) != null) {
                try {
                    ISemanticResource sres = (ISemanticResource)resources[0].getAdapter(ISemanticResource.class);
                    if (sres != null) {
                        result = this.toRule(stores[0].getEffectiveContentProvider().getRuleFactory().validateEditRule(stores));
                        break block22;
                    }
                    if (SfsTraceLocation.RULEFACTORY.isActive()) {
                        SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), Messages.DelegatingResourceRuleFactory_ResourceNotAdapter_XMSG);
                    }
                    result = this.root;
                }
                catch (CoreException e) {
                    if (SfsTraceLocation.RULEFACTORY.isActive()) {
                        SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), e.getMessage(), (Throwable)e);
                    }
                    result = this.root;
                }
            } else {
                try {
                    HashSet<ISemanticFileStore> ruleStores = new HashSet<ISemanticFileStore>();
                    IResource[] iResourceArray = resources;
                    int n = resources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource res = iResourceArray[n2];
                        ISemanticResource sres = (ISemanticResource)res.getAdapter(ISemanticResource.class);
                        if (sres != null) {
                            IFileStore fs = EFS.getStore((URI)res.getLocationURI());
                            if (fs instanceof ISemanticFileStore) {
                                ISemanticFileStore sfs = (ISemanticFileStore)fs;
                                ISemanticFileStore ruleStore = sfs.getEffectiveContentProvider().getRuleFactory().validateEditRule(new ISemanticFileStore[]{sfs});
                                if (ruleStore != null) {
                                    ruleStores.add(ruleStore);
                                } else {
                                    ruleStores.clear();
                                    break;
                                }
                            }
                        } else {
                            ruleStores.clear();
                            break;
                        }
                        ++n2;
                    }
                    if (ruleStores.isEmpty()) {
                        if (SfsTraceLocation.RULEFACTORY.isActive()) {
                            SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), Messages.DelegatingResourceRuleFactory_ResourceNotAdapter_XMSG);
                        }
                        result = this.root;
                    } else {
                        result = this.toRule(ruleStores.toArray(new ISemanticFileStore[0]));
                    }
                }
                catch (CoreException e) {
                    if (SfsTraceLocation.RULEFACTORY.isActive()) {
                        SfsTraceLocation.getTrace().trace(SfsTraceLocation.RULEFACTORY.getLocation(), e.getMessage(), (Throwable)e);
                    }
                    result = this.root;
                }
            }
        }
        if (!SfsTraceLocation.RULEFACTORY.isActive()) return result;
        if (result instanceof IResource) {
            SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)((IResource)result).getFullPath().toString());
            return result;
        }
        SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)result);
        return result;
    }

    public ISchedulingRule derivedRule(IResource resource) {
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.RULEFACTORY.getLocation(), (Object)resource.getFullPath().toString());
        }
        if (SfsTraceLocation.RULEFACTORY.isActive()) {
            SfsTraceLocation.getTrace().traceExit(SfsTraceLocation.RULEFACTORY.getLocation(), null);
        }
        return null;
    }

    private ISchedulingRule toRule(ISemanticFileStore ... stores) throws CoreException {
        if (stores.length == 1) {
            if (stores[0] == null) {
                return this.root;
            }
            IPath path = stores[0].getPath();
            IResource rule = this.root.findMember(path);
            while (!(rule != null && rule.exists() || path.segmentCount() <= 0)) {
                path = path.removeLastSegments(1);
                rule = this.root.findMember(path);
            }
            if (rule == null || !rule.exists()) {
                throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_FOR_STORE_NOT_FOUND, stores[0].getPath(), MessageFormat.format(Messages.DelegatingResourceRuleFactory_NoExistingParentFound_XMSG, stores[0].getPath().toString()));
            }
            return rule;
        }
        ISchedulingRule[] rules = new ISchedulingRule[stores.length];
        int i = 0;
        while (i < stores.length) {
            ISemanticFileStore store = stores[i];
            if (store == null) {
                return this.root;
            }
            IPath path = stores[i].getPath();
            IResource rule = this.root.findMember(path);
            while (!(rule != null && rule.exists() || path.segmentCount() <= 0)) {
                path = path.removeLastSegments(1);
                rule = this.root.findMember(path);
            }
            if (rule == null || !rule.exists()) {
                throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_FOR_STORE_NOT_FOUND, store.getPath(), MessageFormat.format(Messages.DelegatingResourceRuleFactory_NoExistingParentFound_XMSG, stores[0].getPath().toString()));
            }
            rules[i] = rule;
            ++i;
        }
        return new MultiRule(rules);
    }

    private ISemanticFileStore[] allStoresFromSameProvider(IResource ... resources) {
        ISemanticFileStore[] result = new ISemanticFileStore[resources.length];
        String lastName = null;
        int i = 0;
        while (i < resources.length) {
            String className;
            block6: {
                IFileStore store;
                block5: {
                    IResource res = resources[i];
                    try {
                        store = EFS.getStore((URI)res.getLocationURI());
                        if (store instanceof ISemanticFileStore) break block5;
                        return null;
                    }
                    catch (CoreException coreException) {
                        return null;
                    }
                }
                result[i] = (ISemanticFileStore)store;
                className = result[i].getEffectiveContentProvider().getClass().getName();
                if (lastName == null || lastName.equals(className)) break block6;
                return null;
            }
            lastName = className;
            ++i;
        }
        return result;
    }
}

