/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.commands.tests;

import junit.framework.TestCase;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.tests.TestActivator;
import org.eclipse.e4.core.commands.tests.TestUtil;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;

public class DefineCommandsTest
extends TestCase {
    private static final String TEST_ID2 = "test.id2";
    private static final String TEST_ID1 = "test.id1";
    private static final String TEST_CAT1 = "test.cat1";
    private IEclipseContext workbenchContext;

    public void testCreateCommands() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        DefineCommandsTest.assertNotNull((Object)cs);
        DefineCommandsTest.assertNotNull((Object)cs.defineCategory(TEST_CAT1, "CAT1", null));
        Category category = cs.getCategory(TEST_CAT1);
        DefineCommandsTest.assertNotNull((String)"need category", (Object)category);
        DefineCommandsTest.assertNotNull((String)"command1", (Object)cs.defineCommand(TEST_ID1, "ID1", null, category, null));
        DefineCommandsTest.assertNotNull((String)"command2", (Object)cs.defineCommand(TEST_ID2, "ID2", null, category, null));
        Command cmd1 = cs.getCommand(TEST_ID1);
        DefineCommandsTest.assertNotNull((String)"get command1", (Object)cmd1);
        DefineCommandsTest.assertEquals((String)"ID1", (String)cmd1.getName());
        DefineCommandsTest.assertNotNull((String)"get command2", (Object)cs.getCommand(TEST_ID2));
        DefineCommandsTest.assertNotNull((String)"parameterized command", (Object)cs.createCommand(TEST_ID1, null));
    }

    public void testCreateWithSecondContexts() throws Exception {
        IEclipseContext localContext = EclipseContextFactory.create((IEclipseContext)this.workbenchContext, null);
        ECommandService cs = (ECommandService)localContext.get(ECommandService.class.getName());
        DefineCommandsTest.assertNotNull((Object)cs);
        DefineCommandsTest.assertNotNull((Object)cs.defineCategory(TEST_CAT1, "CAT1", null));
        Category category = cs.getCategory(TEST_CAT1);
        DefineCommandsTest.assertNotNull((String)"need category", (Object)category);
        DefineCommandsTest.assertNotNull((String)"command1", (Object)cs.defineCommand(TEST_ID1, "ID1", null, category, null));
        DefineCommandsTest.assertNotNull((String)"command2", (Object)cs.defineCommand(TEST_ID2, "ID2", null, category, null));
        Command cmd1 = cs.getCommand(TEST_ID1);
        DefineCommandsTest.assertNotNull((String)"get command1", (Object)cmd1);
        DefineCommandsTest.assertEquals((String)"ID1", (String)cmd1.getName());
        DefineCommandsTest.assertNotNull((String)"get command2", (Object)cs.getCommand(TEST_ID2));
    }

    public void testCreateWithTwoContexts() throws Exception {
        IEclipseContext localContext = TestUtil.createContext(this.workbenchContext, "Level1");
        ECommandService cs = (ECommandService)localContext.get(ECommandService.class.getName());
        DefineCommandsTest.assertNotNull((Object)cs);
        DefineCommandsTest.assertNotNull((Object)cs.defineCategory(TEST_CAT1, "CAT1", null));
        Category category = cs.getCategory(TEST_CAT1);
        DefineCommandsTest.assertNotNull((String)"need category", (Object)category);
        DefineCommandsTest.assertNotNull((String)"command1", (Object)cs.defineCommand(TEST_ID1, "ID1", null, category, null));
        DefineCommandsTest.assertNotNull((String)"command2", (Object)cs.defineCommand(TEST_ID2, "ID2", null, category, null));
        cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        Command cmd1 = cs.getCommand(TEST_ID1);
        DefineCommandsTest.assertNotNull((String)"get command1", (Object)cmd1);
        DefineCommandsTest.assertEquals((String)"ID1", (String)cmd1.getName());
        DefineCommandsTest.assertNotNull((String)"get command2", (Object)cs.getCommand(TEST_ID2));
    }

    protected void setUp() throws Exception {
        this.workbenchContext = this.createWorkbenchContext(TestActivator.getDefault().getGlobalContext());
    }

    protected void tearDown() throws Exception {
        if (this.workbenchContext instanceof IDisposable) {
            ((IDisposable)this.workbenchContext).dispose();
        }
        this.workbenchContext = null;
    }

    private IEclipseContext createWorkbenchContext(IEclipseContext globalContext) {
        IEclipseContext wb = TestUtil.createContext(globalContext, "workbenchContext");
        return wb;
    }
}

