/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.commands.internal;

import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class CommandServiceImpl
implements ECommandService {
    public static final String CAT_ID = "category::";
    public static final String CMD_ID = "command::";
    private CommandManager commandManager;
    private IEclipseContext context;

    @Inject
    public void setManager(CommandManager m) {
        this.commandManager = m;
    }

    @Inject
    public void setContext(IEclipseContext c) {
        this.context = c;
    }

    public ParameterizedCommand createCommand(String id, Map parameters) {
        return ParameterizedCommand.generateCommand((Command)this.getCommand(id), (Map)parameters);
    }

    public Category defineCategory(String id, String name, String description) {
        Category cat = this.commandManager.getCategory(id);
        if (!cat.isDefined()) {
            cat.define(name, description);
            this.context.set(CAT_ID + id, (Object)cat);
        }
        return cat;
    }

    public Command defineCommand(String id, String name, String description, Category category, IParameter[] parameters) {
        Command cmd = this.commandManager.getCommand(id);
        if (!cmd.isDefined()) {
            cmd.define(name, description, category, parameters);
            this.context.set(CMD_ID + id, (Object)cmd);
        }
        return cmd;
    }

    public Category getCategory(String categoryId) {
        return (Category)this.context.get(CAT_ID + categoryId);
    }

    public Command getCommand(String commandId) {
        return (Command)this.context.get(CMD_ID + commandId);
    }
}

