/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.commands.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.log.Logger;

public class HandlerServiceImpl
implements EHandlerService {
    static final String METHOD_EXECUTE = "execute";
    static final String METHOD_CAN_EXECUTE = "canExecute";
    static final String H_ID = "handler::";
    public static final String PARM_MAP = "parmMap::";
    static final String HANDLER_LOOKUP = "org.eclipse.e4.core.commands.EHandlerLookup";
    static final String LOOKUP_HANDLER = "handler";
    private IEclipseContext context;

    private static Object[] lookupHandler(String handlerId) {
        return new Object[]{handlerId};
    }

    public static Object lookUpHandler(IEclipseContext context, String commandId) {
        String handlerId = H_ID + commandId;
        return context.get(HANDLER_LOOKUP, HandlerServiceImpl.lookupHandler(handlerId));
    }

    public void activateHandler(String commandId, Object handler) {
        String handlerId = H_ID + commandId;
        this.context.set(handlerId, handler);
    }

    private void addParmsToContext(ParameterizedCommand command) {
        Map parms = command.getParameterMap();
        for (Map.Entry entry : parms.entrySet()) {
            this.context.set((String)entry.getKey(), entry.getValue());
        }
        this.context.set(PARM_MAP, (Object)parms);
    }

    public boolean canExecute(ParameterizedCommand command) {
        Boolean result;
        String commandId = command.getId();
        Object handler = HandlerServiceImpl.lookUpHandler(this.context, commandId);
        if (handler == null) {
            return false;
        }
        this.addParmsToContext(command);
        try {
            result = (Boolean)ContextInjectionFactory.invoke((Object)handler, (String)METHOD_CAN_EXECUTE, (IEclipseContext)this.context, (Object)Boolean.TRUE);
        }
        catch (InvocationTargetException e) {
            Logger logger = (Logger)this.context.get(Logger.class.getName());
            if (logger != null) {
                logger.error((Throwable)e);
            }
            return true;
        }
        return result;
    }

    public void deactivateHandler(String commandId, Object handler) {
        this.context.remove(H_ID + commandId);
    }

    public Object executeHandler(ParameterizedCommand command) {
        Logger logger;
        Object handler;
        block7: {
            String commandId = command.getId();
            handler = HandlerServiceImpl.lookUpHandler(this.context, commandId);
            if (handler == null) {
                return null;
            }
            this.addParmsToContext(command);
            try {
                Object rc = ContextInjectionFactory.invoke((Object)handler, (String)METHOD_CAN_EXECUTE, (IEclipseContext)this.context, (Object)Boolean.TRUE);
                if (Boolean.FALSE.equals(rc)) {
                    return null;
                }
            }
            catch (InvocationTargetException e1) {
                logger = (Logger)this.context.get(Logger.class.getName());
                if (logger == null) break block7;
                logger.error((Throwable)e1);
            }
        }
        try {
            return ContextInjectionFactory.invoke((Object)handler, (String)METHOD_EXECUTE, (IEclipseContext)this.context, null);
        }
        catch (InvocationTargetException e) {
            logger = (Logger)this.context.get(Logger.class.getName());
            if (logger != null) {
                logger.error((Throwable)e);
            }
            return null;
        }
    }

    @Inject
    public void setContext(IEclipseContext c) {
        this.context = c;
    }

    public IEclipseContext getContext() {
        return this.context;
    }
}

