/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.contexts;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.AbstractObjectSupplier;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.InjectorFactory;
import org.eclipse.e4.core.internal.contexts.ContextObjectSupplier;
import org.eclipse.e4.core.internal.contexts.EclipseContext;

public final class ContextInjectionFactory {
    private static final IInjector injector = InjectorFactory.getInjector();

    private ContextInjectionFactory() {
    }

    public static Object inject(Object object, IEclipseContext context) {
        ContextObjectSupplier supplier = ContextObjectSupplier.getObjectSupplier(context, injector);
        injector.inject(object, (AbstractObjectSupplier)supplier);
        return object;
    }

    public static Object invoke(Object object, String methodName, IEclipseContext context) throws InvocationTargetException, InjectionException {
        ContextObjectSupplier supplier = ContextObjectSupplier.getObjectSupplier(context, injector);
        return injector.invoke(object, methodName, (AbstractObjectSupplier)supplier);
    }

    public static Object invoke(Object object, String methodName, IEclipseContext context, Object defaultValue) throws InvocationTargetException {
        ContextObjectSupplier supplier = ContextObjectSupplier.getObjectSupplier(context, injector);
        return injector.invoke(object, methodName, defaultValue, (AbstractObjectSupplier)supplier);
    }

    public static void uninject(Object object, IEclipseContext context) {
        ((EclipseContext)context).removeListenersTo(object);
    }

    public static Object make(Class clazz, IEclipseContext context) throws InvocationTargetException, InstantiationException {
        ContextObjectSupplier supplier = ContextObjectSupplier.getObjectSupplier(context, injector);
        return injector.make(clazz, (AbstractObjectSupplier)supplier);
    }
}

