/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.contexts.ContextChangeEvent;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.IRunAndTrack;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.core.internal.contexts.Computation;
import org.eclipse.e4.core.internal.contexts.IEclipseContextStrategy;
import org.eclipse.e4.core.internal.contexts.ILookupStrategy;
import org.eclipse.e4.core.internal.contexts.IRunAndTrackObject;
import org.eclipse.e4.core.internal.contexts.ISchedulerStrategy;
import org.eclipse.e4.core.internal.contexts.ValueComputation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseContext
implements IEclipseContext,
IDisposable {
    static ThreadLocal<Computation> currentComputation = new ThreadLocal();
    public static boolean DEBUG = false;
    public static boolean DEBUG_VERBOSE = false;
    public static String DEBUG_VERBOSE_NAME = null;
    private DebugSnap snapshot;
    private static final Object[] NO_ARGUMENTS = new Object[0];
    final Map<Computation, Computation> listeners = Collections.synchronizedMap(new LinkedHashMap());
    final Map<LookupKey, ValueComputation> localValueComputations = Collections.synchronizedMap(new HashMap());
    final Map<String, Object> localValues = Collections.synchronizedMap(new HashMap());
    private final IEclipseContextStrategy strategy;
    private ArrayList<String> modifiable;
    private ArrayList<Computation> waiting;

    public EclipseContext(IEclipseContext parent, IEclipseContextStrategy strategy) {
        this.strategy = strategy;
        this.set("parentContext", parent);
        if (parent == null) {
            this.waiting = new ArrayList();
        }
    }

    @Override
    public boolean containsKey(String name) {
        return this.containsKey(name, false);
    }

    @Override
    public boolean containsKey(String name, boolean localOnly) {
        if (this.isSetLocally(name)) {
            return true;
        }
        if (localOnly) {
            return false;
        }
        IEclipseContext parent = (IEclipseContext)this.getLocal("parentContext");
        if (parent != null && parent.containsKey(name)) {
            return true;
        }
        return this.strategy instanceof ILookupStrategy && ((ILookupStrategy)this.strategy).containsKey(name, this);
    }

    public void debugSnap() {
        this.snapshot = new DebugSnap();
        this.snapshot.listeners = new HashSet<Computation>(this.listeners.keySet());
        this.snapshot.localValueComputations = new HashMap<LookupKey, ValueComputation>(this.localValueComputations);
        this.snapshot.localValues = new HashMap<String, Object>(this.localValues);
    }

    public void debugDiff() {
        if (this.snapshot == null) {
            return;
        }
        HashSet<Computation> listenerDiff = new HashSet<Computation>(this.listeners.keySet());
        listenerDiff.removeAll(this.snapshot.listeners);
        listenerDiff = new HashSet<Computation>(listenerDiff);
        System.out.println("Listener diff (" + listenerDiff.size() + " leaked): ");
        Iterator it = listenerDiff.iterator();
        while (it.hasNext()) {
            System.out.println("\t" + it.next());
        }
        HashSet<ValueComputation> computationDiff = new HashSet<ValueComputation>(this.localValueComputations.values());
        computationDiff.removeAll(this.snapshot.localValueComputations.values());
        System.out.println("localValueComputations diff (" + computationDiff.size() + " leaked): ");
        Iterator it2 = computationDiff.iterator();
        while (it2.hasNext()) {
            System.out.println("\t" + it2.next());
        }
        HashSet<Object> valuesDiff = new HashSet<Object>(this.localValues.values());
        valuesDiff.removeAll(this.snapshot.localValues.values());
        System.out.println("localValues diff (" + valuesDiff.size() + " leaked): ");
        Iterator it3 = valuesDiff.iterator();
        while (it3.hasNext()) {
            System.out.println("\t" + it3.next());
        }
    }

    public void dispose() {
        Computation[] ls = this.listeners.keySet().toArray(new Computation[this.listeners.size()]);
        ContextChangeEvent event = EclipseContextFactory.createContextEvent(this, 3, null, null, null);
        int i = ls.length - 1;
        while (i >= 0) {
            ArrayList<Scheduled> scheduled = new ArrayList<Scheduled>();
            ls[i].handleInvalid(event, scheduled);
            this.processScheduled(scheduled);
            --i;
        }
        if (this.strategy instanceof IDisposable) {
            ((IDisposable)this.strategy).dispose();
        }
        this.listeners.clear();
        this.localValueComputations.clear();
        this.localValues.clear();
    }

    @Override
    public Object get(String name) {
        return this.internalGet(this, name, NO_ARGUMENTS, false);
    }

    @Override
    public Object get(String name, Object[] arguments) {
        return this.internalGet(this, name, arguments, false);
    }

    @Override
    public Object getLocal(String name) {
        return this.internalGet(this, name, null, true);
    }

    public Object internalGet(EclipseContext originatingContext, String name, Object[] arguments, boolean local) {
        IEclipseContext parent;
        ValueComputation valueComputation;
        this.trackAccess(name);
        if (DEBUG_VERBOSE) {
            System.out.println("IEC.get(" + name + ", " + arguments + ", " + local + "):" + originatingContext + " for " + this.toString());
        }
        LookupKey lookupKey = null;
        if (this == originatingContext && (valueComputation = this.localValueComputations.get(lookupKey = new LookupKey(name, arguments))) != null) {
            return valueComputation.get(arguments);
        }
        Object result = this.localValues.get(name);
        if (result == null && this.strategy instanceof ILookupStrategy) {
            result = ((ILookupStrategy)this.strategy).lookup(name, originatingContext);
        }
        if (result != null) {
            if (result instanceof IContextFunction) {
                ValueComputation valueComputation2 = new ValueComputation(this, originatingContext, name, (IContextFunction)result);
                if (DEBUG) {
                    System.out.println("created " + valueComputation2);
                }
                if (lookupKey == null) {
                    lookupKey = new LookupKey(name, arguments);
                }
                originatingContext.localValueComputations.put(lookupKey, valueComputation2);
                if (this != originatingContext) {
                    valueComputation2.addDependency(originatingContext, "parentContext");
                }
                result = valueComputation2.get(arguments);
            }
            if (DEBUG_VERBOSE) {
                System.out.println("IEC.get(" + name + "): " + result);
            }
            return result;
        }
        if (!local && (parent = (IEclipseContext)this.getLocal("parentContext")) != null) {
            return ((EclipseContext)parent).internalGet(originatingContext, name, arguments, local);
        }
        return null;
    }

    public void invalidate(String name, int eventType, Object oldValue, List<Scheduled> scheduled) {
        if (DEBUG) {
            System.out.println("invalidating " + this + ',' + name);
        }
        this.removeLocalValueComputations(name);
        this.handleInvalid(name, eventType, oldValue, scheduled);
    }

    void handleInvalid(String name, int eventType, Object oldValue, List<Scheduled> scheduled) {
        Computation[] ls = this.listeners.keySet().toArray(new Computation[this.listeners.size()]);
        ContextChangeEvent event = EclipseContextFactory.createContextEvent(this, eventType, null, name, oldValue);
        int i = 0;
        while (i < ls.length) {
            ls[i].handleInvalid(event, scheduled);
            ++i;
        }
    }

    private boolean isSetLocally(String name) {
        this.trackAccess(name);
        return this.localValues.containsKey(name);
    }

    @Override
    public void remove(String name) {
        if (this.isSetLocally(name)) {
            Object oldValue = this.localValues.remove(name);
            ArrayList<Scheduled> scheduled = new ArrayList<Scheduled>();
            this.invalidate(name, 2, oldValue, scheduled);
            this.processScheduled(scheduled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLocalValueComputations(String name) {
        Map<LookupKey, ValueComputation> map = this.localValueComputations;
        synchronized (map) {
            Iterator<LookupKey> it = this.localValueComputations.keySet().iterator();
            while (it.hasNext()) {
                LookupKey key = it.next();
                if (!key.name.equals(name)) continue;
                ValueComputation removed = this.localValueComputations.get(key);
                if (removed instanceof ValueComputation) {
                    removed.clear(this, name);
                }
                it.remove();
            }
        }
    }

    @Override
    public void runAndTrack(IRunAndTrack runnable, Object[] args) {
        ContextChangeEvent event = EclipseContextFactory.createContextEvent(this, 0, args, null, null);
        TrackableComputationExt computation = new TrackableComputationExt(runnable);
        computation.notify(event);
    }

    protected void processScheduled(List<Scheduled> scheduledList) {
        boolean useScheduler = this.strategy != null && this.strategy instanceof ISchedulerStrategy;
        HashSet<Scheduled> sent = new HashSet<Scheduled>(scheduledList.size());
        for (Scheduled scheduled : scheduledList) {
            if (!sent.add(scheduled)) continue;
            if (useScheduler) {
                ((ISchedulerStrategy)this.strategy).schedule(scheduled.runnable, scheduled.event);
                continue;
            }
            scheduled.runnable.notify(scheduled.event);
        }
    }

    @Override
    public void set(String name, Object value) {
        if ("parentContext".equals(name)) {
            ArrayList<Scheduled> scheduled = new ArrayList<Scheduled>();
            this.handleReparent((EclipseContext)value, scheduled);
            this.localValues.put("parentContext", value);
            this.processScheduled(scheduled);
            return;
        }
        boolean containsKey = this.localValues.containsKey(name);
        Object oldValue = this.localValues.put(name, value);
        if (!containsKey || value != oldValue) {
            if (DEBUG_VERBOSE) {
                System.out.println("IEC.set(" + name + ',' + value + "):" + oldValue + " for " + this.toString());
            }
            ArrayList<Scheduled> scheduled = new ArrayList<Scheduled>();
            this.invalidate(name, 1, oldValue, scheduled);
            this.processScheduled(scheduled);
        }
    }

    @Override
    public void modify(String name, Object value) {
        ArrayList<Scheduled> scheduled = new ArrayList<Scheduled>();
        if (!this.internalModify(name, value, scheduled)) {
            this.set(name, value);
        }
        this.processScheduled(scheduled);
    }

    public boolean internalModify(String name, Object value, List<Scheduled> scheduled) {
        boolean containsKey = this.localValues.containsKey(name);
        if (containsKey) {
            if (!this.checkModifiable(name)) {
                String tmp = "Variable " + name + " is not modifiable in the context " + this.toString();
                throw new IllegalArgumentException(tmp);
            }
            Object oldValue = this.localValues.put(name, value);
            if (value != oldValue) {
                if (DEBUG_VERBOSE) {
                    System.out.println("IEC.set(" + name + ',' + value + "):" + oldValue + " for " + this.toString());
                }
                this.invalidate(name, 1, oldValue, scheduled);
            }
            return true;
        }
        EclipseContext parent = this.getParent();
        if (parent != null) {
            return parent.internalModify(name, value, scheduled);
        }
        return false;
    }

    public EclipseContext getParent() {
        return (EclipseContext)this.localValues.get("parentContext");
    }

    public String toString() {
        Object debugString = this.localValues.get("debugString");
        return debugString instanceof String ? (String)debugString : "Anonymous Context";
    }

    private void trackAccess(String name) {
        Computation computation = currentComputation.get();
        if (computation != null) {
            computation.addDependency(this, name);
        }
    }

    @Override
    public void declareModifiable(String name) {
        if (name == null) {
            return;
        }
        if (this.modifiable == null) {
            this.modifiable = new ArrayList(3);
        }
        this.modifiable.add(name);
        if (this.localValues.containsKey(name)) {
            return;
        }
        this.localValues.put(name, null);
    }

    private boolean checkModifiable(String name) {
        if (this.modifiable == null) {
            return false;
        }
        for (String candidate : this.modifiable) {
            if (!candidate.equals(name)) continue;
            return true;
        }
        return false;
    }

    public void removeListenersTo(Object object) {
        if (object == null) {
            return;
        }
        Computation[] ls = this.listeners.keySet().toArray(new Computation[this.listeners.size()]);
        ContextChangeEvent event = EclipseContextFactory.createContextEvent(this, 4, new Object[]{object}, null, null);
        Computation[] computationArray = ls;
        int n = ls.length;
        int n2 = 0;
        while (n2 < n) {
            Computation computation = computationArray[n2];
            ((IRunAndTrack)((Object)computation)).notify(event);
            ++n2;
        }
    }

    private void handleReparent(EclipseContext newParent, List<Scheduled> scheduled) {
        this.processWaiting();
        Computation[] ls = this.listeners.keySet().toArray(new Computation[this.listeners.size()]);
        HashSet<String> usedNames = new HashSet<String>();
        int i = 0;
        while (i < ls.length) {
            Set<String> listenerNames = ls[i].dependsOnNames(this);
            if (listenerNames != null) {
                usedNames.addAll(listenerNames);
            }
            ++i;
        }
        for (String name : usedNames) {
            Object newValue;
            if (this.localValues.containsKey(name)) continue;
            Object oldValue = this.get(name);
            Object object = newValue = newParent != null ? newParent.get(name) : null;
            if (oldValue == newValue) continue;
            this.invalidate(name, 1, oldValue, scheduled);
        }
        this.localValueComputations.clear();
    }

    @Override
    public void processWaiting() {
        EclipseContext parent = this.getParent();
        if (parent != null) {
            parent.processWaiting();
            return;
        }
        if (this.waiting == null) {
            return;
        }
        Computation[] ls = this.waiting.toArray(new Computation[this.waiting.size()]);
        this.waiting.clear();
        ContextChangeEvent event = EclipseContextFactory.createContextEvent(this, 5, null, null, null);
        int i = 0;
        while (i < ls.length) {
            if (ls[i] instanceof TrackableComputationExt) {
                ((TrackableComputationExt)ls[i]).notify(event);
            }
            ++i;
        }
    }

    public void addWaiting(Computation cp) {
        EclipseContext parent = this.getParent();
        if (parent != null) {
            parent.addWaiting(cp);
            return;
        }
        if (this.waiting == null) {
            this.waiting = new ArrayList();
        }
        this.waiting.add(cp);
    }

    protected EclipseContext getRoot() {
        EclipseContext root;
        EclipseContext current = this;
        do {
            root = current;
        } while ((current = current.getParent()) != null);
        return root;
    }

    static class DebugSnap {
        Set<Computation> listeners = new HashSet<Computation>();
        Map<LookupKey, ValueComputation> localValueComputations = Collections.synchronizedMap(new HashMap());
        Map<String, Object> localValues = Collections.synchronizedMap(new HashMap());

        DebugSnap() {
        }
    }

    static class LookupKey {
        Object[] arguments;
        String name;

        public LookupKey(String name, Object[] arguments) {
            this.name = name;
            this.arguments = arguments;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LookupKey other = (LookupKey)obj;
            if (!Arrays.equals(this.arguments, other.arguments)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int result = 1;
            result *= 31;
            if (this.arguments != null) {
                int i = 0;
                while (i < this.arguments.length) {
                    Object arg = this.arguments[i];
                    result = 31 * result + (arg == null ? 0 : arg.hashCode());
                    ++i;
                }
            }
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public String toString() {
            return "Key(" + this.name + ',' + Arrays.asList(this.arguments) + ')';
        }
    }

    static class Scheduled {
        public IRunAndTrack runnable;
        public ContextChangeEvent event;

        public Scheduled(IRunAndTrack runnable, ContextChangeEvent event) {
            this.runnable = runnable;
            this.event = event;
        }

        public int hashCode() {
            return 31 * (31 + this.event.hashCode()) + this.runnable.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Scheduled other = (Scheduled)obj;
            if (!this.event.equals(other.event)) {
                return false;
            }
            return this.runnable.equals(other.runnable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TrackableComputationExt
    extends Computation
    implements IRunAndTrack {
        private ContextChangeEvent cachedEvent;
        private IRunAndTrack runnable;

        @Override
        public int hashCode() {
            return 31 + (this.runnable == null ? 0 : this.runnable.hashCode());
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TrackableComputationExt other = (TrackableComputationExt)obj;
            return !(this.runnable == null ? other.runnable != null : !this.runnable.equals(other.runnable));
        }

        public TrackableComputationExt(IRunAndTrack runnable) {
            this.runnable = runnable;
        }

        public Object getObject() {
            if (this.runnable instanceof IRunAndTrackObject) {
                return ((IRunAndTrackObject)this.runnable).getObject();
            }
            return null;
        }

        @Override
        protected final void doHandleInvalid(ContextChangeEvent event, List<Scheduled> scheduledList) {
            int eventType = event.getEventType();
            if (eventType == 0 || eventType == 3) {
                this.notify(event);
            } else {
                scheduledList.add(new Scheduled(this, event));
            }
        }

        @Override
        public boolean notify(ContextChangeEvent event) {
            int eventType = event.getEventType();
            if (this.runnable instanceof IRunAndTrackObject && ((IRunAndTrackObject)this.runnable).batchProcess() && (eventType == 1 || eventType == 2)) {
                this.cachedEvent = event;
                EclipseContext eventsContext = (EclipseContext)event.getContext();
                eventsContext.addWaiting(this);
                return true;
            }
            Computation oldComputation = currentComputation.get();
            currentComputation.set(this);
            boolean result = true;
            try {
                if (this.cachedEvent != null) {
                    result = this.runnable.notify(this.cachedEvent);
                    this.cachedEvent = null;
                }
                if (eventType != 5) {
                    result = this.runnable.notify(event);
                }
            }
            finally {
                currentComputation.set(oldComputation);
            }
            EclipseContext eventsContext = (EclipseContext)event.getContext();
            if (result) {
                this.startListening(eventsContext);
            } else {
                this.removeAll(eventsContext);
            }
            return result;
        }

        public String toString() {
            return "TrackableComputationExt(" + this.runnable + ')';
        }
    }
}

