/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Qualifier;
import org.eclipse.e4.core.di.annotations.GroupUpdates;
import org.eclipse.e4.core.di.annotations.PostConstruct;
import org.eclipse.e4.core.di.annotations.PreDestroy;
import org.eclipse.e4.core.internal.di.InjectionProperties;

public class AnnotationsSupport {
    public InjectionProperties getInjectProperties(Field field) {
        InjectionProperties property = this.getInjectProperties(field.getAnnotations(), field.getGenericType());
        return property;
    }

    public InjectionProperties getInjectProperties(Method method) {
        return this.getInjectProperties(method.getAnnotations(), null);
    }

    public InjectionProperties getInjectProperties(Constructor constructor) {
        return this.getInjectProperties(constructor.getAnnotations(), null);
    }

    public InjectionProperties[] getInjectParamsProperties(Constructor constructor) {
        Annotation[][] annotations = constructor.getParameterAnnotations();
        Type[] logicalParams = constructor.getGenericParameterTypes();
        Class<?>[] compilerParams = constructor.getParameterTypes();
        if (compilerParams.length > logicalParams.length) {
            Type[] tmp = new Type[compilerParams.length];
            System.arraycopy(compilerParams, 0, tmp, 0, compilerParams.length - logicalParams.length);
            System.arraycopy(logicalParams, 0, tmp, compilerParams.length - logicalParams.length, logicalParams.length);
            logicalParams = tmp;
        }
        return this.getInjectProperties(annotations, logicalParams);
    }

    public InjectionProperties[] getInjectParamProperties(Method method) {
        Annotation[][] annotations = method.getParameterAnnotations();
        Type[] params = method.getGenericParameterTypes();
        return this.getInjectProperties(annotations, params);
    }

    private InjectionProperties[] getInjectProperties(Annotation[][] annotations, Type[] params) {
        InjectionProperties[] result = new InjectionProperties[params.length];
        int i = 0;
        while (i < params.length) {
            result[i] = this.getInjectProperties(annotations[i], params[i]);
            ++i;
        }
        return result;
    }

    private InjectionProperties getInjectProperties(Annotation[] annotations, Type param) {
        boolean inject = false;
        String named = null;
        String qualifier = null;
        String handlesEvent = null;
        boolean eventHeadless = true;
        ArrayList<Annotation> qualifiers = new ArrayList<Annotation>();
        boolean groupUpdates = false;
        if (annotations != null) {
            Annotation[] annotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (annotation instanceof Inject) {
                    inject = true;
                } else if (annotation instanceof GroupUpdates) {
                    groupUpdates = true;
                } else if (annotation.annotationType().isAnnotationPresent(Qualifier.class)) {
                    qualifiers.add(annotation);
                    Class<? extends Annotation> type = annotation.annotationType();
                    if (type instanceof Class) {
                        qualifier = type.getName();
                    }
                }
                ++n2;
            }
        }
        String injectName = named != null ? named : qualifier;
        InjectionProperties result = new InjectionProperties(inject, injectName);
        if (!qualifiers.isEmpty()) {
            Annotation[] qualifiersArray = new Annotation[qualifiers.size()];
            qualifiers.toArray(qualifiersArray);
            result.setQualifiers(qualifiersArray);
        }
        if (handlesEvent != null) {
            result.setHandlesEvent(handlesEvent);
            result.setEventHeadless(eventHeadless);
        }
        if (groupUpdates) {
            result.setGroupUpdates(true);
        }
        return result;
    }

    public boolean isPostConstruct(Method method) {
        return method.isAnnotationPresent(PostConstruct.class);
    }

    public boolean isPreDestory(Method method) {
        return method.isAnnotationPresent(PreDestroy.class);
    }
}

