/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.e4.core.di.AbstractObjectSupplier;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.IObjectDescriptor;
import org.eclipse.e4.core.di.ObjectDescriptorFactory;
import org.eclipse.e4.core.internal.di.InjectionProperties;
import org.eclipse.e4.core.internal.di.Requestor;

public class FieldRequestor
extends Requestor {
    private final Field field;

    public FieldRequestor(Field field, IInjector injector, AbstractObjectSupplier primarySupplier, Object requestingObject, boolean track, boolean groupUpdates, boolean optional) {
        super(injector, primarySupplier, requestingObject, track, groupUpdates, optional);
        this.field = field;
    }

    public Object execute() throws InvocationTargetException, InstantiationException {
        this.setField(this.field, this.actualArgs[0]);
        return null;
    }

    public IObjectDescriptor[] getDependentObjects() {
        InjectionProperties properties = this.annotationSupport.getInjectProperties(this.field);
        IObjectDescriptor objectDescriptor = ObjectDescriptorFactory.make(this.field.getGenericType(), properties.getQualifiers());
        return new IObjectDescriptor[]{objectDescriptor};
    }

    private boolean setField(Field field, Object value) {
        Object userObject = this.getRequestingObject();
        if (userObject == null) {
            return false;
        }
        boolean wasAccessible = true;
        if (!field.isAccessible()) {
            field.setAccessible(true);
            wasAccessible = false;
        }
        try {
            try {
                field.set(userObject, value);
            }
            catch (IllegalArgumentException e) {
                this.logError(field, (Exception)e);
                if (!wasAccessible) {
                    field.setAccessible(false);
                }
                return false;
            }
            catch (IllegalAccessException e) {
                this.logError(field, (Exception)e);
                if (!wasAccessible) {
                    field.setAccessible(false);
                }
                return false;
            }
        }
        finally {
            if (!wasAccessible) {
                field.setAccessible(false);
            }
        }
        return true;
    }
}

