/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.annotation.Annotation;
import org.eclipse.e4.core.di.annotations.Optional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionProperties {
    private boolean inject;
    private String propertyToInject;
    private Object provider;
    private Annotation[] qualifiers;
    private String handlesEvent;
    private boolean eventHeadless;
    private boolean groupUpdates = false;

    public InjectionProperties(boolean inject, String propertyToInject) {
        this.inject = inject;
        this.propertyToInject = propertyToInject;
    }

    public String getPropertyName() {
        return this.propertyToInject;
    }

    public boolean isOptional() {
        return this.hasQualifier(Optional.class);
    }

    private boolean hasQualifier(Class<? extends Annotation> clazz) {
        if (clazz == null) {
            return false;
        }
        if (this.qualifiers == null) {
            return false;
        }
        Annotation[] annotationArray = this.qualifiers;
        int n = this.qualifiers.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().equals(clazz)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean shouldInject() {
        return this.inject;
    }

    public void setInject(boolean inject) {
        this.inject = inject;
    }

    public void setProvider(Object provider) {
        this.provider = provider;
    }

    public Object getProvider() {
        return this.provider;
    }

    public void setQualifiers(Annotation[] qualifiers) {
        this.qualifiers = qualifiers;
    }

    public Annotation[] getQualifiers() {
        return this.qualifiers;
    }

    public void setHandlesEvent(String handlesEvent) {
        this.handlesEvent = handlesEvent;
    }

    public String getHandlesEvent() {
        return this.handlesEvent;
    }

    public void setEventHeadless(boolean eventHeadless) {
        this.eventHeadless = eventHeadless;
    }

    public boolean getEventHeadless() {
        return this.eventHeadless;
    }

    public void setGroupUpdates(boolean groupUpdates) {
        this.groupUpdates = groupUpdates;
    }

    public boolean groupUpdates() {
        return this.groupUpdates;
    }
}

