/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.AbstractObjectSupplier;
import org.eclipse.e4.core.di.IBinding;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.IObjectDescriptor;
import org.eclipse.e4.core.di.IRequestor;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.ObjectDescriptorFactory;
import org.eclipse.e4.core.internal.di.AnnotationsSupport;
import org.eclipse.e4.core.internal.di.Binding;
import org.eclipse.e4.core.internal.di.ConstructorRequestor;
import org.eclipse.e4.core.internal.di.FieldRequestor;
import org.eclipse.e4.core.internal.di.InjectionProperties;
import org.eclipse.e4.core.internal.di.MethodRequestor;
import org.eclipse.e4.core.internal.di.ProviderImpl;
import org.eclipse.e4.core.internal.di.Requestor;
import org.eclipse.e4.core.internal.di.osgi.ProviderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectorImpl
implements IInjector {
    private static final String JAVA_OBJECT = "java.lang.Object";
    private static final AnnotationsSupport annotationSupport = new AnnotationsSupport();
    private Map<String, AbstractObjectSupplier> extendedSuppliers = new HashMap<String, AbstractObjectSupplier>();
    private Map<AbstractObjectSupplier, List<WeakReference<?>>> injectedObjects = new HashMap();
    private HashMap<Class<?>, Object> singletonCache = new HashMap();
    private Map<Class<?>, Set<IBinding>> bindings = new HashMap();

    @Override
    public boolean inject(Object object, AbstractObjectSupplier objectSupplier) {
        ArrayList<Requestor> requestors = new ArrayList<Requestor>();
        this.processClassHierarchy(object, objectSupplier, false, true, true, requestors);
        if (!this.resolveRequestorArgs(requestors, objectSupplier, false)) {
            return false;
        }
        for (Requestor requestor : requestors) {
            try {
                if (!requestor.isResolved()) continue;
                requestor.execute();
            }
            catch (InvocationTargetException invocationTargetException) {
                this.logError("Injection failed for the object \"" + object.toString() + "\". Unable to execute \"" + requestor.toString() + "\"");
                return false;
            }
            catch (InstantiationException instantiationException) {
                this.logError("Injection failed for the object \"" + object.toString() + "\". Unable to execute \"" + requestor.toString() + "\"");
                return false;
            }
        }
        this.rememberInjectedObject(object, objectSupplier);
        try {
            this.processPostConstruct(object, object.getClass(), objectSupplier, new ArrayList(5));
        }
        catch (InvocationTargetException e) {
            this.logError("Injection failed for the object \"" + object.toString() + "\". Unable to process post-construct methods.", e);
            return false;
        }
        catch (InstantiationException e) {
            this.logError("Injection failed for the object \"" + object.toString() + "\". Unable to process post-construct methods.", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberInjectedObject(Object object, AbstractObjectSupplier objectSupplier) {
        Map<AbstractObjectSupplier, List<WeakReference<?>>> map = this.injectedObjects;
        synchronized (map) {
            List<Object> list;
            if (!this.injectedObjects.containsKey(objectSupplier)) {
                list = new ArrayList();
                this.injectedObjects.put(objectSupplier, list);
            } else {
                list = this.injectedObjects.get(objectSupplier);
            }
            for (WeakReference weakReference : list) {
                if (object != weakReference.get()) continue;
                return;
            }
            list.add(new WeakReference<Object>(object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean forgetInjectedObject(Object object, AbstractObjectSupplier objectSupplier) {
        Map<AbstractObjectSupplier, List<WeakReference<?>>> map = this.injectedObjects;
        synchronized (map) {
            block7: {
                block6: {
                    if (this.injectedObjects.containsKey(objectSupplier)) break block6;
                    return false;
                }
                List<WeakReference<?>> list = this.injectedObjects.get(objectSupplier);
                Iterator<WeakReference<?>> i = list.iterator();
                if (!i.hasNext()) break block7;
                WeakReference<?> ref = i.next();
                if (object == ref.get()) {
                    i.remove();
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WeakReference<?>> forgetSupplier(AbstractObjectSupplier objectSupplier) {
        Map<AbstractObjectSupplier, List<WeakReference<?>>> map = this.injectedObjects;
        synchronized (map) {
            block4: {
                if (this.injectedObjects.containsKey(objectSupplier)) break block4;
                return null;
            }
            return this.injectedObjects.remove(objectSupplier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WeakReference<?>> getSupplierObjects(AbstractObjectSupplier objectSupplier) {
        Map<AbstractObjectSupplier, List<WeakReference<?>>> map = this.injectedObjects;
        synchronized (map) {
            block4: {
                if (this.injectedObjects.containsKey(objectSupplier)) break block4;
                return null;
            }
            return this.injectedObjects.get(objectSupplier);
        }
    }

    @Override
    public boolean uninject(Object object, AbstractObjectSupplier objectSupplier) {
        if (!this.forgetInjectedObject(object, objectSupplier)) {
            return false;
        }
        ArrayList<Requestor> requestors = new ArrayList<Requestor>();
        this.processClassHierarchy(object, objectSupplier, false, true, false, requestors);
        if (!this.resolveRequestorArgs(requestors, null, true)) {
            return false;
        }
        for (Requestor requestor : requestors) {
            try {
                requestor.execute();
            }
            catch (InvocationTargetException invocationTargetException) {
                this.logError("Uninjection failed for the object \"" + object.toString() + "\". Unable to execute \"" + requestor.toString() + "\"");
                return false;
            }
            catch (InstantiationException instantiationException) {
                this.logError("Uninjection failed for the object \"" + object.toString() + "\". Unable to execute \"" + requestor.toString() + "\"");
                return false;
            }
        }
        return true;
    }

    @Override
    public Object invoke(Object object, String methodName, AbstractObjectSupplier objectSupplier) throws InvocationTargetException, InjectionException {
        Object result = this.invokeUsingClass(object, object.getClass(), methodName, IInjector.NOT_A_VALUE, objectSupplier);
        if (result == IInjector.NOT_A_VALUE) {
            throw new InjectionException("Unable to find matching method to invoke");
        }
        return result;
    }

    @Override
    public Object invoke(Object object, String methodName, Object defaultValue, AbstractObjectSupplier objectSupplier) throws InvocationTargetException {
        return this.invokeUsingClass(object, object.getClass(), methodName, defaultValue, objectSupplier);
    }

    private Object invokeUsingClass(Object userObject, Class<?> currentClass, String methodName, Object defaultValue, AbstractObjectSupplier objectSupplier) throws InvocationTargetException {
        Method[] methods = currentClass.getDeclaredMethods();
        int j = 0;
        while (j < methods.length) {
            Method method = methods[j];
            if (method.getName().equals(methodName)) {
                MethodRequestor requestor = new MethodRequestor(method, this, objectSupplier, userObject, false, false, true);
                Object[] actualArgs = this.resolveArgs(requestor, objectSupplier, false);
                int unresolved = this.unresolved(actualArgs);
                if (unresolved != -1) {
                    this.logError("Injection failed for object \"" + requestor.getRequestingObject().toString() + "\". Unable to find value for \"" + requestor.getDependentObjects()[unresolved] + "\"");
                    return null;
                }
                requestor.setResolvedArgs(actualArgs);
                try {
                    return requestor.execute();
                }
                catch (InstantiationException e) {
                    this.logError("Exception occured in the injected method " + method.getName(), e);
                    return null;
                }
            }
            ++j;
        }
        Class<?> superClass = currentClass.getSuperclass();
        if (superClass == null) {
            return defaultValue;
        }
        return this.invokeUsingClass(userObject, superClass, methodName, defaultValue, objectSupplier);
    }

    @Override
    public Object make(Class<?> clazz, AbstractObjectSupplier objectSupplier) throws InvocationTargetException, InstantiationException {
        IObjectDescriptor descriptor = ObjectDescriptorFactory.make(clazz, null);
        return this.make(descriptor, objectSupplier);
    }

    @Override
    public Object make(IObjectDescriptor descriptor, AbstractObjectSupplier objectSupplier) throws InvocationTargetException, InstantiationException {
        IBinding binding = this.findBinding(descriptor);
        if (binding == null) {
            Class<?> desiredClass = descriptor.getElementClass();
            return this.internalMake(desiredClass, objectSupplier);
        }
        return this.internalMake(binding.getImplementationClass(), objectSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object internalMake(Class<?> clazz, AbstractObjectSupplier objectSupplier) throws InvocationTargetException, InstantiationException {
        boolean isSingleton = clazz.isAnnotationPresent(Singleton.class);
        if (isSingleton) {
            HashMap<Class<?>, Object> hashMap = this.singletonCache;
            synchronized (hashMap) {
                if (this.singletonCache.containsKey(clazz)) {
                    return this.singletonCache.get(clazz);
                }
            }
        }
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        ArrayList<Constructor> sortedConstructors = new ArrayList<Constructor>(constructors.length);
        Constructor<?>[] constructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor constructor = constructorArray[n2];
            sortedConstructors.add(constructor);
            ++n2;
        }
        Collections.sort(sortedConstructors, new Comparator<Constructor<?>>(){

            @Override
            public int compare(Constructor<?> c1, Constructor<?> c2) {
                int l1 = c1.getParameterTypes().length;
                int l2 = c2.getParameterTypes().length;
                return l2 - l1;
            }
        });
        for (Constructor constructor : sortedConstructors) {
            ConstructorRequestor requestor;
            Object[] actualArgs;
            InjectionProperties cProps;
            int modifiers = constructor.getModifiers();
            if ((modifiers & 2) != 0 || (modifiers & 4) != 0 || !(cProps = annotationSupport.getInjectProperties(constructor)).shouldInject() && constructor.getParameterTypes().length != 0 || this.unresolved(actualArgs = this.resolveArgs(requestor = new ConstructorRequestor(constructor, this, objectSupplier), objectSupplier, false)) != -1) continue;
            requestor.setResolvedArgs(actualArgs);
            Object newInstance = requestor.execute();
            if (newInstance == null) continue;
            this.inject(newInstance, objectSupplier);
            if (isSingleton) {
                HashMap<Class<?>, Object> hashMap = this.singletonCache;
                synchronized (hashMap) {
                    this.singletonCache.put(clazz, newInstance);
                }
            }
            return newInstance;
        }
        this.logError("Could not find satisfiable constructor in class " + clazz.getName());
        return null;
    }

    @Override
    public boolean injectStatic(Class<?> clazz, AbstractObjectSupplier objectSupplier) {
        Object object;
        try {
            object = this.make(clazz, objectSupplier);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return false;
        }
        ArrayList<Requestor> requestors = new ArrayList<Requestor>();
        this.processClassHierarchy(object, objectSupplier, true, true, true, requestors);
        if (!this.resolveRequestorArgs(requestors, objectSupplier, false)) {
            return false;
        }
        for (Requestor requestor : requestors) {
            try {
                requestor.execute();
            }
            catch (InvocationTargetException invocationTargetException) {
                this.logError("Injection failed for the object \"" + object.toString() + "\". Unable to execute \"" + requestor.toString() + "\"");
                return false;
            }
            catch (InstantiationException instantiationException) {
                this.logError("Injection failed for the object \"" + object.toString() + "\". Unable to execute \"" + requestor.toString() + "\"");
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean update(IRequestor[] requestors, AbstractObjectSupplier objectSupplier) {
        IRequestor requestor;
        ArrayList<Requestor> list = new ArrayList<Requestor>(requestors.length);
        IRequestor[] iRequestorArray = requestors;
        int n = requestors.length;
        int n2 = 0;
        while (n2 < n) {
            requestor = iRequestorArray[n2];
            list.add((Requestor)requestor);
            ++n2;
        }
        this.resolveRequestorArgs(list, objectSupplier, true);
        iRequestorArray = requestors;
        n = requestors.length;
        n2 = 0;
        while (n2 < n) {
            requestor = iRequestorArray[n2];
            try {
                ((Requestor)requestor).execute();
            }
            catch (InvocationTargetException invocationTargetException) {
                this.logError("Injection failed for the object \"" + requestor.getRequestingObject().toString() + "\". Unable to execute \"" + requestor.toString() + "\"");
                return false;
            }
            catch (InstantiationException instantiationException) {
                this.logError("Injection failed for the object \"" + requestor.getRequestingObject().toString() + "\". Unable to execute \"" + requestor.toString() + "\"");
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean disposed(AbstractObjectSupplier objectSupplier) {
        List<WeakReference<?>> references = this.getSupplierObjects(objectSupplier);
        if (references == null) {
            return true;
        }
        Object[] objects = new Object[references.size()];
        int count = 0;
        for (WeakReference<?> ref : references) {
            Object object = ref.get();
            if (object == null) continue;
            objects[count] = object;
            ++count;
        }
        int i = 0;
        while (i < count) {
            this.processPreDestory(objects[i], objectSupplier, objects[i].getClass(), new ArrayList(5));
            this.uninject(objects[i], objectSupplier);
            ++i;
        }
        this.forgetSupplier(objectSupplier);
        return true;
    }

    private void processPreDestory(Object userObject, AbstractObjectSupplier objectSupplier, Class<?> objectClass, ArrayList<Class<?>> classHierarchy) {
        Class<?> superClass = objectClass.getSuperclass();
        if (superClass != null && !superClass.getName().equals(JAVA_OBJECT)) {
            classHierarchy.add(objectClass);
            this.processPreDestory(userObject, objectSupplier, superClass, classHierarchy);
            classHierarchy.remove(objectClass);
        }
        Method[] methods = objectClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (method.getParameterTypes().length <= 0 && annotationSupport.isPreDestory(method) && !this.isOverridden(method, classHierarchy)) {
                MethodRequestor requestor = new MethodRequestor(method, this, objectSupplier, userObject, false, false, false);
                try {
                    requestor.execute();
                }
                catch (InvocationTargetException e) {
                    this.logError("Unable to call pre-destory method \"" + method.getName() + "\"", e);
                }
                catch (InstantiationException e) {
                    this.logError("Unable to call pre-destory method \"" + method.getName() + "\"", e);
                }
            }
            ++i;
        }
        if (userObject instanceof IDisposable) {
            ((IDisposable)userObject).dispose();
        }
    }

    private boolean resolveRequestorArgs(ArrayList<Requestor> requestors, AbstractObjectSupplier objectSupplier, boolean fillNulls) {
        for (Requestor requestor : requestors) {
            Object[] actualArgs = this.resolveArgs(requestor, objectSupplier, fillNulls);
            int unresolved = this.unresolved(actualArgs);
            if (unresolved == -1) {
                requestor.setResolvedArgs(actualArgs);
                continue;
            }
            if (requestor.isOptional()) {
                requestor.setResolvedArgs(null);
                continue;
            }
            this.logError("Injection failed for object \"" + requestor.getRequestingObject().toString() + "\". Unable to find value for \"" + requestor.getDependentObjects()[unresolved] + "\"");
            return false;
        }
        return true;
    }

    private Object[] resolveArgs(Requestor requestor, AbstractObjectSupplier objectSupplier, boolean fillNulls) {
        IObjectDescriptor[] descriptors = requestor.getDependentObjects();
        Object[] actualArgs = new Object[descriptors.length];
        int i = 0;
        while (i < actualArgs.length) {
            actualArgs[i] = NOT_A_VALUE;
            ++i;
        }
        i = 0;
        while (i < actualArgs.length) {
            Class<?> providerClass = this.getProviderType(descriptors[i].getElementType());
            if (providerClass != null) {
                actualArgs[i] = new ProviderImpl(descriptors[i], this, objectSupplier);
                descriptors[i] = null;
            }
            ++i;
        }
        if (objectSupplier != null) {
            Object[] primarySupplierArgs = objectSupplier.get(descriptors, (IRequestor)requestor);
            int i2 = 0;
            while (i2 < actualArgs.length) {
                if (descriptors[i2] != null && primarySupplierArgs[i2] != NOT_A_VALUE) {
                    actualArgs[i2] = primarySupplierArgs[i2];
                    descriptors[i2] = null;
                }
                ++i2;
            }
        }
        i = 0;
        while (i < actualArgs.length) {
            Object result;
            AbstractObjectSupplier extendedSupplier;
            if (descriptors[i] != null && (extendedSupplier = this.findExtendedSupplier(descriptors[i])) != null && (result = extendedSupplier.get(descriptors[i], (IRequestor)requestor)) != NOT_A_VALUE) {
                actualArgs[i] = result;
                descriptors[i] = null;
            }
            ++i;
        }
        i = 0;
        while (i < actualArgs.length) {
            IBinding binding;
            if (descriptors[i] != null && (binding = this.findBinding(descriptors[i])) != null) {
                try {
                    actualArgs[i] = this.internalMake(binding.getImplementationClass(), objectSupplier);
                }
                catch (InvocationTargetException e) {
                    this.logError("Unable to create object for class \"" + binding.getImplementationClass() + "\".", e);
                }
                catch (InstantiationException e) {
                    this.logError("Unable to create object for class \"" + binding.getImplementationClass() + "\".", e);
                }
            }
            ++i;
        }
        descriptors = requestor.getDependentObjects();
        i = 0;
        while (i < descriptors.length) {
            Class<?> descriptorsClass;
            if (actualArgs[i] != null && actualArgs[i] != IInjector.NOT_A_VALUE && !(descriptorsClass = descriptors[i].getElementClass()).isAssignableFrom(actualArgs[i].getClass())) {
                actualArgs[i] = IInjector.NOT_A_VALUE;
            }
            if (descriptors[i].isOptional() && actualArgs[i] == IInjector.NOT_A_VALUE) {
                actualArgs[i] = null;
            } else if (fillNulls && actualArgs[i] == IInjector.NOT_A_VALUE) {
                actualArgs[i] = null;
            }
            ++i;
        }
        return actualArgs;
    }

    private AbstractObjectSupplier findExtendedSupplier(IObjectDescriptor descriptor) {
        Annotation[] qualifiers = descriptor.getQualifiers();
        if (qualifiers == null) {
            return null;
        }
        Annotation[] annotationArray = qualifiers;
        int n = qualifiers.length;
        int n2 = 0;
        while (n2 < n) {
            String key;
            AbstractObjectSupplier supplier;
            Annotation qualifier = annotationArray[n2];
            Class<? extends Annotation> type = qualifier.annotationType();
            if (type instanceof Class && (supplier = ProviderHelper.findProvider(key = type.getName())) != null) {
                return supplier;
            }
            ++n2;
        }
        return null;
    }

    private int unresolved(Object[] actualArgs) {
        int i = 0;
        while (i < actualArgs.length) {
            if (actualArgs[i] == IInjector.NOT_A_VALUE) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void processClassHierarchy(Object userObject, AbstractObjectSupplier objectSupplier, boolean processStatic, boolean track, boolean normalOrder, List<Requestor> requestors) {
        this.processClass(userObject, objectSupplier, userObject == null ? null : userObject.getClass(), new ArrayList(5), processStatic, track, normalOrder, requestors);
    }

    private void processClass(Object userObject, AbstractObjectSupplier objectSupplier, Class<?> objectsClass, ArrayList<Class<?>> classHierarchy, boolean processStatic, boolean track, boolean normalOrder, List<Requestor> requestors) {
        Class<?> superClass;
        if (objectsClass != null && !(superClass = objectsClass.getSuperclass()).getName().equals(JAVA_OBJECT)) {
            classHierarchy.add(objectsClass);
            this.processClass(userObject, objectSupplier, superClass, classHierarchy, processStatic, track, normalOrder, requestors);
            classHierarchy.remove(objectsClass);
        }
        if (normalOrder) {
            this.processFields(userObject, objectSupplier, objectsClass, processStatic, track, requestors);
            this.processMethods(userObject, objectSupplier, objectsClass, classHierarchy, processStatic, track, requestors);
        } else {
            this.processMethods(userObject, objectSupplier, objectsClass, classHierarchy, processStatic, track, requestors);
            this.processFields(userObject, objectSupplier, objectsClass, processStatic, track, requestors);
        }
    }

    private void processFields(Object userObject, AbstractObjectSupplier objectSupplier, Class<?> objectsClass, boolean processStatic, boolean track, List<Requestor> requestors) {
        Field[] fields = objectsClass.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            InjectionProperties properties;
            Field field = fields[i];
            if (Modifier.isStatic(field.getModifiers()) == processStatic && (properties = annotationSupport.getInjectProperties(field)).shouldInject()) {
                requestors.add(new FieldRequestor(field, this, objectSupplier, userObject, track, properties.groupUpdates(), properties.isOptional()));
            }
            ++i;
        }
    }

    private void processMethods(Object userObject, AbstractObjectSupplier objectSupplier, Class<?> objectsClass, ArrayList<Class<?>> classHierarchy, boolean processStatic, boolean track, List<Requestor> requestors) {
        Method[] methods = objectsClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            InjectionProperties properties;
            Method method = methods[i];
            if (!this.isOverridden(method, classHierarchy) && Modifier.isStatic(method.getModifiers()) == processStatic && (properties = annotationSupport.getInjectProperties(method)).shouldInject()) {
                requestors.add(new MethodRequestor(method, this, objectSupplier, userObject, track, properties.groupUpdates(), properties.isOptional()));
            }
            ++i;
        }
    }

    private boolean isOverridden(Method method, ArrayList<Class<?>> classHierarchy) {
        int modifiers = method.getModifiers();
        if (Modifier.isPrivate(modifiers)) {
            return false;
        }
        if (Modifier.isStatic(modifiers)) {
            return false;
        }
        boolean isDefault = !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers);
        for (Class<?> subClass : classHierarchy) {
            try {
                subClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
            }
            catch (SecurityException securityException) {
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            if (isDefault) {
                Package originalPackage = method.getDeclaringClass().getPackage();
                Package overridePackage = subClass.getPackage();
                if (originalPackage == null && overridePackage == null) {
                    return true;
                }
                if (originalPackage == null || overridePackage == null) {
                    return false;
                }
                if (!originalPackage.equals(overridePackage)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private void processPostConstruct(Object userObject, Class<?> objectClass, AbstractObjectSupplier objectSupplier, ArrayList<Class<?>> classHierarchy) throws InvocationTargetException, InstantiationException {
        Class<?> superClass = objectClass.getSuperclass();
        if (superClass != null && !superClass.getName().equals(JAVA_OBJECT)) {
            classHierarchy.add(objectClass);
            this.processPostConstruct(userObject, superClass, objectSupplier, classHierarchy);
            classHierarchy.remove(objectClass);
        }
        Method[] methods = objectClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (this.isPostConstruct(method) && !this.isOverridden(method, classHierarchy)) {
                MethodRequestor requestor = new MethodRequestor(method, this, objectSupplier, userObject, false, false, false);
                Object[] actualArgs = this.resolveArgs(requestor, objectSupplier, false);
                int unresolved = this.unresolved(actualArgs);
                if (unresolved != -1) {
                    this.logError("Injection failed for object \"" + requestor.getRequestingObject().toString() + "\". Unable to find value for \"" + requestor.getDependentObjects()[unresolved] + "\"");
                } else {
                    requestor.setResolvedArgs(actualArgs);
                    try {
                        requestor.execute();
                    }
                    catch (InvocationTargetException e) {
                        this.logError("Unable to call post-construct method \"" + method.getName() + "\"", e);
                    }
                    catch (InstantiationException e) {
                        this.logError("Unable to call post-construct method \"" + method.getName() + "\"", e);
                    }
                }
            }
            ++i;
        }
    }

    private boolean isPostConstruct(Method method) {
        return annotationSupport.isPostConstruct(method);
    }

    private Class<?> getProviderType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        Type rawType = ((ParameterizedType)type).getRawType();
        if (!(rawType instanceof Class)) {
            return null;
        }
        boolean isProvider = ((Class)rawType).equals(Provider.class);
        if (!isProvider) {
            return null;
        }
        Type[] actualTypes = ((ParameterizedType)type).getActualTypeArguments();
        if (actualTypes.length != 1) {
            return null;
        }
        if (!(actualTypes[0] instanceof Class)) {
            return null;
        }
        return (Class)actualTypes[0];
    }

    @Override
    public IBinding addBinding(Class<?> clazz) {
        return this.addBinding(new Binding(clazz, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinding addBinding(IBinding binding) {
        Class<?> clazz = binding.getDescribedClass();
        Map<Class<?>, Set<IBinding>> map = this.bindings;
        synchronized (map) {
            if (this.bindings.containsKey(clazz)) {
                Set<IBinding> collection = this.bindings.get(clazz);
                String desiredQualifierName = binding.getQualifierName();
                Iterator<IBinding> i = collection.iterator();
                while (i.hasNext()) {
                    IBinding collectionBinding = i.next();
                    if (!this.eq(collectionBinding.getQualifierName(), desiredQualifierName)) continue;
                    i.remove();
                    break;
                }
                collection.add(binding);
            } else {
                HashSet<IBinding> collection = new HashSet<IBinding>(1);
                collection.add(binding);
                this.bindings.put(clazz, collection);
            }
        }
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBinding findBinding(IObjectDescriptor descriptor) {
        Class<?> desiredClass = this.getProviderType(descriptor.getElementType());
        if (desiredClass == null) {
            desiredClass = descriptor.getElementClass();
        }
        Map<Class<?>, Set<IBinding>> map = this.bindings;
        synchronized (map) {
            block10: {
                if (this.bindings.containsKey(desiredClass)) break block10;
                return null;
            }
            Set<IBinding> collection = this.bindings.get(desiredClass);
            String desiredQualifierName = null;
            if (descriptor.hasQualifier(Named.class)) {
                Object namedAnnotation = descriptor.getQualifier(Named.class);
                desiredQualifierName = ((Named)namedAnnotation).value();
            } else {
                Annotation[] annotations = descriptor.getQualifiers();
                if (annotations != null) {
                    Annotation[] annotationArray = annotations;
                    if (annotations.length != 0) {
                        Annotation annotation = annotationArray[0];
                        desiredQualifierName = annotation.annotationType().getName();
                    }
                }
            }
            for (IBinding collectionBinding : collection) {
                if (!this.eq(collectionBinding.getQualifierName(), desiredQualifierName)) continue;
                return collectionBinding;
            }
        }
        return null;
    }

    private boolean eq(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    private void logError(String msg) {
        this.logError(msg, new InjectionException());
    }

    private void logError(String msg, Throwable e) {
        if (msg != null) {
            System.err.println(msg);
        }
        if (e != null) {
            e.printStackTrace();
        }
    }
}

