/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.eclipse.e4.core.di.AbstractObjectSupplier;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.IObjectDescriptor;
import org.eclipse.e4.core.di.ObjectDescriptorFactory;
import org.eclipse.e4.core.internal.di.InjectionProperties;
import org.eclipse.e4.core.internal.di.Requestor;

public class MethodRequestor
extends Requestor {
    private final Method method;

    public MethodRequestor(Method method, IInjector injector, AbstractObjectSupplier primarySupplier, Object requestingObject, boolean track, boolean groupUpdates, boolean optional) {
        super(injector, primarySupplier, requestingObject, track, groupUpdates, optional);
        this.method = method;
    }

    public Object execute() throws InvocationTargetException, InstantiationException {
        return this.callMethod(this.method, this.actualArgs);
    }

    public IObjectDescriptor[] getDependentObjects() {
        Type[] parameterTypes = this.method.getGenericParameterTypes();
        InjectionProperties[] properties = this.annotationSupport.getInjectParamProperties(this.method);
        IObjectDescriptor[] descriptors = new IObjectDescriptor[properties.length];
        int i = 0;
        while (i < properties.length) {
            descriptors[i] = ObjectDescriptorFactory.make(parameterTypes[i], properties[i].getQualifiers());
            ++i;
        }
        return descriptors;
    }

    private Object callMethod(Method method, Object[] args) throws InvocationTargetException {
        Object userObject = this.getRequestingObject();
        if (userObject == null) {
            return null;
        }
        Object result = null;
        boolean wasAccessible = true;
        if (!method.isAccessible()) {
            method.setAccessible(true);
            wasAccessible = false;
        }
        try {
            try {
                result = method.invoke(userObject, args);
            }
            catch (IllegalArgumentException e) {
                this.logError(method, (Exception)e);
                if (!wasAccessible) {
                    method.setAccessible(false);
                }
                return null;
            }
            catch (IllegalAccessException e) {
                this.logError(method, (Exception)e);
                if (!wasAccessible) {
                    method.setAccessible(false);
                }
                return null;
            }
        }
        finally {
            if (!wasAccessible) {
                method.setAccessible(false);
            }
        }
        return result;
    }
}

