/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.eclipse.e4.core.di.IObjectDescriptor;
import org.eclipse.e4.core.di.annotations.Optional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectDescriptor
implements IObjectDescriptor {
    private final Type desiredType;
    private final Annotation[] annotations;

    public ObjectDescriptor(Type desiredType, Annotation[] annotations) {
        this.desiredType = desiredType;
        this.annotations = annotations;
    }

    @Override
    public Class<?> getElementClass() {
        if (this.desiredType instanceof Class) {
            return (Class)this.desiredType;
        }
        if (this.desiredType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)this.desiredType).getRawType();
        }
        return null;
    }

    @Override
    public Type getElementType() {
        return this.desiredType;
    }

    @Override
    public boolean isOptional() {
        return this.hasQualifier(Optional.class);
    }

    @Override
    public boolean hasQualifier(Class<? extends Annotation> clazz) {
        if (clazz == null) {
            return false;
        }
        if (this.annotations == null) {
            return false;
        }
        Annotation[] annotationArray = this.annotations;
        int n = this.annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().equals(clazz)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Annotation[] getQualifiers() {
        return this.annotations;
    }

    @Override
    public Object getQualifier(Class<? extends Annotation> clazz) {
        if (clazz == null) {
            return null;
        }
        if (this.annotations == null) {
            return null;
        }
        Annotation[] annotationArray = this.annotations;
        int n = this.annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().equals(clazz)) {
                return annotation;
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.desiredType != null) {
            buffer.append(this.desiredType);
        }
        if (this.annotations != null) {
            buffer.append('[');
            boolean first = true;
            Annotation[] annotationArray = this.annotations;
            int n = this.annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (first) {
                    first = false;
                } else {
                    buffer.append(',');
                }
                buffer.append(annotation.toString());
                ++n2;
            }
            buffer.append(']');
        }
        return buffer.toString();
    }
}

