/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.e4.core.di.AbstractObjectSupplier;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.IObjectDescriptor;
import org.eclipse.e4.core.di.IRequestor;
import org.eclipse.e4.core.internal.di.AnnotationsSupport;

public abstract class Requestor
implements IRequestor {
    private final WeakReference<Object> objectRef;
    private final boolean track;
    private final boolean groupUpdates;
    private final boolean isOptional;
    private final IInjector injector;
    private final AbstractObjectSupplier primarySupplier;
    protected Object[] actualArgs;
    protected final AnnotationsSupport annotationSupport = new AnnotationsSupport();

    public abstract IObjectDescriptor[] getDependentObjects();

    public abstract Object execute() throws InvocationTargetException, InstantiationException;

    public Requestor(IInjector injector, AbstractObjectSupplier primarySupplier, Object requestingObject, boolean track, boolean groupUpdates, boolean isOptional) {
        this.injector = injector;
        this.primarySupplier = primarySupplier;
        this.objectRef = requestingObject != null ? new WeakReference<Object>(requestingObject) : null;
        this.track = track;
        this.groupUpdates = groupUpdates;
        this.isOptional = isOptional;
    }

    public IInjector getInjector() {
        return this.injector;
    }

    public AbstractObjectSupplier getPrimarySupplier() {
        return this.primarySupplier;
    }

    public Object getRequestingObject() {
        if (this.objectRef == null) {
            return null;
        }
        return this.objectRef.get();
    }

    public boolean shouldTrack() {
        return this.track;
    }

    public boolean shouldGroupUpdates() {
        return this.groupUpdates;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isResolved() {
        return this.actualArgs != null;
    }

    public void setResolvedArgs(Object[] actualArgs) {
        this.actualArgs = actualArgs;
    }

    protected void logError(Object destination, Exception e) {
        String msg = "Injection failed " + destination.toString();
        this.logError(msg, e);
    }

    protected void logError(String msg, Exception e) {
        System.out.println(msg);
        if (e != null) {
            e.printStackTrace();
        }
    }
}

