/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.tests.services.internal.annotations;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextChangeEvent;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.IRunAndTrack;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.core.internal.contexts.IEclipseContextStrategy;
import org.eclipse.e4.core.internal.contexts.osgi.OSGiContextStrategy;
import org.eclipse.e4.core.tests.services.annotations.Activator;
import org.eclipse.e4.core.tests.services.internal.annotations.PrintService;
import org.eclipse.e4.core.tests.services.internal.annotations.StringPrintService;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceContextTest
extends TestCase {
    private IEclipseContext context;
    private final List<ServiceRegistration> registrations = new ArrayList<ServiceRegistration>();

    protected void setUp() throws Exception {
        super.setUp();
        this.context = EclipseContextFactory.create(null, (IEclipseContextStrategy)new OSGiContextStrategy(Activator.bundleContext));
        this.registrations.clear();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        ((IDisposable)this.context).dispose();
        for (ServiceRegistration reg : this.registrations) {
            try {
                reg.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        this.registrations.clear();
        this.context = null;
    }

    public void testDeclarativeService() {
        ServiceContextTest.assertTrue((boolean)this.context.containsKey("sum"));
        ServiceContextTest.assertEquals((Object)0, (Object)this.context.get("sum"));
        this.context.set("x", (Object)1);
        this.context.set("y", (Object)2);
        int result = (Integer)this.context.get("sum");
        ServiceContextTest.assertEquals((String)"1.0", (int)3, (int)result);
        this.context.set("x", (Object)5);
        result = (Integer)this.context.get("sum");
        ServiceContextTest.assertEquals((String)"1.0", (int)7, (int)result);
    }

    public void testServiceContextAsParent() {
        IEclipseContext child = EclipseContextFactory.create((IEclipseContext)this.context, null);
        child.set("debugString", (Object)"child");
        DebugOptions service = (DebugOptions)child.get(DebugOptions.class.getName());
        ServiceContextTest.assertNotNull((Object)service);
    }

    public void testServiceInjection() {
        Printer userObject = new Printer();
        StringPrintService stringPrint1 = new StringPrintService();
        ServiceRegistration reg1 = Activator.bundleContext.registerService(PrintService.SERVICE_NAME, (Object)stringPrint1, null);
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)this.context);
        userObject.print("test");
        ServiceContextTest.assertEquals((String)"1.0", (String)"test", (String)stringPrint1.toString());
        reg1.unregister();
        userObject.print("another test");
        ServiceContextTest.assertEquals((String)"1.1", (String)"test", (String)stringPrint1.toString());
        ServiceContextTest.assertNull((String)"1.2", (Object)userObject.printer);
        StringPrintService stringPrint2 = new StringPrintService();
        ServiceRegistration reg2 = Activator.bundleContext.registerService(PrintService.SERVICE_NAME, (Object)stringPrint2, null);
        userObject.print("yet another test");
        ServiceContextTest.assertEquals((String)"2.0", (String)"test", (String)stringPrint1.toString());
        ServiceContextTest.assertEquals((String)"2.1", (String)"yet another test", (String)stringPrint2.toString());
        reg2.unregister();
        ServiceContextTest.assertNull((String)"2.2", (Object)userObject.printer);
    }

    protected void ensureUnregistered(ServiceRegistration reg) {
        this.registrations.add(reg);
    }

    public void testServiceRemovalOnContextDispose() {
        StringPrintService stringPrint1 = new StringPrintService();
        ServiceRegistration reg1 = Activator.bundleContext.registerService(PrintService.SERVICE_NAME, (Object)stringPrint1, null);
        try {
            ServiceReference ref = reg1.getReference();
            PrintService service = (PrintService)this.context.get(PrintService.SERVICE_NAME);
            ServiceContextTest.assertEquals((String)"1.0", (Object)stringPrint1, (Object)service);
            ServiceContextTest.assertEquals((String)"1.1", (int)1, (int)ref.getUsingBundles().length);
            service = null;
            ((IDisposable)this.context).dispose();
            ServiceContextTest.assertNull((String)"2.0", (Object)ref.getUsingBundles());
        }
        finally {
            reg1.unregister();
        }
    }

    public void testRecursiveServiceRemoval() {
        ServiceRegistration reg1 = Activator.bundleContext.registerService(PrintService.SERVICE_NAME, (Object)new StringPrintService(), null);
        final IEclipseContext child = EclipseContextFactory.create((IEclipseContext)this.context, null);
        IEclipseContext child2 = EclipseContextFactory.create((IEclipseContext)this.context, null);
        child.get(PrintService.SERVICE_NAME);
        child2.get(PrintService.SERVICE_NAME);
        this.ensureUnregistered(reg1);
        final boolean[] done = new boolean[1];
        this.context.runAndTrack(new IRunAndTrack(){

            public boolean notify(ContextChangeEvent event) {
                if (ServiceContextTest.this.context.get(PrintService.SERVICE_NAME) == null) {
                    ((IDisposable)child).dispose();
                    done[0] = true;
                }
                return true;
            }
        }, null);
        reg1.unregister();
    }

    public void testServiceExample() {
        ServiceRegistration reg = Activator.bundleContext.registerService(IPaletteService.class.getName(), (Object)new PaletteImpl(Color.BLUE), null);
        IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)Activator.bundleContext);
        Crayon crayon = new Crayon();
        ContextInjectionFactory.inject((Object)crayon, (IEclipseContext)context);
        crayon.draw();
        reg.unregister();
        crayon.draw();
    }

    public void testServiceRemovalOnChildContextDispose() {
        StringPrintService stringPrint1 = new StringPrintService();
        ServiceRegistration reg1 = Activator.bundleContext.registerService(PrintService.SERVICE_NAME, (Object)stringPrint1, null);
        ServiceReference ref = reg1.getReference();
        ServiceContextTest.assertNull((String)"0.1", (Object)ref.getUsingBundles());
        IEclipseContext child = EclipseContextFactory.create((IEclipseContext)this.context, null);
        child.set("debugString", (Object)"child");
        PrintService service = (PrintService)child.get(PrintService.SERVICE_NAME);
        ServiceContextTest.assertEquals((String)"1.0", (Object)stringPrint1, (Object)service);
        ServiceContextTest.assertEquals((String)"1.1", (int)1, (int)ref.getUsingBundles().length);
        ServiceContextTest.assertTrue((String)"1.2", (boolean)this.context.containsKey(PrintService.SERVICE_NAME));
        service = null;
        child = null;
        System.gc();
        System.runFinalization();
        System.gc();
        child = EclipseContextFactory.create((IEclipseContext)this.context, null);
        child.set("debugString", (Object)"child-2");
        service = (PrintService)child.get(PrintService.SERVICE_NAME);
        service = null;
        ((IDisposable)child).dispose();
        child = null;
        ServiceContextTest.assertNull((String)"2.2", (Object)ref.getUsingBundles());
        reg1.unregister();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Color {
        RED,
        BLUE,
        YELLOW,
        GREEN,
        ORANGE,
        PURPLE;

    }

    class Crayon {
        @Inject
        IPaletteService palette;

        Crayon() {
        }

        public void draw() {
            if (this.palette == null) {
                System.out.println("I'm out of ink!");
            } else {
                System.out.println("My ink is  " + (Object)((Object)this.palette.getColor()));
            }
        }
    }

    static interface IPaletteService {
        public Color getColor();
    }

    class PaletteImpl
    implements IPaletteService {
        private final Color color;

        PaletteImpl(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }

    static class Printer {
        @Inject
        PrintService printer;

        Printer() {
        }

        public void print(String message) {
            if (this.printer != null) {
                this.printer.print(message);
            } else {
                System.out.println(message);
            }
        }
    }
}

