/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di.extensions;

import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import junit.framework.TestCase;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preferences;
import org.eclipse.e4.core.internal.tests.CoreTestsActivator;
import org.osgi.service.prefs.BackingStoreException;

public class InjectionPreferencesTest
extends TestCase {
    private static final String TEST_PREFS_KEY = "testPreferencesQualifier";
    private static final String TEST_PREFS_NODE = "org.eclipse.e4.core.tests.ext";

    public void testPreferencesQualifier() throws BackingStoreException, InvocationTargetException, InstantiationException {
        this.setPreference(TEST_PREFS_KEY, "abc");
        this.setPreference(TEST_PREFS_KEY, TEST_PREFS_NODE, "123");
        IEclipseContext context = EclipseContextFactory.create();
        InjectTarget target = (InjectTarget)ContextInjectionFactory.make(InjectTarget.class, (IEclipseContext)context);
        InjectionPreferencesTest.assertEquals((int)1, (int)target.counter);
        InjectionPreferencesTest.assertEquals((String)"abc", (String)target.pref);
        InjectionPreferencesTest.assertEquals((int)1, (int)target.counterNode);
        InjectionPreferencesTest.assertEquals((String)"123", (String)target.prefNode);
        InjectionPreferencesTest.assertEquals((int)1, (int)target.counterOptional);
        InjectionPreferencesTest.assertNull((Object)target.prefOptional1);
        InjectionPreferencesTest.assertEquals((String)"abc", (String)target.prefOptional2);
        this.setPreference(TEST_PREFS_KEY, "xyz");
        this.setPreference(TEST_PREFS_KEY, TEST_PREFS_NODE, "456");
        InjectionPreferencesTest.assertEquals((int)2, (int)target.counter);
        InjectionPreferencesTest.assertEquals((String)"xyz", (String)target.pref);
        InjectionPreferencesTest.assertEquals((int)2, (int)target.counterNode);
        InjectionPreferencesTest.assertEquals((String)"456", (String)target.prefNode);
        InjectionPreferencesTest.assertEquals((int)2, (int)target.counterOptional);
        InjectionPreferencesTest.assertNull((Object)target.prefOptional1);
        InjectionPreferencesTest.assertEquals((String)"xyz", (String)target.prefOptional2);
    }

    private void setPreference(String key, String value) throws BackingStoreException {
        String nodePath = CoreTestsActivator.getDefault().getBundleContext().getBundle().getSymbolicName();
        IEclipsePreferences node = new InstanceScope().getNode(nodePath);
        node.put(key, value);
        node.flush();
    }

    private void setPreference(String key, String nodePath, String value) throws BackingStoreException {
        IEclipsePreferences node = new InstanceScope().getNode(nodePath);
        node.put(key, value);
        node.flush();
    }

    static class InjectTarget {
        public int counter = 0;
        public int counterNode = 0;
        public int counterOptional = 0;
        public String pref;
        public String prefNode;
        public String prefOptional1;
        public String prefOptional2;

        InjectTarget() {
        }

        @Inject
        public void setPrefs(@Preferences(value="testPreferencesQualifier") String string) {
            ++this.counter;
            this.pref = string;
        }

        @Inject
        public void setPrefsNode(@Preferences(value="testPreferencesQualifier", nodePath="org.eclipse.e4.core.tests.ext") String string) {
            ++this.counterNode;
            this.prefNode = string;
        }

        @Inject
        public void setOptionalPrefs(@Optional @Preferences(value="something") String string1, @Preferences(value="testPreferencesQualifier") String string2) {
            ++this.counterOptional;
            this.prefOptional1 = string1;
            this.prefOptional2 = string2;
        }
    }
}

