/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.e4photo;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableSetTreeContentProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.prefs.BackingStoreException;

public class Library
implements IDisposable {
    Map<IContainer, IObservableSet> observableSets = new HashMap<IContainer, IObservableSet>();
    private IEclipseContext context;
    private IResourceChangeListener listener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 1) {
                try {
                    event.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            if (delta.getKind() == 1) {
                                this.handleChange(delta.getResource(), delta.getResource().getParent(), true);
                            } else if (delta.getKind() == 2) {
                                this.handleChange(delta.getResource(), delta.getResource().getParent(), false);
                            }
                            return true;
                        }

                        private void handleChange(final IResource resource, IContainer parent, final boolean added) {
                            Realm realm;
                            final IObservableSet set = (this).Library.this.observableSets.get(parent);
                            Realm realm2 = realm = set != null ? set.getRealm() : null;
                            if (realm != null) {
                                realm.asyncExec(new Runnable(){

                                    public void run() {
                                        if (added) {
                                            set.add((Object)resource);
                                        } else {
                                            set.remove((Object)resource);
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    };
    private final IWorkspace workspace;
    static int counter;

    @Inject
    public Library(Composite parent, IWorkspace workspace) {
        final Realm realm = SWTObservables.getRealm((Display)parent.getDisplay());
        this.workspace = workspace;
        this.initializeWorkspace();
        TreeViewer viewer = new TreeViewer(parent, 770);
        viewer.getTree().setData("org.eclipse.e4.ui.css.id", (Object)"library");
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                Library.this.context.modify("selection", (Object)(selection.size() == 1 ? selection.getFirstElement() : selection.toArray()));
            }
        });
        IObservableFactory setFactory = new IObservableFactory(){

            public IObservable createObservable(Object element) {
                if (element instanceof IContainer && ((IContainer)element).exists()) {
                    IObservableSet observableSet = Library.this.observableSets.get(element);
                    if (observableSet == null) {
                        observableSet = new WritableSet(realm);
                        try {
                            observableSet.addAll(Arrays.asList(((IContainer)element).members()));
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        Library.this.observableSets.put((IContainer)element, observableSet);
                    }
                    return observableSet;
                }
                return Observables.emptyObservableSet();
            }
        };
        viewer.setContentProvider((IContentProvider)new ObservableSetTreeContentProvider(setFactory, new TreeStructureAdvisor(){

            public Boolean hasChildren(Object element) {
                return element instanceof IContainer;
            }
        }));
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IResource) {
                    return ((IResource)element).getName();
                }
                return element == null ? "" : element.toString();
            }
        });
        viewer.setSorter(new ViewerSorter());
        viewer.setInput((Object)workspace.getRoot());
        GridLayoutFactory.fillDefaults().generateLayout(parent);
    }

    private void initializeWorkspace() {
        this.workspace.addResourceChangeListener(this.listener);
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.core.resources");
        node.putBoolean("refresh.enabled", true);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    @Inject
    public void contextSet(IEclipseContext context) {
        this.context = context;
    }

    public void dispose() {
        this.workspace.removeResourceChangeListener(this.listener);
    }
}

