/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs;

import java.util.ArrayList;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.internal.PatternFilter;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MCommand;
import org.eclipse.e4.ui.model.application.MModelComponent;
import org.eclipse.e4.ui.model.application.MModelComponents;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractCommandSelectionDialog
extends TitleAreaDialog {
    private IModelResource resource;
    private TableViewer viewer;

    public AbstractCommandSelectionDialog(Shell parentShell, IModelResource resource) {
        super(parentShell);
        this.resource = resource;
    }

    protected abstract String getShellTitle();

    protected abstract String getDialogTitle();

    protected abstract String getDialogMessage();

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getShell().setText(this.getShellTitle());
        this.setTitle(this.getDialogTitle());
        this.setMessage(this.getDialogMessage());
        Composite container = new Composite(composite, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(container, 0);
        l.setText("Command-Id");
        Text searchText = new Text(container, 2688);
        searchText.setLayoutData((Object)new GridData(768));
        l = new Label(container, 0);
        this.viewer = new TableViewer(container);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProviderImpl());
        this.viewer.getControl().setLayoutData((Object)new GridData(768));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AbstractCommandSelectionDialog.this.okPressed();
            }
        });
        if (this.resource.getRoot().get(0) instanceof MApplication) {
            MApplication app = (MApplication)this.resource.getRoot().get(0);
            this.viewer.setInput((Object)app.getCommands());
        } else {
            MModelComponents components = (MModelComponents)this.resource.getRoot().get(0);
            ArrayList commands = new ArrayList();
            for (MModelComponent comp : components.getComponents()) {
                commands.addAll(comp.getCommands());
            }
            this.viewer.setInput(commands);
        }
        final PatternFilter filter = new PatternFilter(){

            protected boolean isParentMatch(Viewer viewer, Object element) {
                return viewer instanceof AbstractTreeViewer && super.isParentMatch(viewer, element);
            }
        };
        this.viewer.addFilter((ViewerFilter)filter);
        searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                filter.setPattern(((Text)e.widget).getText());
                AbstractCommandSelectionDialog.this.viewer.refresh();
            }
        });
        return composite;
    }

    protected void okPressed() {
        Command cmd;
        IStructuredSelection s = (IStructuredSelection)this.viewer.getSelection();
        if (!s.isEmpty() && (cmd = this.createStoreCommand(this.resource.getEditingDomain(), (MCommand)s.getFirstElement())).canExecute()) {
            this.resource.getEditingDomain().getCommandStack().execute(cmd);
            super.okPressed();
        }
    }

    protected abstract Command createStoreCommand(EditingDomain var1, MCommand var2);

    private class LabelProviderImpl
    extends StyledCellLabelProvider
    implements ILabelProvider {
        private LabelProviderImpl() {
        }

        public void update(ViewerCell cell) {
            MCommand cmd = (MCommand)cell.getElement();
            StyledString styledString = new StyledString();
            if (cmd.getCommandName() != null) {
                styledString.append(cmd.getCommandName());
            }
            if (cmd.getDescription() != null) {
                styledString.append(" - " + cmd.getDescription(), StyledString.DECORATIONS_STYLER);
            }
            if (cmd.getId() != null) {
                styledString.append(" - " + cmd.getId(), StyledString.DECORATIONS_STYLER);
            }
            cell.setText(styledString.getString());
            cell.setStyleRanges(styledString.getStyleRanges());
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            MCommand command = (MCommand)element;
            String s = "";
            if (command.getCommandName() != null) {
                s = String.valueOf(s) + command.getCommandName();
            }
            if (command.getDescription() != null) {
                s = String.valueOf(s) + " " + command.getDescription();
            }
            if (command.getId() != null) {
                s = String.valueOf(s) + " " + command.getId();
            }
            return s;
        }
    }
}

