/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.dom;

import org.apache.commons.beanutils.PropertyUtils;
import org.eclipse.e4.ui.css.core.dom.ElementAdapter;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.utils.ClassUtils;
import org.eclipse.e4.ui.css.core.utils.NumberUtils;
import org.eclipse.e4.ui.css.swt.engine.AbstractCSSSWTEngineImpl;
import org.eclipse.e4.ui.css.swt.helpers.SWTStyleHelpers;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SWTElement
extends ElementAdapter
implements NodeList {
    protected String localName = this.computeLocalName();
    protected String namespaceURI = this.computeNamespaceURI();
    protected String swtStyles;

    public static String getCSSClass(Widget widget) {
        return (String)widget.getData("org.eclipse.e4.ui.css.CssClassName");
    }

    public static String getID(Widget widget) {
        return (String)widget.getData("org.eclipse.e4.ui.css.id");
    }

    public static void setCSSClass(Widget widget, String className) {
        widget.setData("org.eclipse.e4.ui.css.CssClassName", (Object)className);
    }

    public static void setID(Widget widget, String id) {
        widget.setData("org.eclipse.e4.ui.css.id", (Object)id);
    }

    public static CSSEngine getEngine(Widget widget) {
        return (CSSEngine)widget.getDisplay().getData("org.eclipse.e4.ui.css.core.engine");
    }

    public static void setEngine(Display display, AbstractCSSSWTEngineImpl engine) {
        display.setData("org.eclipse.e4.ui.css.core.engine", (Object)engine);
    }

    public SWTElement(Widget widget, CSSEngine engine) {
        super((Object)widget, engine);
        this.computeStaticPseudoInstances();
        this.swtStyles = this.computeAttributeSWTStyle();
    }

    protected String computeLocalName() {
        Widget widget = this.getWidget();
        Class<?> clazz = widget.getClass();
        return ClassUtils.getSimpleName(clazz);
    }

    protected String computeNamespaceURI() {
        Widget widget = this.getWidget();
        Class<?> clazz = widget.getClass();
        return ClassUtils.getPackageName(clazz);
    }

    protected void computeStaticPseudoInstances() {
        Widget widget = this.getWidget();
        if (widget instanceof CTabFolder || widget instanceof CTabItem) {
            super.addStaticPseudoInstance("selected");
        }
    }

    protected String computeAttributeSWTStyle() {
        return SWTStyleHelpers.getSWTWidgetStyleAsString(this.getWidget());
    }

    public String getAttribute(String attr) {
        Widget widget = this.getWidget();
        if (attr.equals("style")) {
            return this.swtStyles;
        }
        Object o = widget.getData(attr.toLowerCase());
        if (o != null) {
            return o.toString();
        }
        try {
            o = PropertyUtils.getProperty((Object)widget, (String)attr);
            if (o != null) {
                return o.toString();
            }
        }
        catch (Exception exception) {}
        return "";
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public Node getParentNode() {
        Control control;
        Composite parent;
        Widget widget = this.getWidget();
        if (widget instanceof CTabItem) {
            return this.getElement(((CTabItem)widget).getParent());
        }
        if (widget instanceof Control && (parent = (control = (Control)widget).getParent()) != null) {
            Element element = this.getElement(parent);
            return element;
        }
        return null;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public int getLength() {
        Widget widget = this.getWidget();
        int childCount = 0;
        if (widget instanceof Composite) {
            childCount = ((Composite)widget).getChildren().length;
            if (widget instanceof CTabFolder) {
                childCount += ((CTabFolder)widget).getItemCount();
            }
        }
        return childCount;
    }

    public Node item(int index) {
        Widget widget = this.getWidget();
        if (widget instanceof Composite) {
            if (widget instanceof CTabFolder) {
                CTabFolder folder = (CTabFolder)widget;
                int length = folder.getChildren().length;
                if (index >= length) {
                    CTabItem w = folder.getItem(index - length);
                    return this.getElement(w);
                }
                Control w = folder.getChildren()[index];
                return this.getElement(w);
            }
            Control w = ((Composite)widget).getChildren()[index];
            return this.getElement(w);
        }
        return null;
    }

    protected Widget getWidget() {
        return (Widget)this.getNativeWidget();
    }

    public String getCSSId() {
        Widget widget = this.getWidget();
        String id = SWTElement.getID(widget);
        if (id != null) {
            return id.toString();
        }
        return null;
    }

    public String getCSSClass() {
        Widget widget = this.getWidget();
        String id = SWTElement.getCSSClass(widget);
        if (id != null) {
            return id.toString();
        }
        return null;
    }

    public String getCSSStyle() {
        Widget widget = this.getWidget();
        Object id = widget.getData("style");
        if (id != null) {
            return id.toString();
        }
        return null;
    }

    public boolean isPseudoInstanceOf(String s) {
        Object widget;
        Control control;
        if ("enabled".equals(s)) {
            Control control2 = (Control)this.getNativeWidget();
            return control2.isEnabled();
        }
        if ("disabled".equals(s)) {
            Control control3 = (Control)this.getNativeWidget();
            return !control3.isEnabled();
        }
        if ("selected".equals(s) && this.getNativeWidget() instanceof Button) {
            Button button = (Button)this.getNativeWidget();
            return button.getSelection();
        }
        if ("visible".equals(s)) {
            Control control4 = (Control)this.getNativeWidget();
            return !control4.isVisible();
        }
        if ("focus".equals(s) && (control = (Control)this.getNativeWidget()).isFocusControl()) {
            return control.getData("org.eclipse.e4.ui.css.swt.FOCUS_LOST") == null;
        }
        if ("active".equals(s) && this.getNativeWidget() instanceof Shell && (control = (Control)this.getNativeWidget()).isEnabled()) {
            return control.getData("org.eclipse.e4.ui.css.swt.ACTIVE_LOST") == null;
        }
        if ("hover".equals(s)) {
            control = (Control)this.getNativeWidget();
            return control.getData("org.eclipse.e4.ui.css.swt.HOVER") != null;
        }
        if ("odd".equals(s) && (widget = this.getNativeWidget()) instanceof TableItem) {
            TableItem tableItem = (TableItem)widget;
            int index = tableItem.getParent().indexOf(tableItem);
            return NumberUtils.isOdd((int)index);
        }
        if ("even".equals(s) && (widget = this.getNativeWidget()) instanceof TableItem) {
            TableItem tableItem = (TableItem)widget;
            int index = tableItem.getParent().indexOf(tableItem);
            return NumberUtils.isEven((int)index);
        }
        return super.isPseudoInstanceOf(s);
    }
}

