/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MDirtyable;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MPartSashContainer;
import org.eclipse.e4.ui.model.application.MPartStack;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.workbench.swt.internal.E4Application;
import org.eclipse.e4.workbench.modeling.EModelService;

public class EModelServiceFindTest
extends TestCase {
    private IEclipseContext applicationContext;
    MApplication app = null;

    protected void setUp() throws Exception {
        this.applicationContext = E4Application.createDefaultContext();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.applicationContext instanceof IDisposable) {
            ((IDisposable)this.applicationContext).dispose();
        }
    }

    private MApplication createApplication() {
        MApplication app = MApplicationFactory.eINSTANCE.createApplication();
        app.setContext(this.applicationContext);
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        window.setId("singleValidId");
        app.getChildren().add((Object)window);
        MPartSashContainer psc = MApplicationFactory.eINSTANCE.createPartSashContainer();
        psc.setId("twoValidIds");
        psc.getTags().add((Object)"oneValidTag");
        window.getChildren().add((Object)psc);
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        stack.getTags().add((Object)"twoValidTags");
        psc.getChildren().add((Object)stack);
        MPart part1 = MApplicationFactory.eINSTANCE.createPart();
        part1.setId("twoValidIds");
        stack.getChildren().add((Object)part1);
        MPart part2 = MApplicationFactory.eINSTANCE.createPart();
        part2.getTags().add((Object)"twoValidTags");
        part2.getTags().add((Object)"secondTag");
        stack.getChildren().add((Object)part2);
        MPart part3 = MApplicationFactory.eINSTANCE.createPart();
        psc.getChildren().add((Object)part3);
        return app;
    }

    public void testFindElementsIdOnly() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class.getName());
        EModelServiceFindTest.assertNotNull((Object)modelService);
        List elements1 = modelService.findElements((MUIElement)application, "singleValidId", null, null);
        EModelServiceFindTest.assertEquals((int)elements1.size(), (int)1);
        List elements2 = modelService.findElements((MUIElement)application, "twoValidIds", null, null);
        EModelServiceFindTest.assertEquals((int)elements2.size(), (int)2);
        List elements3 = modelService.findElements((MUIElement)application, "invalidId", null, null);
        EModelServiceFindTest.assertEquals((int)elements3.size(), (int)0);
    }

    public void testFindElementsTypeOnly() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class.getName());
        EModelServiceFindTest.assertNotNull((Object)modelService);
        List parts = modelService.findElements((MUIElement)application, null, MPart.class, null);
        EModelServiceFindTest.assertEquals((int)parts.size(), (int)3);
        List stacks = modelService.findElements((MUIElement)application, null, MPartStack.class, null);
        EModelServiceFindTest.assertEquals((int)stacks.size(), (int)1);
        List dirtyableElements = modelService.findElements((MUIElement)application, null, MDirtyable.class, null);
        EModelServiceFindTest.assertEquals((int)dirtyableElements.size(), (int)3);
        List uiElements = modelService.findElements((MUIElement)application, null, null, null);
        EModelServiceFindTest.assertEquals((int)uiElements.size(), (int)7);
        List strings = modelService.findElements((MUIElement)application, null, String.class, null);
        EModelServiceFindTest.assertEquals((int)strings.size(), (int)0);
    }

    public void testFindElementsTagsOnly() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class.getName());
        EModelServiceFindTest.assertNotNull((Object)modelService);
        ArrayList<String> tags = new ArrayList<String>();
        tags.add("oneValidTag");
        List oneTags = modelService.findElements((MUIElement)application, null, null, tags);
        EModelServiceFindTest.assertEquals((int)oneTags.size(), (int)1);
        tags.clear();
        tags.add("twoValidTags");
        List twoTags = modelService.findElements((MUIElement)application, null, null, tags);
        EModelServiceFindTest.assertEquals((int)twoTags.size(), (int)2);
        tags.clear();
        tags.add("invalidTag");
        List invalidTags = modelService.findElements((MUIElement)application, null, null, tags);
        EModelServiceFindTest.assertEquals((int)invalidTags.size(), (int)0);
        tags.clear();
        tags.add("twoValidTags");
        tags.add("secondTag");
        List combinedTags = modelService.findElements((MUIElement)application, null, null, tags);
        EModelServiceFindTest.assertEquals((int)combinedTags.size(), (int)1);
        tags.clear();
        tags.add("oneValidTag");
        tags.add("secondTag");
        List unmatchedTags = modelService.findElements((MUIElement)application, null, null, tags);
        EModelServiceFindTest.assertEquals((int)unmatchedTags.size(), (int)0);
    }

    public void testFindElementsCombinations() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class.getName());
        EModelServiceFindTest.assertNotNull((Object)modelService);
        ArrayList<String> tags = new ArrayList<String>();
        tags.add("oneValidTag");
        List idAndType = modelService.findElements((MUIElement)application, "twoValidIds", MPartSashContainer.class, tags);
        EModelServiceFindTest.assertEquals((int)idAndType.size(), (int)1);
        List typeAndTag = modelService.findElements((MUIElement)application, null, MPartSashContainer.class, tags);
        EModelServiceFindTest.assertEquals((int)typeAndTag.size(), (int)1);
        List idAndTag = modelService.findElements((MUIElement)application, "twoValidIds", null, tags);
        EModelServiceFindTest.assertEquals((int)idAndTag.size(), (int)1);
        List idAndTypeAndTags = modelService.findElements((MUIElement)application, "twoValidIds", MPartSashContainer.class, null);
        EModelServiceFindTest.assertEquals((int)idAndTypeAndTags.size(), (int)1);
        List badIdAndTypeAndTags = modelService.findElements((MUIElement)application, "invalidId", MPartSashContainer.class, null);
        EModelServiceFindTest.assertEquals((int)badIdAndTypeAndTags.size(), (int)0);
    }
}

