/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import javax.inject.Inject;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.core.di.annotations.PostConstruct;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MContext;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MPartStack;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.workbench.ui.IPresentationEngine;
import org.eclipse.e4.workbench.ui.UIEvents;
import org.eclipse.e4.workbench.ui.internal.Activator;
import org.eclipse.emf.common.util.EList;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadlessContextPresentationEngine
implements IPresentationEngine {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IContributionFactory contributionFactory;
    private EventHandler childHandler;
    private EventHandler activeChildHandler;
    private boolean createContributions = true;

    private static IEclipseContext getParentContext(MUIElement element) {
        MElementContainer parent = element.getParent();
        IEclipseContext context = null;
        while (parent != null) {
            if (parent instanceof MContext) {
                return ((MContext)parent).getContext();
            }
            parent = parent.getParent();
        }
        return context;
    }

    private static void populateModelInterfaces(MContext contextModel, IEclipseContext context, Class<?>[] interfaces) {
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            Activator.trace((String)"/trace/eclipse.context", (String)("Adding " + intf.getName() + " for " + contextModel.getClass().getName()), null);
            context.set(intf.getName(), (Object)contextModel);
            HeadlessContextPresentationEngine.populateModelInterfaces(contextModel, context, intf.getInterfaces());
            ++n2;
        }
    }

    @PostConstruct
    void postConstruct() {
        this.childHandler = new EventHandler(){

            public void handleEvent(Event event) {
                Object element;
                if ("ADD".equals(event.getProperty("EventType")) && (element = event.getProperty("NewValue")) instanceof MUIElement) {
                    MPartStack stack;
                    EList children;
                    Object parent = event.getProperty("ChangedElement");
                    HeadlessContextPresentationEngine.this.createGui((MUIElement)element, parent);
                    if (parent instanceof MPartStack && (children = (stack = (MPartStack)parent).getChildren()).size() == 1) {
                        stack.setSelectedElement((MUIElement)((MPart)element));
                    }
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/ElementContainer", (String)"children"), this.childHandler);
        this.activeChildHandler = new EventHandler(){

            public void handleEvent(Event event) {
                Object element = event.getProperty("NewValue");
                if (element instanceof MUIElement) {
                    Object parent = event.getProperty("ChangedElement");
                    HeadlessContextPresentationEngine.this.createGui((MUIElement)element, parent);
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/ElementContainer", (String)"selectedElement"), this.activeChildHandler);
    }

    public void setCreateContributions(boolean createContributions) {
        this.createContributions = createContributions;
    }

    public Object createGui(MUIElement element, Object parent) {
        block10: {
            IEclipseContext parentContext;
            IEclipseContext childContext;
            block8: {
                MPartStack container;
                block9: {
                    if (!element.isToBeRendered()) {
                        return null;
                    }
                    if (element instanceof MContext) {
                        MContribution contribution;
                        String uri;
                        MContext mcontext = (MContext)element;
                        if (mcontext.getContext() != null) {
                            return null;
                        }
                        IEclipseContext parentContext2 = HeadlessContextPresentationEngine.getParentContext(element);
                        IEclipseContext createdContext = EclipseContextFactory.create((IEclipseContext)parentContext2, null);
                        createdContext.set("debugString", (Object)(String.valueOf(element.getClass().getInterfaces()[0].getName()) + " eclipse context"));
                        HeadlessContextPresentationEngine.populateModelInterfaces(mcontext, createdContext, element.getClass().getInterfaces());
                        for (String variable : mcontext.getVariables()) {
                            createdContext.declareModifiable(variable);
                        }
                        mcontext.setContext(createdContext);
                        if (element instanceof MContribution && this.createContributions && (uri = (contribution = (MContribution)element).getURI()) != null) {
                            Object clientObject = this.contributionFactory.create(uri, createdContext);
                            contribution.setObject(clientObject);
                        }
                        if (parentContext2.getLocal("activeChildContext") == null) {
                            parentContext2.set("activeChildContext", (Object)createdContext);
                        }
                    }
                    if (!(element instanceof MPartStack)) break block8;
                    container = (MPartStack)element;
                    MPart active = (MPart)container.getSelectedElement();
                    if (active == null) break block9;
                    this.createGui((MUIElement)active, container);
                    childContext = active.getContext();
                    parentContext = HeadlessContextPresentationEngine.getParentContext((MUIElement)active);
                    parentContext.set("activeChildContext", (Object)childContext);
                    break block10;
                }
                EList children = container.getChildren();
                if (children.isEmpty()) break block10;
                container.setSelectedElement((MUIElement)((MPart)children.get(0)));
                break block10;
            }
            if (element instanceof MElementContainer) {
                for (Object child : ((MElementContainer)element).getChildren()) {
                    if (!(child instanceof MUIElement)) continue;
                    this.createGui((MUIElement)child, element);
                    if (!(child instanceof MContext)) continue;
                    childContext = ((MContext)child).getContext();
                    parentContext = HeadlessContextPresentationEngine.getParentContext((MUIElement)child);
                    if (parentContext.getLocal("activeChildContext") != null) continue;
                    parentContext.set("activeChildContext", (Object)childContext);
                }
            }
        }
        return null;
    }

    public Object createGui(MUIElement element) {
        return this.createGui(element, null);
    }

    public void removeGui(MUIElement element) {
        if (element instanceof MElementContainer) {
            for (Object child : ((MElementContainer)element).getChildren()) {
                if (!(child instanceof MUIElement)) continue;
                this.removeGui((MUIElement)child);
            }
        }
        if (element instanceof MContext) {
            MContext mcontext = (MContext)element;
            IEclipseContext context = mcontext.getContext();
            mcontext.setContext(null);
            if (context instanceof IDisposable) {
                ((IDisposable)context).dispose();
            }
        }
    }

    public Object run(MApplicationElement uiRoot, IEclipseContext appContext) {
        return 0;
    }

    public void stop() {
    }
}

