/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MCommand;
import org.eclipse.e4.ui.model.application.MHandler;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.workbench.modeling.ModelDelta;
import org.eclipse.e4.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerHandlerContainerTest
extends ModelReconcilerTest {
    public void testHandlerContainer_Handlers_Add_UnboundHandler() {
        MApplication application = this.createApplication();
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MHandler handler = MApplicationFactory.eINSTANCE.createHandler();
        application.getHandlers().add((Object)handler);
        Object state = reconciler.serialize();
        application = this.createApplication();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerHandlerContainerTest.assertEquals((int)0, (int)application.getHandlers().size());
        this.applyAll(deltas);
        ModelReconcilerHandlerContainerTest.assertEquals((int)1, (int)application.getHandlers().size());
        handler = (MHandler)application.getHandlers().get(0);
        ModelReconcilerHandlerContainerTest.assertEquals(null, (Object)handler.getCommand());
    }

    public void testHandlerContainer_Handlers_Add_BoundHandler() {
        MApplication application = this.createApplication();
        MCommand command = MApplicationFactory.eINSTANCE.createCommand();
        application.getCommands().add((Object)command);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MHandler handler = MApplicationFactory.eINSTANCE.createHandler();
        handler.setCommand(command);
        application.getHandlers().add((Object)handler);
        Object state = reconciler.serialize();
        application = this.createApplication();
        command = (MCommand)application.getCommands().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerHandlerContainerTest.assertEquals((int)0, (int)application.getHandlers().size());
        this.applyAll(deltas);
        ModelReconcilerHandlerContainerTest.assertEquals((int)1, (int)application.getHandlers().size());
        handler = (MHandler)application.getHandlers().get(0);
        ModelReconcilerHandlerContainerTest.assertEquals((Object)command, (Object)handler.getCommand());
    }

    public void testHandlerContainer_Handlers_Remove_UnboundHandler() {
        MApplication application = this.createApplication();
        MHandler handler = MApplicationFactory.eINSTANCE.createHandler();
        application.getHandlers().add((Object)handler);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        application.getHandlers().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        handler = (MHandler)application.getHandlers().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerHandlerContainerTest.assertEquals((int)1, (int)application.getHandlers().size());
        ModelReconcilerHandlerContainerTest.assertEquals((Object)handler, (Object)application.getHandlers().get(0));
        this.applyAll(deltas);
        ModelReconcilerHandlerContainerTest.assertEquals((int)0, (int)application.getHandlers().size());
    }

    public void testHandlerContainer_Handlers_Remove_BoundHandler() {
        MApplication application = this.createApplication();
        MCommand command = MApplicationFactory.eINSTANCE.createCommand();
        application.getCommands().add((Object)command);
        MHandler handler = MApplicationFactory.eINSTANCE.createHandler();
        handler.setCommand(command);
        application.getHandlers().add((Object)handler);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        application.getHandlers().remove((Object)handler);
        Object state = reconciler.serialize();
        application = this.createApplication();
        command = (MCommand)application.getCommands().get(0);
        handler = (MHandler)application.getHandlers().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerHandlerContainerTest.assertEquals((int)1, (int)application.getHandlers().size());
        handler = (MHandler)application.getHandlers().get(0);
        ModelReconcilerHandlerContainerTest.assertEquals((Object)command, (Object)handler.getCommand());
        this.applyAll(deltas);
        ModelReconcilerHandlerContainerTest.assertEquals((int)0, (int)application.getHandlers().size());
    }
}

