/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MPartSashContainer;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.workbench.swt.internal.E4Application;
import org.eclipse.e4.workbench.ui.internal.E4Workbench;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class MSashTest
extends TestCase {
    protected IEclipseContext appContext;
    protected E4Workbench wb;

    protected void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.workbench.swt.internal.PartRenderingEngine");
    }

    protected void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        if (this.appContext instanceof IDisposable) {
            ((IDisposable)this.appContext).dispose();
        }
    }

    public void testSashWeights() {
        MWindow window = this.createSashWithNViews(2);
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.getChildren().add((Object)window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Widget topWidget = (Widget)window.getWidget();
        ((Shell)topWidget).layout(true);
        MPartSashContainer sash = (MPartSashContainer)window.getChildren().get(0);
        MSashTest.assertTrue((String)"Should be an MPartSashContainer", (boolean)(sash instanceof MPartSashContainer));
        MPart part0 = (MPart)sash.getChildren().get(0);
        MPart part1 = (MPart)sash.getChildren().get(1);
        int cdVal0 = -1;
        try {
            cdVal0 = Integer.parseInt(part0.getContainerData());
        }
        catch (NumberFormatException numberFormatException) {}
        MSashTest.assertTrue((String)"Part0 data is not an integer", (cdVal0 != -1 ? 1 : 0) != 0);
        int cdVal1 = -1;
        try {
            cdVal1 = Integer.parseInt(part1.getContainerData());
        }
        catch (NumberFormatException numberFormatException) {}
        MSashTest.assertTrue((String)"Part1 data is not an integer", (cdVal1 != -1 ? 1 : 0) != 0);
        MSashTest.assertTrue((String)"Values should be equal", (cdVal0 == cdVal1 ? 1 : 0) != 0);
        this.testWeights(sash, 50.0, 50.0);
    }

    private void testWeights(MPartSashContainer sf, double w1, double w2) {
        double baseRatio = w1 / w2;
        MPart part0 = (MPart)sf.getChildren().get(0);
        MPart part1 = (MPart)sf.getChildren().get(1);
        int cdVal0 = -1;
        try {
            cdVal0 = Integer.parseInt(part0.getContainerData());
        }
        catch (NumberFormatException numberFormatException) {}
        MSashTest.assertTrue((String)"Part0 data is not an integer", (cdVal0 != -1 ? 1 : 0) != 0);
        int cdVal1 = -1;
        try {
            cdVal1 = Integer.parseInt(part1.getContainerData());
        }
        catch (NumberFormatException numberFormatException) {}
        MSashTest.assertTrue((String)"Part1 data is not an integer", (cdVal1 != -1 ? 1 : 0) != 0);
        this.checkRatio("MSashForm", cdVal0, cdVal1, baseRatio);
        SashForm sfw = (SashForm)sf.getWidget();
        int[] sfwWghts = sfw.getWeights();
        this.checkRatio("SWT SashForm", sfwWghts[0], sfwWghts[1], baseRatio);
        Composite c1 = (Composite)sfw.getChildren()[0];
        Composite c2 = (Composite)sfw.getChildren()[1];
        this.checkRatio("Control Bounds", c1.getSize().y, c2.getSize().y, baseRatio);
    }

    private void checkRatio(String label, int num, int div, double baseRatio) {
        double ratio = (double)num / (double)div;
        double TOLERANCE = 0.1;
        boolean withinTolerance = Math.abs(ratio - baseRatio) < TOLERANCE;
        MSashTest.assertTrue((String)("Ratio mismatch on" + label + "weights"), (boolean)withinTolerance);
    }

    private MWindow createSashWithNViews(int n) {
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        window.setHeight(300);
        window.setWidth(401);
        window.setLabel("MyWindow");
        MPartSashContainer sash = MApplicationFactory.eINSTANCE.createPartSashContainer();
        window.getChildren().add((Object)sash);
        int i = 0;
        while (i < n) {
            MPart contributedPart = MApplicationFactory.eINSTANCE.createPart();
            contributedPart.setLabel("Sample View" + i);
            contributedPart.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
            sash.getChildren().add((Object)contributedPart);
            ++i;
        }
        return window;
    }
}

